/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.opplugin.smartcs;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class SubjectSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            StringBuilder builder = new StringBuilder();
            Boolean isSubject = (Boolean)dataEntity.getValue("subject");
            if (isSubject.booleanValue()) {
                this.numberValidator(dataEntity, builder);
            }
            if (builder.length() <= 0) continue;
            this.addMessage(dataEntity, builder.toString(), ErrorLevel.Error);
        }
    }

    private void numberValidator(ExtendedDataEntity dataEntity, StringBuilder builder) {
        Long pkId = this.getPkId(dataEntity);
        Object number = dataEntity.getValue("subjectnum");
        QFilter qFilter1 = new QFilter("subjectnum", "=", number);
        QFilter qFilter2 = new QFilter("id", "!=", (Object)pkId);
        String entity = dataEntity.getDataEntity().getDataEntityType().getName();
        if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qFilter1, qFilter2})) {
            builder.append(ResManager.loadKDString((String)"\u7c7b\u76ee\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"SubjectSaveValidator_0", (String)"ssc-task-opplugin", (Object[])new Object[0]));
        }
    }

    private Long getPkId(ExtendedDataEntity dataEntity) {
        Object pkId = dataEntity.getBillPkId();
        if (pkId instanceof Long) {
            return (Long)pkId;
        }
        return 0L;
    }
}

