/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.deploy.DeployFile;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.bpmn.model.deploy.ExportScheme;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.scheme.enumeration.ImportType;
import kd.bos.workflow.engine.impl.scheme.model.ImportSchemeParameter;
import kd.bos.workflow.engine.impl.scheme.model.ProcessDiffResult;
import kd.bos.workflow.engine.impl.util.DynamicSchemeUtil;
import kd.bos.workflow.engine.impl.util.ImportExportProcessUtil;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;

public class WFProcessImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(WFProcessImpl.class);
    private final DcxmlSerializer serializer = new DcxmlSerializer(ExportScheme.getDCBinder());
    private static final String PROCESS_NUMBER = "key";

    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        if (sdpInputParams == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u6d41\u7a0b\u7ba1\u7406 \u5bfc\u51fa\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"WFProcessImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), "wf", "wf_processdefinition", this.getProcessName(), sdpOutputParams, "4730fc9f000004ae");
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        Map param = sdpInputParams.getParam();
        String entityName = (String)param.get("entityname");
        String entityNumber = (String)param.get("entitynumber");
        ListSelectedRowCollection rows = sdpInputParams.getSelectRows();
        if (rows.isEmpty()) {
            String filters = DataPacketHelper.getFilters(param);
            rows = CommonQuery.getAllSelectData((String)entityNumber, (String)filters);
        }
        int size = rows.size();
        String zipFilename = entityName + System.currentTimeMillis() + ".zip";
        String fullPath = WfUtils.checkPath((String)(sdpInputParams.getLocalPath() + File.separator + zipFilename));
        File zipFile = FileUtils.createFile((String)fullPath);
        StringBuilder selectedInfo = new StringBuilder();
        selectedInfo.append(String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        ArrayList<Long> errorDataIds = new ArrayList<Long>();
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            int i = 1;
            for (ListSelectedRow row : rows) {
                selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", i++, row.getNumber(), row.getName()));
                long id = (Long)row.getPrimaryKeyValue();
                DeployFile deployFile = null;
                try {
                    deployFile = this.getRepositoryService().getExportScheme(id);
                }
                catch (Exception e) {
                    errorDataIds.add(id);
                    String errorMsg = String.format(ResManager.loadKDString((String)"%1$s%2$s\u5bfc\u51fa\u65f6\u53d1\u751f\u5f02\u5e38\uff1a%3$s", (String)"WFProcessImpl_1", (String)"sys-ricc-business", (Object[])new Object[0]), entityName, id, CommonUtil.getExceptionDetailInfo((Throwable)e));
                    sdpOutputParams.getDevError().append(errorMsg);
                    logger.error(errorMsg);
                }
                if (errorDataIds.isEmpty() && deployFile != null) {
                    DataPacketHelper.exportWfToZipFile(out, deployFile);
                }
                ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)size, (int)i);
            }
            sdpOutputParams.setSuccess(true);
        }
        catch (Exception e) {
            sdpOutputParams.setSuccess(false);
            String msg = String.format(CommonConstant.getExportFileErrorTip(), entityName);
            sdpOutputParams.append(msg, (Throwable)e);
            logger.error(msg, (Throwable)e);
            return sdpOutputParams;
        }
        if (!errorDataIds.isEmpty()) {
            sdpOutputParams.setSuccess(false);
            ArrayList errProcessNumbers = new ArrayList();
            DynamicObjectCollection errModels = QueryServiceHelper.query((String)"wf_processdefinition", (String)PROCESS_NUMBER, (QFilter[])new QFilter("id", "in", errorDataIds).toArray());
            errModels.forEach(errModel -> errProcessNumbers.add(errModel.getString(PROCESS_NUMBER)));
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"%1$s\u53ef\u80fd\u5b58\u5728\u810f\u6570\u636e\u5bfc\u81f4\u5bfc\u51fa\u5931\u8d25, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770bmonitor\u65e5\u5fd7\u8fdb\u884c\u6392\u67e5\uff0c\u5f02\u5e38\u6570\u636eid\uff1a%2$s, \u5bf9\u5e94\u6d41\u7a0b\u7ba1\u7406\u7f16\u7801\uff1a%3$s", (String)"WFProcessImpl_2", (String)"sys-ricc-business", (Object[])new Object[0]), entityName, ((Object)errorDataIds).toString(), ((Object)errProcessNumbers).toString()));
        }
        sdpOutputParams.setSelectedInfo(selectedInfo.toString());
        if (sdpOutputParams.isSuccess()) {
            sdpOutputParams.setExportFilePath(zipFile.getAbsolutePath());
        }
        return sdpOutputParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        Map param = sdpInputParams.getParam();
        String fileUrl = (String)param.get("fileUrl");
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        DynamicObject guide = (DynamicObject)param.get("guideInfo");
        String entityName = guide.getString("name");
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), "wf", "wf_processdefinition", this.getProcessName(), sdpOutputParams, "47150e89000000ac", "4730fc9f000003ae");
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        ArrayList<ImportSchemeParameter> schemeParameters = new ArrayList<ImportSchemeParameter>(16);
        HashMap<String, String> processNumsMap = new HashMap<String, String>(16);
        int successCount = 0;
        int total = 0;
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        try {
            InputStream inputStream = fileService.getInputStream(fileUrl);
            Object object = null;
            try (ZipInputStream zipIn2 = new ZipInputStream((InputStream)new BufferedInputStream(inputStream), Charset.forName("GBK"));){
                ZipEntry zipEntry = null;
                while ((zipEntry = zipIn2.getNextEntry()) != null) {
                    ++total;
                    String name = zipEntry.getName();
                    try {
                        ImportSchemeParameter parameter = this.importSchemeFile(zipIn2, name, processNumsMap);
                        schemeParameters.add(parameter);
                    }
                    finally {
                        zipIn2.closeEntry();
                    }
                }
                if (schemeParameters.isEmpty()) {
                    sdpOutputParams.append(ResManager.loadKDString((String)"\u538b\u7f29\u4e2d\u4e0d\u5305\u542b\u6709\u6548\u7684\u65b9\u6848\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\uff01", (String)"WFProcessImpl_3", (String)"sys-ricc-business", (Object[])new Object[0]));
                }
            }
            catch (Throwable zipIn2) {
                object = zipIn2;
                throw zipIn2;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable zipIn2) {
                            ((Throwable)object).addSuppressed(zipIn2);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (KDBizException e) {
            logger.error((Throwable)e);
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u5904\u7406\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a%s", (String)"WFProcessImpl_4", (String)"sys-ricc-business", (Object[])new Object[0]), e.getMessage()));
            return sdpOutputParams;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u5904\u7406\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a%s", (String)"WFProcessImpl_4", (String)"sys-ricc-business", (Object[])new Object[0]), CommonUtil.getExceptionDetailInfo((Throwable)e)));
            return sdpOutputParams;
        }
        try {
            if (schemeParameters.isEmpty()) {
                sdpOutputParams.append(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u65b0\u5efa\u6216\u8986\u76d6\u7684\u6d41\u7a0b\uff01", (String)"WFProcessImpl_5", (String)"sys-ricc-business", (Object[])new Object[0]));
            }
            HashMap<String, String> procNumberContent = new HashMap<String, String>(schemeParameters.size());
            for (ImportSchemeParameter schemeParameter : schemeParameters) {
                String procNumberImportType = String.format("%1$s,%2$s", schemeParameter.getNumber(), schemeParameter.getImportType().toString());
                procNumberContent.put(procNumberImportType, schemeParameter.getSchemeContent());
            }
            if (this.checkMobileBillSummaryCfg(schemeParameters, procNumberContent, sdpOutputParams)) {
                List errors = this.getRepositoryService().importSchemes(schemeParameters);
                successCount = total - errors.size();
            }
        }
        catch (Exception e) {
            sdpOutputParams.setSuccess(false);
            String msg = String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6d41\u7a0b\u7ba1\u7406\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef\uff1a%s", (String)"WFProcessImpl_6", (String)"sys-ricc-business", (Object[])new Object[0]), e.getMessage());
            sdpOutputParams.append(msg, (Throwable)e);
            logger.error(msg, (Throwable)e);
        }
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        HashMap<String, Integer> params = new HashMap<String, Integer>(2);
        params.put("successCount", successCount);
        params.put("failedCount", total - successCount);
        sdpOutputParams.setParam(params);
        return sdpOutputParams;
    }

    private RepositoryService getRepositoryService() {
        return ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService();
    }

    private ImportSchemeParameter importSchemeFile(ZipInputStream zipIn, String filename, Map<String, String> processNums) throws IOException {
        if (!filename.endsWith(".scheme")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u542b\u6709\u4e0d\u5408\u6cd5\u7684\u6587\u4ef6\uff1a%s", (String)"WFProcessImpl_7", (String)"sys-ricc-business", (Object[])new Object[0]), filename));
        }
        String content = DataPacketHelper.getZipFileContent(zipIn);
        ImportSchemeParameter parameter = new ImportSchemeParameter();
        parameter.setFilename(filename);
        if (WfUtils.isEmpty((String)content)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s \u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff01", (String)"WFProcessImpl_8", (String)"sys-ricc-business", (Object[])new Object[0]), filename));
        }
        this.serializer.setColloctionIgnorePKValue(true);
        ExportScheme exportScheme = (ExportScheme)this.serializer.deserializeFromString(content, null);
        if (exportScheme == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u6587\u4ef6 %s \u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u662f\u5426\u662f\u6709\u6548\u7684scheme\u6587\u4ef6\uff01", (String)"WFProcessImpl_9", (String)"sys-ricc-business", (Object[])new Object[0]), filename));
        }
        parameter.setSchemeContent(content);
        List processDefinitions = exportScheme.getProcessDefinitions();
        DynamicObject processDefinition = (DynamicObject)processDefinitions.get(0);
        String entrabill = processDefinition.getString("entrabill");
        String number = processDefinition.getString(PROCESS_NUMBER);
        String existFileName = processNums.get(number);
        if (!StringUtils.isEmpty((String)existFileName)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%1$s\u201d\u4e0e\u201c%2$s\u201d\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u6d41\u7a0b\u7f16\u7801\u201c%3$s\u201d, \u4e0d\u5141\u8bb8\u5bfc\u5165\uff0c\u8bf7\u60a8\u91cd\u65b0\u6253\u5305\u53bb\u6389\u91cd\u590d\u7684\u6570\u636e\u540e\u518d\u8bd5", (String)"WFProcessImpl_14", (String)"sys-ricc-business", (Object[])new Object[0]), filename, existFileName, number));
        }
        processNums.put(number, filename);
        QFilter[] filters = new QFilter[]{new QFilter(PROCESS_NUMBER, "=", (Object)number), new QFilter("entrabill", "!=", (Object)entrabill)};
        if (QueryServiceHelper.exists((String)"wf_processdefinition", (QFilter[])filters)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u6d41\u7a0b\u7f16\u7801\u4e3a %s \u7684\u5176\u4ed6\u5355\u636e\u6d41\u7a0b\uff0c\u5355\u636e\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"WFProcessImpl_10", (String)"sys-ricc-business", (Object[])new Object[0]), number));
        }
        ImportExportProcessUtil.checkProcessTypeConsistent((String)number, (String)processDefinition.getString("type"), (boolean)true);
        parameter.setName(processDefinition.getString("name"));
        parameter.setNumber(processDefinition.getString(PROCESS_NUMBER));
        parameter.setImportType(ImportType.getImportType((String)"CREATE"));
        RepositoryService service = this.getRepositoryService();
        ProcessDefinitionEntity latestProcDef = service.getLatestProcessDefinitionByKey((String)processDefinition.get(PROCESS_NUMBER));
        if (latestProcDef != null) {
            ResourceEntity resource = service.getResourceById(latestProcDef.getResourceId());
            ProcessDiffResult result = DynamicSchemeUtil.diffProcessNodes((String)resource.getData(), (String)this.getDefaultSchemeResource(exportScheme));
            parameter.setDiffResult(result);
        }
        return parameter;
    }

    private String getDefaultSchemeResource(ExportScheme exportScheme) {
        List schemes = exportScheme.getSchemes();
        List resources = exportScheme.getResources();
        for (DynamicObject scheme : schemes) {
            if (!scheme.getBoolean("isdefault")) continue;
            Long resourceId = scheme.getLong("jsonresourceid");
            for (DynamicObject resource : resources) {
                if (!resourceId.equals(resource.get("id"))) continue;
                String data = resource.getString("data");
                return WfUtils.isNotEmpty((String)data) ? data : resource.getString("content");
            }
        }
        return null;
    }

    private boolean checkMobileBillSummaryCfg(List<ImportSchemeParameter> schemeParameters, Map<String, String> procNumberContent, SdpOutputParams sdpOutputParams) {
        if (procNumberContent == null || procNumberContent.isEmpty()) {
            return true;
        }
        StringBuilder sameEntityMbSummaryNumbers = new StringBuilder();
        StringBuilder notSameEntityMbSummaryNumbers = new StringBuilder();
        for (Map.Entry<String, String> entry : procNumberContent.entrySet()) {
            String procNumber = entry.getKey().split(",")[0];
            String importType = entry.getKey().split(",")[1];
            String schemeContent = entry.getValue();
            ExportScheme exportScheme = (ExportScheme)this.serializer.deserializeFromString(schemeContent, null);
            List mobileBillSummarys = exportScheme.getMobileBillSummaryCfg();
            if (mobileBillSummarys == null || mobileBillSummarys.isEmpty()) continue;
            StringBuilder sameMbSummaryNumbers = new StringBuilder();
            StringBuilder notSameMbSummaryNumbers = new StringBuilder();
            this.getTargetMobileBillSummarys(mobileBillSummarys, importType, sameMbSummaryNumbers, notSameMbSummaryNumbers);
            if (sameMbSummaryNumbers.length() > 1) {
                String mbSummaryNumbers = sameMbSummaryNumbers.substring(0, sameMbSummaryNumbers.length() - 1);
                sameEntityMbSummaryNumbers.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u3010%1$s\u3011\u4e2d\u7684\u79fb\u52a8\u5355\u636e\u6458\u8981\u8bbe\u7f6e\u3010%2$s\u3011\uff0c", (String)"WFProcessImpl_11", (String)"sys-ricc-business", (Object[])new Object[0]), procNumber, mbSummaryNumbers));
                for (ImportSchemeParameter schemeParameter : schemeParameters) {
                    if (!procNumber.equals(schemeParameter.getNumber())) continue;
                    schemeParameter.setCoverSummaryCfg(Boolean.TRUE);
                }
            }
            if (notSameMbSummaryNumbers.length() <= 1) continue;
            String summaryNumbers = notSameMbSummaryNumbers.substring(0, notSameMbSummaryNumbers.length() - 1);
            notSameEntityMbSummaryNumbers.append(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u3010%1$s\u3011\u4e2d\u7684\u79fb\u52a8\u5355\u636e\u6458\u8981\u8bbe\u7f6e\u3010%2$s\u3011\uff0c", (String)"WFProcessImpl_11", (String)"sys-ricc-business", (Object[])new Object[0]), procNumber, summaryNumbers));
        }
        if (notSameEntityMbSummaryNumbers.length() > 1) {
            String errorNotification = String.format(ResManager.loadKDString((String)"%s\u5df2\u7ecf\u5b58\u5728\uff0c\u4f46\u5bf9\u5e94\u7684\u5355\u636e\u5b9e\u4f53\u4e0d\u76f8\u540c\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\uff0c\u8bf7\u4fee\u6539\u7f16\u7801\u540e\u518d\u5c1d\u8bd5\u5bfc\u5165\u3002", (String)"WFProcessImpl_12", (String)"sys-ricc-business", (Object[])new Object[0]), notSameEntityMbSummaryNumbers.substring(0, notSameEntityMbSummaryNumbers.length() - 1));
            sdpOutputParams.append(errorNotification);
            return false;
        }
        return true;
    }

    private void getTargetMobileBillSummarys(List<DynamicObject> mobileBillSummarys, String importType, StringBuilder sameMbSummaryNumbers, StringBuilder notSameMbSummaryNumbers) {
        for (DynamicObject mobileBillSummary : mobileBillSummarys) {
            QFilter filter3;
            boolean existsNotSameEntityMbSummary;
            String billType;
            QFilter filter2;
            String summaryNumber = mobileBillSummary.getString("number");
            QFilter filter1 = new QFilter("number", "=", (Object)summaryNumber);
            boolean existsSameEntityMbSummary = QueryServiceHelper.exists((String)"wf_mbillsummary_cfg", (QFilter[])new QFilter[]{filter1, filter2 = new QFilter("billtype", "=", (Object)(billType = mobileBillSummary.getString("billtype_id")))});
            if (existsSameEntityMbSummary && !ImportType.DONOTHING.toString().equals(importType)) {
                sameMbSummaryNumbers.append(summaryNumber).append('\uff0c');
            }
            if (!(existsNotSameEntityMbSummary = QueryServiceHelper.exists((String)"wf_mbillsummary_cfg", (QFilter[])new QFilter[]{filter1, filter3 = new QFilter("billtype", "!=", (Object)billType)})) || ImportType.DONOTHING.toString().equals(importType)) continue;
            notSameMbSummaryNumbers.append(summaryNumber).append('\uff0c');
        }
    }

    private String getProcessName() {
        return ResManager.loadKDString((String)"\u6d41\u7a0b\u7ba1\u7406", (String)"WFProcessImpl_13", (String)"sys-ricc-business", (Object[])new Object[0]);
    }
}

