/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.parameter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.svc.util.TreeNodeFilter;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.util.FormViewUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;

public class SysParamTransferFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
BeforeF7SelectListener,
SearchEnterListener,
TabSelectListener {
    private static final String SYS_TREE_KEY = "systreeviewap";
    private static final String APP_TREE_KEY = "apptreeviewap";
    private static final String PUBLIC_PARAMETER_ID = "public_parameter";
    private static final String APP_TREE_NODE_CACHE = "app_treenodecache";
    private static final String SYS_TREE_NODE_CACHE = "sys_treenodecache";
    private static final String CLOUD = "CLOUD";
    private static final String APP = "APP";
    private static final String FIELD_ORG = "org";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String FIELDS = "fields";
    private static final String FIELDS_NAME = "fieldsname";
    private static final String PARAM_OBJ = "paramobj";
    private static final String SEARCH_TEXT_TIME = "searchText_time";
    private static final String FAST_TRANSFER_KEY = "fasttransfer";
    private static final String ADD_PACKET_KEY = "addpacket";
    private static final String FAST_TRANSFER_ACTION_KEY = "fasttransfer_action";
    private static final String ADD_PACKET_ACTION_KEY = "addpacket_action";
    private static final String APP_ID = "appId";
    private static final String TAB_KEY = "tabKey";
    private static final String SYS_LEFT_PANEL = "sysleftpanel";
    private static final String SYS_RIGHT_PANEL = "sysrightpanel";
    private static final String APP_LEFT_PANEL = "appleftpanel";
    private static final String APP_RIGHT_PANEL = "apprightpanel";
    private static final String TAB_PAGE_APP = "tabpageapp";
    private static final String SYS_SHOW_PANEL = "sysshowpanel";
    private static final String SYS_PARAM = "sysparam";

    public void registerListener(EventObject e) {
        TreeView tree = (TreeView)this.getControl(SYS_TREE_KEY);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView appTree = (TreeView)this.getControl(APP_TREE_KEY);
        appTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl(FIELD_ORG);
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit fieldsName = (TextEdit)this.getControl(FIELDS_NAME);
        fieldsName.addButtonClickListener((ClickListener)this);
        Tab tab = (Tab)this.getView().getControl("tabgroupap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.addPacketBtStatusProcess();
        String tabKey = this.getPageCache().get(TAB_KEY);
        if (TAB_PAGE_APP.equals(tabKey)) {
            this.appTabSelect();
        } else {
            this.sysTabSelect();
        }
    }

    private void addPacketBtStatusProcess() {
        boolean canAddPacket = SysParaUtil.canAddPacket();
        if (canAddPacket) {
            FormViewUtil.cleanButtonTips((IFormView)this.getView(), (String[])new String[]{FAST_TRANSFER_KEY, ADD_PACKET_KEY});
        }
        this.getView().setEnable(Boolean.valueOf(canAddPacket), new String[]{FAST_TRANSFER_KEY, ADD_PACKET_KEY});
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String oldTabKey;
        String tabKey = tabSelectEvent.getTabKey();
        if (StringUtils.equals((String)tabKey, (String)(oldTabKey = this.getPageCache().get(TAB_KEY)))) {
            return;
        }
        this.getView().getPageCache().put(TAB_KEY, tabKey);
        if (TAB_PAGE_APP.equals(tabKey)) {
            this.appTabSelect();
        } else {
            this.sysTabSelect();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        EntryGrid entryGrid;
        int[] selectRows;
        String key = evt.getItemKey();
        if ((ADD_PACKET_KEY.equals(key) || FAST_TRANSFER_KEY.equals(key)) && (selectRows = (entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY)).getSelectRows()).length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u4f20\u8f93\u7684\u6570\u636e", (String)"SysParamTransferFormPlugin_3", (String)"sys-ricc-business", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            String tabKey = this.getPageCache().get(TAB_KEY);
            if (TAB_PAGE_APP.equals(tabKey)) {
                this.appTabSelect();
            } else {
                this.sysTabSelect();
            }
        } else if (ADD_PACKET_KEY.equalsIgnoreCase(itemKey) || FAST_TRANSFER_KEY.equals(itemKey)) {
            String actionId = ADD_PACKET_ACTION_KEY;
            if (FAST_TRANSFER_KEY.equals(itemKey)) {
                actionId = FAST_TRANSFER_ACTION_KEY;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(actionId, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7cfb\u7edf\u53c2\u6570\u662f\u63a7\u5236\u7cfb\u7edf\u6d41\u7a0b\u7684\u6838\u5fc3\u914d\u7f6e\u6570\u636e\uff0c\u914d\u7f6e\u5f02\u5e38\u5c06\u4f1a\u9020\u6210\u7cfb\u7edf\u7ea7\u9519\u8bef\uff0c\u5efa\u8bae\u4ec5\u521d\u59cb\u5316\u65f6\u5168\u91cf\u540c\u6b65\u3002\u5176\u4e2d\u5916\u90e8\u94fe\u63a5\u5730\u5740\u3001\u5bc6\u94a5\u7b49\u4fe1\u606f\u5404\u73af\u5883\u5747\u4e0d\u4e00\u81f4\uff0c\u4f20\u8f93\u8986\u76d6\u540e\u53ef\u80fd\u9020\u6210\u9519\u8bef\u3002\u8bf7\u518d\u6b21\u786e\u8ba4\u662f\u5426\u4f20\u8f93\u6240\u9009\u53c2\u6570\uff1f", (String)"SysParamTransferFormPlugin_5", (String)"sys-ricc-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    private Map<String, Object> getCustomParam() {
        IFormView view = this.getView();
        EntryGrid entry = (EntryGrid)view.getControl(ENTRY_ENTITY);
        int[] rows = entry.getSelectRows();
        int count = rows.length;
        HashMap<String, Object> returnMap = new HashMap<String, Object>(count);
        for (int i = 0; i < count; ++i) {
            int index = rows[i];
            String id = (String)view.getModel().getValue("id", index);
            String appId = (String)view.getModel().getValue("app_id", index);
            String sysId = (String)view.getModel().getValue("sys_id", index);
            DynamicObjectCollection orgCol = (DynamicObjectCollection)view.getModel().getValue(FIELD_ORG, index);
            String orgIdString = orgCol.stream().map(org -> org.getString("fbasedataid_id")).collect(Collectors.joining(","));
            String fields = (String)view.getModel().getValue(FIELDS, index);
            String paramObjId = (String)view.getModel().getValue("paramobj_id", index);
            HashMap<String, String> dataMap = new HashMap<String, String>(4);
            dataMap.put("appid", appId);
            dataMap.put(FIELD_ORG, orgIdString);
            dataMap.put(FIELDS, fields);
            dataMap.put("sys_id", sysId);
            dataMap.put(PARAM_OBJ, paramObjId);
            String sysShowPanel = (String)view.getModel().getValue(SYS_SHOW_PANEL, index);
            dataMap.put("sysShowFields", sysShowPanel);
            returnMap.put(id, dataMap);
        }
        return returnMap;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String f7FiledKey = arg0.getProperty().getName();
        if (FIELD_ORG.equals(f7FiledKey)) {
            ListShowParameter listShowParameter = (ListShowParameter)arg0.getFormShowParameter();
            int selectRowIndex = this.getCurrentEditIndex();
            Object id = this.getModel().getValue("id", selectRowIndex);
            Object appId = this.getModel().getValue("app_id", selectRowIndex);
            QFilter qf = new QFilter("fparamid", "=", id);
            DynamicObjectCollection parameterCol = QueryServiceHelper.query((String)"bos_svc_sysparameter", (String)"fparamid,fviewtypeid,forgid", (QFilter[])qf.toArray());
            AppInfo appInfo = EntityMetadataCache.getAppInfo((String)appId.toString());
            if (appInfo != null && StringUtils.isNotBlank((CharSequence)appInfo.getOrgFunc())) {
                listShowParameter.setCustomParam("orgFuncId", (Object)appInfo.getOrgFunc());
            } else {
                listShowParameter.setCustomParam("orgFuncId", null);
            }
            ArrayList orgIds = new ArrayList(parameterCol.size());
            parameterCol.forEach(parameter -> orgIds.add(parameter.getLong("forgid")));
            QFilter f = new QFilter("id", "in", orgIds);
            listShowParameter.getListFilterParameter().setFilter(f);
        }
    }

    private int getCurrentEditIndex() {
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryEntity.getSelectRows();
        return selectRows[0];
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("selectParams".equalsIgnoreCase(actionId)) {
            Map data = (Map)closedCallBackEvent.getReturnData();
            if (data != null) {
                String fields = data.get("selectedFields").toString();
                String selectedFieldsName = data.get("selectedFieldsName").toString();
                int selectRowIndex = this.getCurrentEditIndex();
                this.getModel().setValue(FIELDS, (Object)fields, selectRowIndex);
                this.getModel().setValue(FIELDS_NAME, (Object)selectedFieldsName, selectRowIndex);
            }
        } else if ("addPacketClose".equalsIgnoreCase(actionId) && "success".equals(returnData = closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u6210\u529f", (String)"SysParamTransferFormPlugin_4", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((String)FIELDS_NAME, (String)source.getKey())) {
            int selectRowIndex = this.getCurrentEditIndex();
            DynamicObject bizObj = (DynamicObject)this.getModel().getValue(PARAM_OBJ, selectRowIndex);
            String selectedFields = (String)this.getModel().getValue(FIELDS, selectRowIndex);
            String sysShowPanel = (String)this.getModel().getValue(SYS_SHOW_PANEL, selectRowIndex);
            this.showSelectForm(bizObj.getString("id"), selectedFields, sysShowPanel);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        String newValue = e.getChangeSet()[0].getNewValue().toString();
        if (FIELDS_NAME.equals(fieldKey) && StringUtils.isEmpty((String)newValue)) {
            int currentEditIndex = this.getCurrentEditIndex();
            this.getModel().setValue(FIELDS, (Object)"", currentEditIndex);
        }
    }

    private void showSelectForm(String paramFormId, String selectedFields, String sysShowPanel) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ricc_sysparam_fieldselect");
        parameter.setCustomParam("paramFormId", (Object)paramFormId);
        parameter.setCustomParam("selectedFields", (Object)selectedFields);
        parameter.setCustomParam("sysShowPanel", (Object)sysShowPanel);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectParams"));
        this.getView().showForm(parameter);
    }

    public void loadAppParameterEntry(List<String> appIdList) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getView().setVisible(Boolean.TRUE, new String[]{"cloud", "app", PARAM_OBJ, FIELD_ORG});
        this.getView().setVisible(Boolean.FALSE, new String[]{SYS_PARAM});
        List<Map<String, String>> parameterList = this.loadAppParameterList(appIdList);
        if (parameterList == null || parameterList.isEmpty()) {
            return;
        }
        List<String> treeAppIdList = this.getTreeAppIdList();
        parameterList.sort(Comparator.comparingInt(o -> treeAppIdList.indexOf(o.get(APP_ID))));
        parameterList.removeIf(p -> !treeAppIdList.contains(p.get(APP_ID)) && !StringUtils.isEmpty((String)((String)p.get(APP_ID))));
        DynamicObjectType entryType = this.getModel().getEntryEntity(ENTRY_ENTITY).getDynamicObjectType();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRY_ENTITY);
        for (Map<String, String> parameter : parameterList) {
            String id = parameter.get("id");
            String appIdStr = parameter.get(APP_ID);
            String formId = parameter.get("formId");
            DynamicObject entryObj = new DynamicObject(entryType);
            entryObj.set("id", (Object)id);
            entryObj.set("app_id", (Object)appIdStr);
            entryObj.set("paramobj_id", (Object)formId);
            entryColl.add((Object)entryObj);
        }
        this.getModel().updateEntryCache(entryColl);
        this.getModel().updateCache();
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void loadSysParameterEntry(long id) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        if (id > 0L) {
            qFilter.and(new QFilter("id", "=", (Object)id));
        }
        Map bosSysParamGroup = BusinessDataServiceHelper.loadFromCache((String)"bos_sysparam_group", (String)"id,number,name,param_formid,plugins,pluginparam", (QFilter[])qFilter.toArray(), (String)"sort asc");
        String paramFormIdStr = bosSysParamGroup.values().stream().map(p -> p.getString("param_formid")).collect(Collectors.joining("','"));
        String sql = " SELECT FID,FCLOUDID, FAPPID, FFORMID, FACCTBOOKENABLED FROM T_BAS_SYSPARACONSOLE WHERE FFORMID in ('" + paramFormIdStr + "')";
        Map paramMap = (Map)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, null, rs -> {
            HashMap param = new HashMap(16);
            while (rs.next()) {
                HashMap<String, String> item = new HashMap<String, String>(16);
                item.put("id", rs.getString("FID"));
                item.put("cloudId", rs.getString("FCLOUDID"));
                item.put(APP_ID, rs.getString("FAPPID"));
                item.put("formId", rs.getString("FFORMID"));
                item.put("facctbookenabled", rs.getString("FACCTBOOKENABLED"));
                param.put(rs.getString("FFORMID"), item);
            }
            return param;
        });
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getView().setVisible(Boolean.FALSE, new String[]{"cloud", "app", PARAM_OBJ, FIELD_ORG});
        this.getView().setVisible(Boolean.TRUE, new String[]{SYS_PARAM});
        DynamicObjectType entryType = this.getModel().getEntryEntity(ENTRY_ENTITY).getDynamicObjectType();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity(ENTRY_ENTITY);
        int i = 0;
        for (DynamicObject sysParam : bosSysParamGroup.values()) {
            String idStr = sysParam.getString("id");
            String formId = sysParam.getString("param_formid");
            DynamicObject entryObj = new DynamicObject(entryType);
            entryObj.set("id", (Object)idStr);
            Map paramConsoleInfo = (Map)paramMap.get(formId);
            if (paramConsoleInfo != null && !paramConsoleInfo.isEmpty()) {
                entryObj.set("app_id", paramConsoleInfo.get(APP_ID));
                entryObj.set("sys_id", paramConsoleInfo.get("id"));
            }
            entryObj.set(SYS_SHOW_PANEL, (Object)sysParam.getString("pluginparam"));
            entryObj.set("paramobj_id", (Object)formId);
            entryObj.set(SYS_PARAM, (Object)sysParam.getLocaleString("name").getLocaleValue());
            if ("bos_customparam_view".equals(formId)) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{FIELDS_NAME});
            }
            ++i;
            entryColl.add((Object)entryObj);
        }
        this.getModel().updateEntryCache(entryColl);
        this.getModel().updateCache();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private List<String> getTreeAppIdList() {
        ArrayList<String> treeAppIdList = new ArrayList<String>(16);
        String treeNodeFromCache = this.getPageCache().get(APP_TREE_NODE_CACHE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeFromCache, TreeNode.class);
        List cloudNode = root.getChildren();
        ArrayList appNode = new ArrayList();
        for (TreeNode cloud : cloudNode) {
            if (cloud.getChildren() == null) continue;
            appNode.addAll(cloud.getChildren());
        }
        for (TreeNode app : appNode) {
            treeAppIdList.add(app.getId());
        }
        return treeAppIdList;
    }

    private List<Map<String, String>> loadAppParameterList(List<String> appIdList) {
        String sql = " SELECT FID,FCLOUDID, FAPPID, FFORMID, FACCTBOOKENABLED FROM T_BAS_SYSPARACONSOLE WHERE FENABLED = '1' AND FFORMID IS NOT NULL ";
        sql = appIdList == null || appIdList.isEmpty() ? sql + " AND FCLOUDID= ' ' AND FAPPID != ' ' " : sql + " AND FCLOUDID= ' ' AND FAPPID IN ('" + String.join((CharSequence)"','", appIdList) + "')";
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
            ArrayList list = new ArrayList(16);
            while (rs.next()) {
                HashMap<String, String> item = new HashMap<String, String>(16);
                item.put("id", rs.getString("FID"));
                item.put("cloudId", rs.getString("FCLOUDID"));
                item.put(APP_ID, rs.getString("FAPPID"));
                item.put("formId", rs.getString("FFORMID"));
                item.put("facctbookenabled", rs.getString("FACCTBOOKENABLED"));
                list.add(item);
            }
            return list;
        });
    }

    private void queryAppBindParameter(TreeNode node) {
        Object nodeData = node.getData();
        if (APP.equalsIgnoreCase(nodeData.toString())) {
            ArrayList<String> appIdList = new ArrayList<String>(1);
            appIdList.add(node.getId());
            this.loadAppParameterEntry(appIdList);
        } else if (CLOUD.equalsIgnoreCase(nodeData.toString())) {
            List<String> appIdList = node.getChildren().stream().map(TreeNode::getId).collect(Collectors.toList());
            this.loadAppParameterEntry(appIdList);
        } else {
            this.loadAppParameterEntry(null);
        }
    }

    private void appTabSelect() {
        this.getView().setVisible(Boolean.TRUE, new String[]{APP_LEFT_PANEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{SYS_LEFT_PANEL});
        String treeNodeCache = this.getPageCache().get(APP_TREE_NODE_CACHE);
        if (StringUtils.isBlank((CharSequence)treeNodeCache)) {
            this.buildAppTreeNode();
        }
        TreeView tree = (TreeView)this.getView().getControl(APP_TREE_KEY);
        tree.focusNode(this.getRootNode());
        this.loadAppParameterEntry(null);
    }

    private void sysTabSelect() {
        this.getView().setVisible(Boolean.FALSE, new String[]{APP_LEFT_PANEL, APP_RIGHT_PANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{SYS_LEFT_PANEL, SYS_RIGHT_PANEL});
        String treeNodeCache = this.getPageCache().get(SYS_TREE_NODE_CACHE);
        if (StringUtils.isBlank((CharSequence)treeNodeCache)) {
            this.buildSysTreeNode();
        }
        TreeView tree = (TreeView)this.getView().getControl(SYS_TREE_KEY);
        tree.focusNode(this.getRootNode());
        this.loadSysParameterEntry(0L);
    }

    private void buildAppTreeNode() {
        TreeNode root = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)true, (boolean)true, (boolean)false);
        if (root != null) {
            this.filterCloudAndAppNodes(root);
            root.setId("/biz");
            root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"SysParamTransferFormPlugin_0", (String)"sys-ricc-business", (Object[])new Object[0]));
            root.setParentid("");
            root.setIsOpened(true);
            List<String> clouds = this.getExistCloudApps(true);
            List<String> apps = this.getExistCloudApps(false);
            Map bizApps = BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("id", "in", apps).and(new QFilter("deploystatus", "=", (Object)"2"))});
            Iterator it = bizApps.entrySet().iterator();
            ArrayList<String> realApps = new ArrayList<String>(10);
            while (it.hasNext()) {
                DynamicObject app = (DynamicObject)it.next().getValue();
                realApps.add(app.getPkValue().toString());
            }
            this.filterCloudAndApp(root, clouds, realApps);
            this.getPageCache().put(APP_TREE_NODE_CACHE, SerializationUtils.toJsonString((Object)root));
            TreeView tree = (TreeView)this.getView().getControl(APP_TREE_KEY);
            tree.deleteAllNodes();
            tree.addNode(root);
        }
    }

    private void filterCloudAndAppNodes(TreeNode root) {
        List cloudNodes = root.getChildren();
        TreeNodeFilter treeNodeFilter = new TreeNodeFilter();
        cloudNodes = treeNodeFilter.filterCloudTreeNode(cloudNodes);
        root.setChildren(cloudNodes);
        for (TreeNode cloudNode : cloudNodes) {
            List appNodes = cloudNode.getChildren();
            if (appNodes == null || appNodes.isEmpty()) continue;
            appNodes = treeNodeFilter.filterAppTreeNode(appNodes);
            cloudNode.setChildren(appNodes);
        }
    }

    private void buildSysTreeNode() {
        Map bosSysParamGroup = BusinessDataServiceHelper.loadFromCache((String)"bos_sysparam_group", (String)"id,number,name,param_formid,plugins,pluginparam", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C")}, (String)"sort asc");
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(bosSysParamGroup.size());
        for (DynamicObject dyObj : bosSysParamGroup.values()) {
            TreeNode commonChildNode = new TreeNode();
            commonChildNode.setId(dyObj.getString("id"));
            commonChildNode.setText(dyObj.getLocaleString("name").getLocaleValue());
            commonChildNode.setParentid("");
            nodes.add(commonChildNode);
        }
        TreeNode root = this.getRootNode();
        root.addChildren(nodes);
        TreeView tree = (TreeView)this.getView().getControl(SYS_TREE_KEY);
        tree.deleteAllNodes();
        tree.addNode(root);
    }

    private TreeNode getRootNode() {
        TreeNode root = new TreeNode();
        root.setId("/biz");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"SysParamTransferFormPlugin_0", (String)"sys-ricc-business", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    private void filterCloudAndApp(TreeNode root, List<String> clouds, List<String> apps) {
        if (root.getChildren() == null) {
            return;
        }
        Iterator cloudIt = root.getChildren().iterator();
        while (cloudIt.hasNext()) {
            TreeNode cloud = (TreeNode)cloudIt.next();
            if (cloud.getId().equalsIgnoreCase(PUBLIC_PARAMETER_ID)) continue;
            Iterator appIt = cloud.getChildren().iterator();
            while (appIt.hasNext()) {
                TreeNode app = (TreeNode)appIt.next();
                if (!apps.contains(app.getId())) {
                    appIt.remove();
                    continue;
                }
                if (!"83bfebc8000037ac".equals(app.getId())) continue;
                appIt.remove();
            }
            if (!cloud.getChildren().isEmpty() || clouds.contains(cloud.getId())) continue;
            cloudIt.remove();
        }
    }

    private List<String> getExistCloudApps(boolean isCloud) {
        String field = "FCLOUDID";
        if (!isCloud) {
            field = "FAPPID";
        }
        String sql = "select distinct " + field + " from t_bas_sysparaconsole where FENABLED ='1'";
        String finalField = field;
        return (List)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
            ArrayList<String> list = new ArrayList<String>(16);
            while (rs.next()) {
                String system = rs.getString(finalField);
                if (!StringUtils.isNotBlank((CharSequence)system)) continue;
                list.add(system);
            }
            return list;
        });
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeView treeView = (TreeView)this.getControl(APP_TREE_KEY);
        String searchText = searchEnterEvent.getText();
        String searchTextFormCache = this.getPageCache().get("searchText");
        String treeNodeFromCache = this.getPageCache().get(APP_TREE_NODE_CACHE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeFromCache, TreeNode.class);
        List cloudNode = root.getChildren();
        ArrayList appNode = new ArrayList();
        for (TreeNode tn : cloudNode) {
            if (tn.getChildren() == null) continue;
            appNode.addAll(tn.getChildren());
        }
        ArrayList<Object> allNode = new ArrayList<Object>();
        allNode.add(root);
        allNode.addAll(cloudNode);
        allNode.addAll(appNode);
        if (searchText.equals(searchTextFormCache)) {
            this.searchByPageCache(treeView);
        } else {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (TreeNode treeNode : allNode) {
                if (!treeNode.getText().contains(searchText)) continue;
                list.add(treeNode);
            }
            if (list.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0e\u201c%s\u201d\u7684\u76f8\u5173\u6570\u636e", (String)"SysParamTransferFormPlugin_2", (String)"sys-ricc-business", (Object[])new Object[0]), searchText));
            } else {
                TreeNode focusNode = (TreeNode)list.get(0);
                treeView.focusNode(focusNode);
                this.appTreeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put("searchText", searchText);
                this.getPageCache().put(SEARCH_TEXT_TIME, "1");
                this.getPageCache().put("searchData", SerializationUtils.toJsonString(list));
            }
        }
    }

    private void searchByPageCache(TreeView treeView) {
        List listFormCache;
        String searchDataString;
        String searchTextTimeString = this.getPageCache().get(SEARCH_TEXT_TIME);
        int searchTextTime = 1;
        if (StringUtils.isNotBlank((CharSequence)searchTextTimeString)) {
            searchTextTime = Integer.parseInt(searchTextTimeString);
        }
        if ((searchDataString = this.getPageCache().get("searchData")) != null && !(listFormCache = SerializationUtils.fromJsonStringToList((String)searchDataString, TreeNode.class)).isEmpty()) {
            if (listFormCache.size() > searchTextTime) {
                TreeNode focusNode = (TreeNode)listFormCache.get(searchTextTime);
                treeView.focusNode(focusNode);
                this.appTreeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put(SEARCH_TEXT_TIME, String.valueOf(searchTextTime + 1));
            } else {
                TreeNode focusNode = (TreeNode)listFormCache.get(0);
                treeView.focusNode(focusNode);
                this.appTreeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put(SEARCH_TEXT_TIME, "1");
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String tabKey = this.getPageCache().get(TAB_KEY);
        if (TAB_PAGE_APP.equals(tabKey)) {
            this.appTreeNodeClick(evt.getNodeId().toString());
        } else {
            this.sysTreeNodeClick(evt.getNodeId().toString());
        }
    }

    private void appTreeNodeClick(String nodeId) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(APP_TREE_NODE_CACHE), TreeNode.class);
        if (!root.getId().equalsIgnoreCase(nodeId)) {
            TreeNode checkedNode = root.getTreeNode(nodeId, 10);
            TreeView tree = (TreeView)this.getControl(APP_TREE_KEY);
            tree.focusNode(checkedNode);
            this.queryAppBindParameter(checkedNode);
        } else {
            this.loadAppParameterEntry(null);
        }
    }

    private void sysTreeNodeClick(String nodeId) {
        if ("/biz".equals(nodeId)) {
            this.loadSysParameterEntry(0L);
        } else {
            this.loadSysParameterEntry(Long.parseLong(nodeId));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        Map<String, Object> customParam = this.getCustomParam();
        ListSelectedRowCollection listSelectedRows = this.getListSelectedRows();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object guideId = formShowParameter.getCustomParam("guideId");
        if (guideId == null || StringUtils.isEmpty((String)guideId.toString())) {
            DynamicObject sysParamTransfer = ConfigItemHelper.queryGuideByNumber((Object)"bos_parameterconsole", (String)"id,name");
            formShowParameter.setCustomParam("riccFormId", (Object)"bos_parameterconsole");
            formShowParameter.setCustomParam("packettype", (Object)DataPacketTypeEnum.CONFIG.getVal());
            formShowParameter.setCustomParam("guideId", sysParamTransfer.get("id"));
            formShowParameter.setCustomParam("guideName", (Object)sysParamTransfer.getString("name"));
            formShowParameter.setCustomParam("canAddPacket", (Object)Boolean.TRUE);
        }
        if (ADD_PACKET_ACTION_KEY.equalsIgnoreCase(callBackId)) {
            ConfigItemHelper.openAddPacketForm((ListSelectedRowCollection)listSelectedRows, (String)this.getView().getPageId(), customParam, (IFormView)this.getView(), (String)this.getPluginName());
        } else if (FAST_TRANSFER_ACTION_KEY.equals(callBackId)) {
            ConfigItemHelper.openAddTransferForm((ListSelectedRowCollection)listSelectedRows, (String)this.getView().getPageId(), customParam, (IFormView)this.getView(), (String)this.getPluginName());
        }
    }

    private ListSelectedRowCollection getListSelectedRows() {
        EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] rows = entry.getSelectRows();
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        for (int row : rows) {
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue(this.getModel().getValue("id", row));
            listSelectedRows.add((Object)listSelectedRow);
        }
        return listSelectedRows;
    }
}

