/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.parameter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;

public class SysParameterSelectPlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
F7SelectedListRemoveListener {
    private static final String TREE_KEY = "treeviewap";
    private static final String F7LIST = "f7selectedlistap";
    private static final String BTN_OK = "btnok";
    private static final String SELECTED_FIELDS = "selectedFields";
    private static final String ENTITY_META = "entitymeta";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
        TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7LIST);
        f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String paramId = (String)this.getView().getFormShowParameter().getCustomParam("paramFormId");
        String fieldStr = (String)this.getView().getFormShowParameter().getCustomParam(SELECTED_FIELDS);
        String sysShowPanel = (String)this.getView().getFormShowParameter().getCustomParam("sysShowPanel");
        if (fieldStr == null) {
            fieldStr = "";
        }
        String[] fields = fieldStr.split(",");
        List<TreeNode> nodes = this.buildAllTree(paramId, sysShowPanel);
        TreeNode root = nodes.remove(0);
        root.setChildren(this.getChildren(root.getId(), nodes));
        this.removeEmptyNodes(root);
        TreeView treeView = (TreeView)this.getControl(TREE_KEY);
        treeView.addNode(root);
        this.setCheckedNodes(fields, treeView, root);
        this.getPageCache().put("tree", SerializationUtils.toJsonString((Object)root));
    }

    private void setCheckedNodes(String[] fields, TreeView treeView, TreeNode root) {
        ArrayList<TreeNode> checkedNodes = new ArrayList<TreeNode>();
        if (fields.length > 0) {
            for (String field : fields) {
                TreeNode node2 = root.getTreeNode(field, 16);
                if (node2 == null) continue;
                checkedNodes.add(node2);
            }
        }
        F7SelectedList f7 = (F7SelectedList)this.getControl(F7LIST);
        treeView.checkNodes(checkedNodes);
        checkedNodes.removeIf(node -> !node.getType().equals(ENTITY_META));
        List items = checkedNodes.stream().map(node -> new ValueTextItem(node.getId(), node.getText())).collect(Collectors.toList());
        f7.addItems(items);
        this.getPageCache().put(SELECTED_FIELDS, SerializationUtils.toJsonString(items));
    }

    private List<TreeNode> buildAllTree(String paramId, String sysShowPanel) {
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)paramId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)MetadataDao.getIdByNumber((String)paramId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        formMetadata.createIndex();
        List controlAps = formMetadata.getItems();
        Map pluginParam = Collections.emptyMap();
        if (StringUtils.isNotEmpty((CharSequence)sysShowPanel)) {
            pluginParam = (Map)SerializationUtils.fromJsonString((String)sysShowPanel, Map.class);
        }
        List showPanel = pluginParam.getOrDefault("showPanel", Collections.emptyList());
        List hidePanel = pluginParam.getOrDefault("hidePanel", Collections.emptyList());
        Set<String> showPanelIds = controlAps.stream().filter(p -> showPanel.contains(p.getKey())).map(AbstractElement::getId).collect(Collectors.toSet());
        Set<String> hidePanelIds = controlAps.stream().filter(p -> hidePanel.contains(p.getKey())).map(AbstractElement::getId).collect(Collectors.toSet());
        TreeNode root = null;
        TreeNode node = null;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        HashSet<String> showPanelAndChildIds = null;
        if (!showPanel.isEmpty()) {
            showPanelAndChildIds = new HashSet<String>();
            this.getAllChildrenApId(formMetadata, showPanelIds, showPanelAndChildIds);
        }
        HashSet<String> hidePanelAndChildIds = null;
        if (!hidePanelIds.isEmpty()) {
            hidePanelAndChildIds = new HashSet<String>();
            this.getAllChildrenApId(formMetadata, hidePanelIds, hidePanelAndChildIds);
        }
        for (ControlAp ap : controlAps) {
            ContainerAp cp;
            if (entityMetadata.getFieldByKey(ap.getKey()) instanceof RadioField || ap instanceof ContainerAp && (cp = (ContainerAp)ap).getItems().isEmpty()) continue;
            if (ap instanceof FormAp) {
                root = new TreeNode();
                root.setText(ap.getName().getLocaleValue());
                root.setId(ap.getId());
                root.setType("root");
                nodes.add(root);
                continue;
            }
            String controlApId = ap.getId();
            if (hidePanelAndChildIds != null && hidePanelAndChildIds.contains(controlApId) || showPanelAndChildIds != null && !showPanelAndChildIds.contains(controlApId)) continue;
            node = new TreeNode();
            node.setData((Object)ap.getKey());
            node.setId(ap.getId());
            node.setText(ap.getName().getLocaleValue());
            node.setIsOpened(true);
            node.setParentid(ap.getParentId());
            if (ap instanceof FieldAp) {
                node.setType(ENTITY_META);
            } else {
                node.setType("formmeta");
            }
            nodes.add(node);
        }
        if (root != null) {
            root.setIsOpened(true);
        }
        return nodes;
    }

    private void getAllChildrenApId(FormMetadata formMetadata, Set<String> parentApIdSet, Set<String> allChildAndParentIds) {
        for (String parentId : parentApIdSet) {
            this.getChildrenAp(formMetadata, allChildAndParentIds, parentId);
        }
    }

    private void getChildrenAp(FormMetadata formMetadata, Set<String> allChildAndParentIds, String showPanelId) {
        allChildAndParentIds.add(showPanelId);
        ControlAp item = formMetadata.getItem(showPanelId);
        String itemKey = item.getId();
        if (item instanceof FieldAp) {
            allChildAndParentIds.add(itemKey);
        } else if (item instanceof FlexPanelAp) {
            FlexPanelAp flexPanelAp = (FlexPanelAp)item;
            List items = flexPanelAp.getItems();
            if (items == null || items.isEmpty()) {
                return;
            }
            for (ControlAp controlAp : items) {
                this.getChildrenAp(formMetadata, allChildAndParentIds, controlAp.getId());
            }
        }
    }

    private List<TreeNode> getChildren(String id, List<TreeNode> nodes) {
        ArrayList<TreeNode> childList = new ArrayList<TreeNode>();
        for (TreeNode node : nodes) {
            String parentId = node.getParentid();
            if (!StringUtils.isNotBlank((CharSequence)parentId) || !parentId.equals(id)) continue;
            childList.add(node);
        }
        for (TreeNode node : childList) {
            if (!StringUtils.isNotBlank((CharSequence)node.getId())) continue;
            node.setChildren(this.getChildren(node.getId(), nodes));
        }
        if (childList.isEmpty()) {
            return null;
        }
        return childList;
    }

    private void removeEmptyNodes(TreeNode root) {
        if (root.getChildren() == null) {
            return;
        }
        Iterator nodes = root.getChildren().iterator();
        while (nodes.hasNext()) {
            TreeNode node = (TreeNode)nodes.next();
            if (node.getChildren() != null) {
                this.removeEmptyNodes(node);
                continue;
            }
            if (!"formmeta".equals(node.getType())) continue;
            nodes.remove();
        }
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        if (ctl.getKey().equals(BTN_OK)) {
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            String fields = this.getSelectFields();
            if (StringUtils.isBlank((CharSequence)fields)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u53c2\u6570", (String)"SysParameterSelectPlugin_0", (String)"sys-ricc-business", (Object[])new Object[0]));
                return;
            }
            String selectedFieldName = this.getSelectedFieldsName();
            data.put(SELECTED_FIELDS, fields);
            data.put("selectedFieldsName", selectedFieldName);
            data.put("first", Boolean.FALSE);
            if (this.getView().getFormShowParameter().getCustomParam(SELECTED_FIELDS) == null) {
                data.put("first", Boolean.TRUE);
            }
            this.getView().returnDataToParent(data);
            this.getView().close();
        }
    }

    private String getSelectedFieldsName() {
        TreeView treeView = (TreeView)this.getControl(TREE_KEY);
        TreeView.TreeState state = treeView.getTreeState();
        if (this.getPageCache().get("tree") == null) {
            return "";
        }
        List nodes = state.getCheckedNodes();
        return nodes.stream().filter(node -> !Boolean.parseBoolean(node.get("isParent").toString())).map(node -> node.get("text").toString()).collect(Collectors.joining(","));
    }

    private String getSelectFields() {
        TreeView treeView = (TreeView)this.getControl(TREE_KEY);
        TreeView.TreeState state = treeView.getTreeState();
        if (this.getPageCache().get("tree") == null) {
            return "";
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("tree"), TreeNode.class);
        List nodes = state.getCheckedNodes();
        nodes.removeIf(node -> !root.getTreeNode(node.get("id").toString(), 16).getType().equals(ENTITY_META));
        if (!nodes.isEmpty()) {
            StringBuilder fieldStr = new StringBuilder(((Map)nodes.get(0)).get("id").toString());
            for (int i = 1; i < nodes.size(); ++i) {
                fieldStr.append(',').append(((Map)nodes.get(i)).get("id"));
            }
            return fieldStr.toString();
        }
        return "";
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        F7SelectedList f7 = (F7SelectedList)this.getControl(F7LIST);
        TreeView treeView = (TreeView)this.getControl(TREE_KEY);
        TreeView.TreeState state = treeView.getTreeState();
        if (this.getPageCache().get("tree") == null) {
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("tree"), TreeNode.class);
        List nodes = state.getCheckedNodes();
        nodes.removeIf(node -> !root.getTreeNode(node.get("id").toString(), 16).getType().equals(ENTITY_META));
        List items = nodes.stream().map(node -> new ValueTextItem(node.get("id").toString(), node.get("text").toString())).collect(Collectors.toList());
        f7.addItems(items);
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        TreeView tree = (TreeView)this.getView().getControl(TREE_KEY);
        if (evt.getParam() != null) {
            tree.uncheckNode(evt.getParam().toString());
        } else {
            tree.uncheckNodes(tree.getTreeState().getCheckedNodeIds());
        }
    }
}

