/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.metadata.log;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.business.metadata.log.MetaLog;
import kd.sys.ricc.common.enums.RiccObtainDataServiceEnum;
import kd.sys.ricc.common.util.ApiUtil;
import kd.sys.ricc.common.util.TransferUtil;
import org.apache.commons.lang.StringUtils;

public class MetaLogDataHelper {
    private static final String LAST_DYM = "lastDym";
    private static final String BASE_DYM = "baseDym";

    public static List<MetaLog> getMetaDataLog(List<String> metaIds) {
        return MetaLogDataHelper.getMetaLog(metaIds);
    }

    private static List<MetaLog> getMetaLog(List<String> metaIds) {
        String inParamIdStr = metaIds.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
        String sql = "select b.fid,b.fisv,b.ftype,b.foperator,b.foperatetime,b.fversion,b.fcontent,a.fmetaid,a.fentryid,a.fmetaver, a.fdata , a.fbizappid , a.fmetanumber,a.ftype as fmetatype from t_log_metaversion a join t_log_metaoperate b on a.fid = b.fid and a.fmetaid in (" + inParamIdStr + ") order by b.foperatetime desc";
        return (List)DB.query((DBRoute)DBRoute.log, (String)sql, rs -> {
            ArrayList<MetaLog> metaLogs = new ArrayList<MetaLog>(10);
            while (rs.next()) {
                MetaLog metaLog = new MetaLog();
                metaLog.setId(rs.getLong("fid"));
                metaLog.setVersion(rs.getString("fversion"));
                metaLog.setIsv(rs.getString("fisv"));
                metaLog.setType(rs.getString("ftype"));
                metaLog.setOperator(rs.getLong("foperator"));
                metaLog.setOperateTime(rs.getDate("foperatetime"));
                metaLog.setContent(rs.getString("fcontent"));
                metaLog.setMetaNumber(rs.getString("fmetanumber"));
                metaLog.setMetaId(rs.getString("fmetaid"));
                metaLog.setMetaType(rs.getString("fmetatype"));
                metaLog.setData(rs.getString("fdata"));
                metaLog.setBizAppId(rs.getString("fbizappid"));
                metaLog.setMetaver(rs.getString("fmetaver"));
                metaLogs.add(metaLog);
            }
            return metaLogs;
        });
    }

    public static void showMerge(DynamicObject lastObj, DynamicObject currentObj, IFormView formView) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ricc_metadatadiff");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam(BASE_DYM, (Object)currentObj.getString("data_tag"));
        parameter.setCustomParam("bizappid", (Object)currentObj.getDynamicObject("bizappid").getString("number"));
        parameter.setCustomParam("newCommitId", (Object)currentObj.getString("metaver"));
        if (lastObj != null) {
            parameter.setCustomParam(LAST_DYM, (Object)lastObj.getString("data_tag"));
            parameter.setCustomParam("oldCommitId", (Object)lastObj.getString("metaver"));
            parameter.setCustomParam("isNotShowTree", (Object)"false");
        } else {
            parameter.setCustomParam(LAST_DYM, (Object)"");
            parameter.setCustomParam("oldCommitId", (Object)"0");
            parameter.setCustomParam("isNotShowTree", (Object)"true");
        }
        formView.showForm(parameter);
    }

    public static CustomApiResult<List<MetaLog>> getTarMetaLogDatas(List<String> metaIds, Long destAccountPk, String targetCenterUser) {
        String accountId = RequestContext.getOrCreate().getAccountId();
        DynamicObject[] destAccounts = BusinessDataServiceHelper.load((String)"ricc_destaccount", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)destAccountPk)});
        if (destAccountPk == 0L || destAccounts != null && destAccounts.length > 0 && StringUtils.equals((String)destAccounts[0].getString("number"), (String)accountId)) {
            List<MetaLog> metaDataLog = MetaLogDataHelper.getMetaDataLog(metaIds);
            return CustomApiResult.success(metaDataLog);
        }
        HashMap<String, List<String>> formParams = new HashMap<String, List<String>>(1);
        formParams.put("metaIds", metaIds);
        Map loginParams = TransferUtil.destAccountLoginParams((long)destAccountPk, (String)targetCenterUser);
        String response = ApiUtil.getDestAccountMetaLogData(formParams, (Map)loginParams, (String)RiccObtainDataServiceEnum.META_LOG.getType());
        return (CustomApiResult)JSON.parseObject((String)response, (TypeReference)new TypeReference<CustomApiResult<List<MetaLog>>>(){}, (Feature[])new Feature[0]);
    }
}

