/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.schemeconfig.actions;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sys.ricc.business.schemeconfig.AbstractIscInitAction;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;

public class IscSchemeImportAction
extends AbstractIscInitAction {
    private static final Log logger = LogFactory.getLog(IscSchemeImportAction.class);
    private static final String SCHEMEFILEPATH = "/kd/sys/ricc/scheme/ricc_scheme.zip";
    private static final int TOTAL = 130;
    private static final int ISC_DATA_COPY_COUNT = 126;
    private static final int TRIGGER_COUNT = 134;
    private static final int FLOW_COUNT = 14;

    public IscSchemeImportAction() {
        this.setId(1553603468705404928L);
        this.setName(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u5bfc\u5165", (String)"IscSchemeImportAction_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
    }

    @Override
    public boolean isOver() {
        QFilter[] riccSchemeFilter = new QFilter("number", "like", (Object)"RICC%").toArray();
        List schemeCount = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy_trigger", (QFilter[])riccSchemeFilter, null, (int)-1);
        List flowCount = QueryServiceHelper.queryPrimaryKeys((String)"isc_service_flow", (QFilter[])riccSchemeFilter, null, (int)-1);
        if (schemeCount.size() < 134 || flowCount.size() < 14) {
            return false;
        }
        this.getMsg().append(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\uff1a%1$s\uff0c\u542f\u52a8\u65b9\u6848\uff1a%2$s\uff0c\u670d\u52a1\u6d41\u7a0b\uff1a%3$s\uff0c\u5df2\u5168\u90e8\u5bfc\u5165", (String)"IscSchemeImportAction_1", (String)"sys-ricc-platform", (Object[])new Object[0]), 126, 134, 14));
        this.setProgress(70);
        return true;
    }

    @Override
    public void doAction() {
        String msg = ResManager.loadKDString((String)"\u65b9\u6848\u5bfc\u5165\u5f00\u59cb,\u603b\u6570:%d", (String)"IscSchemeImportAction_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
        this.getMsg().append(String.format(msg, 130));
        URL url = this.getClass().getResource(SCHEMEFILEPATH);
        if (url == null) {
            this.setStatus(3);
            this.getMsg().append(ResManager.loadKDString((String)"\u6682\u65e0\u9884\u7f6e\u96c6\u6210\u65b9\u6848\u6587\u4ef6\u9700\u8981\u5bfc\u5165\u3002", (String)"IscSchemeImportAction_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            this.setProgress(70);
            return;
        }
        try (InputStream in = IscSchemeImportAction.class.getResourceAsStream(SCHEMEFILEPATH);
             ZipInputStream inputStream = new ZipInputStream(in, Charset.forName("GBK"));){
            String name = "";
            int count = 1;
            ZipEntry nextEntry = inputStream.getNextEntry();
            while (nextEntry != null) {
                name = nextEntry.getName();
                if (!name.endsWith("/")) {
                    String str = FileUtils.inputStreamToString((InputStream)inputStream);
                    this.importIscResource(str);
                    ++count;
                }
                this.updateImportProgress(count);
                inputStream.closeEntry();
                nextEntry = inputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            logger.error("\u96c6\u6210\u65b9\u6848\u5bfc\u5165\u5f02\u5e38", (Throwable)e);
            this.setStatus(4);
            this.getMsg().append(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u5bfc\u5165\u53d1\u751f\u5f02\u5e38:%s", (String)"IscSchemeImportAction_4", (String)"sys-ricc-platform", (Object[])new Object[0]), CommonUtil.getExceptionDetailInfo((Throwable)e)));
            return;
        }
        this.getMsg().delete(0, this.getMsg().length());
        String msgTpl = ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\uff1a%1$s\uff0c\u542f\u52a8\u65b9\u6848\uff1a%2$s\uff0c\u670d\u52a1\u6d41\u7a0b\uff1a%3$s\uff0c\u5df2\u5168\u90e8\u5bfc\u5165", (String)"IscSchemeImportAction_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
        this.getMsg().append(String.format(msgTpl, 126, 134, 14));
        this.setStatus(3);
        this.setProgress(70);
    }

    private void importIscResource(String str) {
        DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResourceWithPattern", (Object[])new Object[]{str, Boolean.TRUE});
    }

    private void updateImportProgress(int count) {
        int flag = 5;
        if (count % flag == 0) {
            this.getMsg().delete(0, this.getMsg().length());
            this.getMsg().append(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u603b\u6570\uff1a%1$s\uff0c\u5df2\u5bfc\u5165 %2$s", (String)"IscSchemeImportAction_6", (String)"sys-ricc-platform", (Object[])new Object[0]), 130, count));
            this.setProgress(count * 70 / 130);
            this.updateActionData();
        }
    }
}

