/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.sync;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.business.datapacket.core.SubDataPacketDispatch;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.helper.DataPacketHelper;
import kd.sys.ricc.business.schedule.AbstractSerailTask;
import kd.sys.ricc.business.transfer.TransferPacketProgress;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.enums.PacketEntryStatusEnum;
import kd.sys.ricc.common.enums.PacketLockEnum;
import kd.sys.ricc.common.log.AbstractLogRecord;
import kd.sys.ricc.common.log.LogRecorder;
import kd.sys.ricc.common.log.impl.ConfigLogImpl;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class SyncDataPacketTask
extends AbstractSerailTask {
    private static final Log logger = LogFactory.getLog(SyncDataPacketTask.class);
    private static final String CUSTPARAM_SELECTROWS = "selectRows";
    private static final String SELECT_FILEDS = "syncstate,packettype,number,name,synmode,status,subdatapacket.subpackettype, subdatapacket.bizobject,subdatapacket.relylevel,subdatapacket.filename,subdatapacket.subdatapacketfile,subdatapacket.entrysyncstate,subdatapacket.entryupdatetime,subdatapacket.seq,subdatapacket.entrystatus,subdatapacket.packetnum,subdatapacket.custparam,subdatapacket.custparam_tag,createtime,lockedstatus";
    private static final String BIZOBJECT = "bizobject";
    private TransferPacketProgress syncProgress;
    private final ConfigLogImpl configLog = new ConfigLogImpl();
    private int subTotal = 0;
    private int selectedPacket = 0;
    private int totalSuccessCount = 0;
    private int totalSubSuccessCount = 0;

    @Override
    public void realExecute(RequestContext requestContext, Map<String, Object> map) {
        this.genTaskId();
        map.put("taskId", this.taskId);
        String selectRowsStr = (String)map.get(CUSTPARAM_SELECTROWS);
        if (StringUtils.isEmpty((String)selectRowsStr)) {
            this.getSyncProgress().fail(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u540c\u6b65\u4f20\u8f93\u5305!", (String)"SyncDataPacketTask_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection listSelectedRows = ListSelectedRowCollection.deSerialize((String)selectRowsStr);
        DynamicObject[] selectDataPacket = this.querySyncData(listSelectedRows.getPrimaryKeyValues());
        if (selectDataPacket == null || selectDataPacket.length == 0) {
            this.getSyncProgress().fail(ResManager.loadKDString((String)"\u52fe\u9009\u6570\u636e\u4e0d\u5b58\u5728\uff01\u8bf7\u786e\u8ba4!", (String)"SyncDataPacketTask_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return;
        }
        this.subTotal = this.getTotalSubPacket(selectDataPacket);
        this.selectedPacket = selectDataPacket.length;
        LinkedHashMap<String, DynamicObject> guideMap = this.getGuides(selectDataPacket);
        this.getSyncProgress().feedbackTitle(String.format(ResManager.loadKDString((String)"\u5171\u52fe\u9009 %1$s \u4e2a\u4f20\u8f93\u5305\uff0c\u5305\u542b %2$s \u4e2a\u5b50\u4f20\u8f93\u5305\u3002%n", (String)"SyncDataPacketTask_2", (String)"sys-ricc-platform", (Object[])new Object[0]), this.selectedPacket, this.subTotal));
        this.totalSuccessCount = 0;
        this.totalSubSuccessCount = 0;
        for (DynamicObject packet : selectDataPacket) {
            this.getSyncProgress().feedbackProgress(this.subTotal, this.selectedPacket, this.totalSubSuccessCount, this.totalSuccessCount);
            this.processPacket(packet, guideMap, String.valueOf(map.get("pageId")));
            this.getSyncProgress().feedbackProgress(this.subTotal, this.selectedPacket, this.totalSubSuccessCount, this.totalSuccessCount);
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("sync", Boolean.TRUE.toString());
        OperationResult operationResult = SaveServiceHelper.saveOperate((String)"ricc_datapacket", (DynamicObject[])selectDataPacket, (OperateOption)operateOption);
        if (!operationResult.isSuccess()) {
            StringBuilder saveMsg = new StringBuilder(ResManager.loadKDString((String)"\u52fe\u9009\u7684\u4f20\u8f93\u5305\u4fdd\u5b58\u5931\u8d25\uff0c\u6570\u636e\u53ef\u80fd\u5df2\u7ecf\u540c\u6b65\u6210\u529f\uff0c\u4f46\u662f\u4f20\u8f93\u5305\u72b6\u6001\u4fee\u6539\u5931\u8d25\uff0c\u5177\u4f53\u539f\u56e0\uff1a", (String)"SyncDataPacketTask_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
            saveMsg.append(operationResult.getMessage());
            operationResult.getAllErrorOrValidateInfo().forEach(x -> saveMsg.append(x.getMessage()));
            logger.info(saveMsg.toString());
            this.getSyncProgress().fail(saveMsg.toString());
        }
        this.getSyncProgress().complete();
    }

    private void genTaskId() {
        if (this.taskId == null) {
            this.setTaskId(String.valueOf(DB.genGlobalLongId()));
        }
    }

    public void processPacket(DynamicObject packet, Map<String, DynamicObject> guideMap, String pageId) {
        LogRecorder errorMsg = new LogRecorder();
        String packetName = packet.getString("name");
        String packetNumber = packet.getString("number");
        this.configLog.preWriteLog("0", this.taskId, ((Long)packet.getPkValue()).longValue(), 0L, "", null);
        String syncMod = packet.getString("synmode");
        DynamicObjectCollection subDataPackets = packet.getDynamicObjectCollection("subdatapacket");
        if (subDataPackets.isEmpty()) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u3010%1$s | %2$s\u3011\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a%n \u4e0d\u5b58\u5728\u5b50\u4f20\u8f93\u5305\u3002", (String)"SyncDataPacketTask_4", (String)"sys-ricc-platform", (Object[])new Object[0]), packetNumber, packetName));
            this.configLog.afterWriteLog(0, 0, (AbstractLogRecord)errorMsg);
            return;
        }
        int subDataPacketSize = subDataPackets.size();
        String status = packet.getString("status");
        if (!SysParaUtil.isAllowUploadWithPacketStatus((String)status)) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u3010%1$s | %2$s\u3011\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a%n \u5f53\u524d\u73af\u5883\u4e0d\u5141\u8bb8\u540c\u6b65\u975e\u5ba1\u6838\u72b6\u6001\u4f20\u8f93\u5305\u3002", (String)"SyncDataPacketTask_5", (String)"sys-ricc-platform", (Object[])new Object[0]), packetNumber, packetName));
            this.configLog.afterWriteLog(subDataPacketSize, 0, (AbstractLogRecord)errorMsg);
            return;
        }
        int successCount = this.processSubPacket(subDataPackets, syncMod, guideMap, pageId);
        errorMsg.setEndTime(System.currentTimeMillis());
        if (successCount == subDataPacketSize) {
            ++this.totalSuccessCount;
            packet.set("syncstate", (Object)"1");
        }
        if (successCount > 0 && successCount < subDataPacketSize) {
            packet.set("syncstate", (Object)"3");
        }
        if (successCount == 0) {
            packet.set("syncstate", (Object)"2");
        }
        if (StringUtils.equals((String)status, (String)"C")) {
            packet.set("lockedstatus", (Object)PacketLockEnum.IS_LOCKED.getVal());
        }
        if (errorMsg.length() > 0) {
            String title = String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u3010%1$s | %2$s\u3011\u5bfc\u5165%3$s\u5931\u8d25\uff0c\u539f\u56e0\u5982\u4e0b\uff1a%n", (String)"SyncDataPacketTask_6", (String)"sys-ricc-platform", (Object[])new Object[0]), packetNumber, packetName, successCount == 0 ? ResManager.loadKDString((String)"\u5168\u90e8", (String)"SyncDataPacketTask_7", (String)"sys-ricc-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"sys-ricc-platform", (String)"SyncDataPacketTask_15", (String)"sys-ricc-platform", (Object[])new Object[0]));
            errorMsg.insert(0, title);
        }
        this.getSyncProgress().feedbackProgress(this.subTotal, this.selectedPacket, this.totalSubSuccessCount, this.totalSuccessCount);
        this.configLog.afterWriteEntryLog(subDataPacketSize, successCount, (AbstractLogRecord)errorMsg);
    }

    public int processSubPacket(DynamicObjectCollection subDataPackets, String syncMod, Map<String, DynamicObject> guideMap, String pageId) {
        int successCount = 0;
        DynamicObjectCollection newSubDataPackets = this.sortSubDataPacketForRely(subDataPackets, guideMap);
        for (DynamicObject row : newSubDataPackets) {
            SdpOutputParams sdpOutputParams;
            int entryFailedCount;
            int entrySuccessCount;
            String guideNumber;
            int seq;
            block6: {
                String subEntrySynStatus;
                seq = row.getInt("seq");
                DynamicObject type = (DynamicObject)row.get(BIZOBJECT);
                String fileName = row.getString("filename");
                String fileUrl = DataPacketHelper.getFileUrl(row);
                String subEntryStatus = (String)row.get("entrystatus");
                boolean validateStatus = this.validateSubPacketStatusBeforeSync(subEntryStatus, subEntrySynStatus = row.getString("entrysyncstate"), seq);
                if (!validateStatus) {
                    ++this.totalSubSuccessCount;
                    ++successCount;
                    continue;
                }
                boolean validateFile = this.validateSubPacketFileBeforeSync(fileName, fileUrl, seq);
                if (!validateFile) continue;
                String msg = null;
                row.set("entrysyncstate", (Object)"2");
                row.set("entryupdatetime", (Object)System.currentTimeMillis());
                guideNumber = type.getString("number");
                String packetType = "ricc_configitems".equals(row.getString("subpackettype")) ? DataPacketTypeEnum.CONFIG.getVal() : DataPacketTypeEnum.BASEDATA.getVal();
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                param.put("fileUrl", fileUrl);
                param.put("fileName", fileName);
                param.put("guideInfo", guideMap.get(guideNumber));
                param.put("synmode", syncMod);
                param.put("pageId", pageId);
                entrySuccessCount = 0;
                entryFailedCount = 0;
                sdpOutputParams = null;
                try {
                    String custparamStr = row.getString("custparam_tag");
                    Map custParam = (Map)JSON.parse((String)custparamStr);
                    param.put("custparam", custParam);
                    sdpOutputParams = SubDataPacketDispatch.importPacket(packetType, param);
                    Map<String, Object> returnData = sdpOutputParams.getParam();
                    Object successObj = returnData.get("successCount");
                    Object failedObj = returnData.get("failedCount");
                    if (Objects.isNull(successObj) || Objects.isNull(failedObj)) break block6;
                    entrySuccessCount = (Integer)successObj;
                    entryFailedCount = (Integer)failedObj;
                }
                catch (Exception e) {
                    logger.error("\u540c\u6b65\u5931\u8d25: ", (Throwable)e);
                    String msgTpl = ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25:%s", (String)"SyncDataPacketTask_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    msg = String.format(msgTpl, e.getMessage());
                    this.configLog.buildEntrySyncLogWithException("2", msg, (Throwable)e, seq, entrySuccessCount, entryFailedCount);
                    continue;
                }
            }
            if (!sdpOutputParams.isSuccess()) {
                String errorMsg = sdpOutputParams.getErrorStr();
                String stackTrace = sdpOutputParams.getDevErrorStr();
                this.configLog.buildEntrySyncLogWithException("2", errorMsg, stackTrace, seq, entrySuccessCount, entryFailedCount);
                continue;
            }
            row.set("entrysyncstate", (Object)"1");
            ++this.totalSubSuccessCount;
            this.getSyncProgress().feedbackProgress(this.subTotal, this.selectedPacket, this.totalSubSuccessCount, this.totalSuccessCount);
            ++successCount;
            if (StringUtils.equals((String)guideNumber, (String)"ai_vchtemplate_configs")) {
                entrySuccessCount = row.getInt("packetnum");
            }
            this.configLog.buildEntrySyncLogWithMsg("1", sdpOutputParams.getErrorStr(), seq, entrySuccessCount, entryFailedCount);
        }
        return successCount;
    }

    private DynamicObjectCollection sortSubDataPacketForRely(DynamicObjectCollection subDataPackets, Map<String, DynamicObject> guideMap) {
        ArrayList<Object> baseDataIds = new ArrayList<Object>(10);
        for (DynamicObject subDataPacketRow : subDataPackets) {
            int isPreset;
            String subPacketType = subDataPacketRow.getString("subpackettype");
            DynamicObject[] bizObject = subDataPacketRow.getDynamicObject(BIZOBJECT);
            DynamicObject baseData = guideMap.get(bizObject.getString("number"));
            if (!StringUtils.equals((String)"ricc_basedata_item", (String)subPacketType) || (isPreset = (int)(baseData.getBoolean("ispreset") ? 1 : 0)) == 0) continue;
            Object baseDataId = baseData.getPkValue();
            baseDataIds.add(baseDataId);
        }
        HashMap<Object, Object> configDataMap = new HashMap<Object, Object>(16);
        if (!baseDataIds.isEmpty()) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"ricc_configitems");
            DynamicObject[] loadConfigData = BusinessDataServiceHelper.load((Object[])baseDataIds.toArray(), (DynamicObjectType)type);
            for (DynamicObject configItem : loadConfigData) {
                configDataMap.put(configItem.getPkValue(), configItem);
            }
        }
        LinkedHashMap<Object, List<Object>> sortMap = new LinkedHashMap<Object, List<Object>>(16);
        DynamicObjectCollection newSubDataPacket = new DynamicObjectCollection();
        for (DynamicObject subDataPacketRow : subDataPackets) {
            String subPacketType = subDataPacketRow.getString("subpackettype");
            DynamicObject bizObject = subDataPacketRow.getDynamicObject(BIZOBJECT);
            String number = bizObject.getString("number");
            DynamicObject configItem = guideMap.get(number);
            if (StringUtils.equals((String)"ricc_configitems", (String)subPacketType)) {
                List<Object> nodes = this.getRelyList(configItem);
                sortMap.put(configItem.getPkValue(), nodes);
                continue;
            }
            Object baseDataId = configItem.getPkValue();
            DynamicObject baseDataShiftItem = (DynamicObject)configDataMap.get(baseDataId);
            if (baseDataShiftItem == null) {
                newSubDataPacket.add((Object)subDataPacketRow);
                continue;
            }
            List<Object> nodes = this.getRelyList(baseDataShiftItem);
            sortMap.put(configItem.getPkValue(), nodes);
        }
        List<Object> sortList = this.sortDependencies(sortMap);
        for (Object itemPk : sortList) {
            subDataPackets.forEach(row -> {
                DynamicObject bizObject = row.getDynamicObject(BIZOBJECT);
                Object rowItemPk = bizObject.getPkValue();
                if (ObjectUtils.nullSafeEquals((Object)itemPk, (Object)rowItemPk)) {
                    newSubDataPacket.add(row);
                }
            });
        }
        return newSubDataPacket;
    }

    public List<Object> sortDependencies(Map<Object, List<Object>> dependencies) {
        ArrayList<Object> result = new ArrayList<Object>(10);
        HashSet<Object> visited = new HashSet<Object>(16);
        for (Object key : dependencies.keySet()) {
            if (visited.contains(key)) continue;
            this.loopSort(key, dependencies, result, visited);
        }
        return result;
    }

    private void loopSort(Object node, Map<Object, List<Object>> dependencies, List<Object> result, Set<Object> visited) {
        visited.add(node);
        List<Object> relyItems = dependencies.get(node);
        if (relyItems != null) {
            for (Object dependency : relyItems) {
                if (visited.contains(dependency)) continue;
                this.loopSort(dependency, dependencies, result, visited);
            }
        }
        result.add(node);
    }

    private List<Object> getRelyList(DynamicObject bizObject) {
        DynamicObjectCollection relyItemEntry = bizObject.getDynamicObjectCollection("relyitementry");
        ArrayList<Object> nodes = new ArrayList<Object>(10);
        for (DynamicObject itemRelyRow : relyItemEntry) {
            Object relyNumber = itemRelyRow.getDynamicObject("relyitem").getPkValue();
            nodes.add(relyNumber);
        }
        return nodes;
    }

    public TransferPacketProgress getSyncProgress() {
        if (this.syncProgress == null) {
            this.syncProgress = new TransferPacketProgress(this.taskId, CommonConstant.getMsgTransferPacketName());
        }
        return this.syncProgress;
    }

    private DynamicObject[] querySyncData(Object[] selectPackets) {
        QFilter qFilter = new QFilter("id", "in", (Object)selectPackets).and(new QFilter("subdatapacket.entrystatus", "=", (Object)PacketEntryStatusEnum.NORMAL.getVal()));
        return BusinessDataServiceHelper.load((String)"ricc_datapacket", (String)SELECT_FILEDS, (QFilter[])qFilter.toArray(), (String)"packettype desc,number asc");
    }

    public int getTotalSubPacket(DynamicObject[] selectDataPacket) {
        int total = 0;
        for (DynamicObject dynamicObject : selectDataPacket) {
            DynamicObjectCollection dCollection = dynamicObject.getDynamicObjectCollection("subdatapacket");
            total += dCollection.size();
        }
        return total;
    }

    private LinkedHashMap<String, DynamicObject> getGuides(DynamicObject[] packets) {
        HashSet<Object> bdItemIds = new HashSet<Object>();
        HashSet<Object> configIds = new HashSet<Object>();
        for (DynamicObject packet : packets) {
            String packetNumber = packet.getString("number");
            DynamicObjectCollection packetEntryRows = packet.getDynamicObjectCollection("subdatapacket");
            for (DynamicObject row : packetEntryRows) {
                String subPacketType = row.getString("subpackettype");
                DynamicObject bizObject = row.getDynamicObject(BIZOBJECT);
                if (Objects.isNull(bizObject)) {
                    throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305%s\u5206\u5f55\u5b58\u5728\u810f\u6570\u636e\uff0c\u65e0\u6cd5\u8bc6\u522b\u5b50\u5305\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5", (String)"SyncDataPacketTask_10", (String)"sys-ricc-platform", (Object[])new Object[0]), packetNumber));
                }
                Object bizObjectId = bizObject.getPkValue();
                if ("ricc_basedata_item".equals(subPacketType)) {
                    bdItemIds.add(bizObjectId);
                    continue;
                }
                if (!"ricc_configitems".equals(subPacketType)) continue;
                configIds.add(bizObjectId);
            }
        }
        LinkedHashMap<String, DynamicObject> guides = new LinkedHashMap<String, DynamicObject>();
        if (!bdItemIds.isEmpty()) {
            DynamicObject[] bdItems;
            QFilter qFilter = new QFilter("id", "in", bdItemIds);
            for (DynamicObject bdItem : bdItems = BusinessDataServiceHelper.load((String)"ricc_basedata_item", (String)"id,number,name,page.number,page.modeltype,pagetype, custompage, page.bizappid.number , canexcel,importtemplateid,pageenterparam,ispreset", (QFilter[])qFilter.toArray(), null)) {
                guides.put(bdItem.getString("number"), bdItem);
            }
        }
        if (!configIds.isEmpty()) {
            DynamicObject[] configs;
            QFilter qFilter = new QFilter("id", "in", configIds);
            for (DynamicObject config : configs = BusinessDataServiceHelper.load((String)"ricc_configitems", (String)"id,number,name,page.number,page.modeltype modeltype,pagetype, custompage, page.bizappid, page.basedatafield.number, supportaddtopacket,custparampage,importtype,plugin,relylevel,importtemplateid,pageenterparam,dataimporttype,keyfields,isoverrideEntry,relyitementry.relyitem,conditionmustfield, coverinfo, istransferattach, attachmentfield", (QFilter[])qFilter.toArray(), null)) {
                guides.put(config.getString("number"), config);
            }
        }
        return guides;
    }

    private boolean validateSubPacketStatusBeforeSync(String subEntryStatus, String subSynstatus, int seq) {
        String msg = null;
        if (StringUtils.equals((String)PacketEntryStatusEnum.INVALID.getVal(), (String)subEntryStatus)) {
            msg = ResManager.loadKDString((String)"\u5b50\u4f20\u8f93\u5305\u5df2\u5e9f\u5f03\uff0c\u89c6\u4e3a\u540c\u6b65\u5b8c\u6210\uff0c\u8df3\u8fc7\u6267\u884c\u3002", (String)"SyncDataPacketTask_11", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.configLog.buildEntrySyncLogWithMsg(" ", msg, seq, 0, 0);
            return false;
        }
        if (StringUtils.equals((String)"1", (String)subSynstatus)) {
            msg = ResManager.loadKDString((String)"\u5b50\u4f20\u8f93\u5305\u5df2\u7ecf\u540c\u6b65\u6210\u529f\u8fc7\uff0c\u8df3\u8fc7\u6267\u884c\u3002", (String)"SyncDataPacketTask_12", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.configLog.buildEntrySyncLogWithMsg("1", msg, seq, 0, 0);
            return false;
        }
        return true;
    }

    private boolean validateSubPacketFileBeforeSync(String fileName, String fileUrl, int seq) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5b50\u4f20\u8f93\u5305\u6587\u4ef6\u540d\u3002", (String)"SyncDataPacketTask_13", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.configLog.buildEntrySyncLogWithMsg("2", msg, seq, 0, 0);
            return false;
        }
        if (fileUrl == null) {
            String msg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5b50\u4f20\u8f93\u5305\u6587\u4ef6\u3002", (String)"SyncDataPacketTask_14", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.configLog.buildEntrySyncLogWithMsg("2", msg, seq, 0, 0);
            return false;
        }
        return true;
    }
}

