/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.fasttransfer;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobFormInfo;
import kd.sys.ricc.business.fasttransfer.AddTransferTask;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.util.ShowParameterUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.formplugin.AbstractProgressFormPlugin;
import kd.sys.ricc.formplugin.fasttransfer.AddTransferTaskClick;

public class AddTransferProgressForm
extends AbstractProgressFormPlugin {
    public static final String VIEWLOG_LINK = "viewloglink";
    public static final String LABEL_TOTAL = "total";
    public static final String LABEL_COMPLETE = "complete";
    public static final String SUCCESS_PANEL = "successpanel";
    public static final String FAILED_PANEL = "failedpanel";
    public static final String SYNC_PANEL = "syncpanel";
    public static final String PACKET_LOG_ID = "packetLogId";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{VIEWLOG_LINK});
    }

    @Override
    public JobFormInfo buildJobFormInfo() {
        Map allParam = this.getView().getFormShowParameter().getCustomParams();
        HashMap<String, Object> params = new HashMap<String, Object>(allParam);
        String taskName = ResManager.loadKDString((String)"\u6dfb\u52a0\u4f20\u8f93", (String)"AddTransferProgressForm_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
        return ScheduleUtil.buildJobFormInfo(taskName, AddTransferTask.class.getName(), AddTransferTaskClick.class.getName(), this.getView(), params);
    }

    @Override
    public void showDetails(TaskInfo taskInfo) {
        String transferStatus;
        Map<String, Object> data = ScheduleUtil.getTaskCustData(taskInfo);
        if (data.isEmpty()) {
            return;
        }
        String totalVal = (String)data.get(LABEL_TOTAL);
        String total = totalVal != null ? totalVal : "0";
        String completeVal = (String)data.get(LABEL_COMPLETE);
        String complete = completeVal != null ? completeVal : "0";
        Label totalLabel = (Label)this.getControl(LABEL_TOTAL);
        totalLabel.setText(total);
        Label completeLabel = (Label)this.getControl(LABEL_COMPLETE);
        completeLabel.setText(complete);
        String desc = taskInfo.getDesc();
        if (!StringUtils.isEmpty((String)desc)) {
            this.getModel().setValue("desc", (Object)desc);
            this.getView().updateView("desc");
        }
        if ((transferStatus = (String)data.get("transferstatus")) != null && StringUtils.equals((String)total, (String)complete)) {
            this.getModel().setValue("transferstatus", (Object)transferStatus);
        }
    }

    @Override
    public void showComplete(TaskInfo taskInfo, ProgressEvent e) {
        Map<String, Object> taskData = ScheduleUtil.getTaskCustData(taskInfo);
        this.stopBar();
        if (StringUtils.equals((String)"FAILED", (String)taskInfo.getStatus().toLowerCase())) {
            if (StringUtils.isNotBlank((CharSequence)taskInfo.getFailureReason())) {
                this.getView().showMessage(taskInfo.getFailureReason());
            }
        } else {
            String failmessage = (String)taskData.get("failmessage");
            if (StringUtils.isNotBlank((CharSequence)failmessage)) {
                this.showPanel(FAILED_PANEL);
            } else {
                this.showPanel(SUCCESS_PANEL);
                e.setProgress(100);
            }
        }
        this.getCurrentAppCache().remove(this.getCurrentAppCacheKey());
    }

    private void showPanel(String showPanel) {
        this.getView().setVisible(Boolean.FALSE, new String[]{SUCCESS_PANEL, SYNC_PANEL, FAILED_PANEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{showPanel});
        HashMap<String, Integer> notHidden = new HashMap<String, Integer>(1);
        notHidden.put("gr", 1);
        this.getView().updateControlMetadata(showPanel, notHidden);
        String newName = ResManager.loadKDString((String)"\u5173\u95ed", (String)"AddTransferProgressForm_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
        this.modifyControlName("btncancel", newName);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (VIEWLOG_LINK.equals(key)) {
            String taskId = this.getTaskId();
            Map<String, Object> data = ScheduleUtil.getTaskCustData(taskId);
            Object packetLogId = data.get(PACKET_LOG_ID);
            if (packetLogId == null) {
                return;
            }
            List packetLogIds = (List)data.get(PACKET_LOG_ID);
            if (packetLogIds.size() == 1) {
                ShowParameterUtil.showLog(packetLogIds.get(0), (IFormView)this.getView(), (ShowType)ShowType.Modal, (String)"4");
            } else {
                QFilter qFilter = new QFilter("id", "in", (Object)packetLogIds);
                ShowParameterUtil.showLogs((IFormView)this.getView(), (QFilter)qFilter, (ShowType)ShowType.Modal);
            }
        }
    }
}

