/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.metadatacompare;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class RiccEntityTreePlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private static final String CTRL_TREEVIEW = "treeview";
    private static final String TREE_NODE_CACHE = "treenodecache";
    private static final String CLOUD = "CLOUD";
    private static final String SEARCH_TEXT_TIME = "searchText_time";

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeView treeView = (TreeView)this.getControl(CTRL_TREEVIEW);
        String searchText = searchEnterEvent.getText();
        String searchTextFormCache = this.getPageCache().get("searchText");
        String treeNodeFromCache = this.getPageCache().get(TREE_NODE_CACHE);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeFromCache, TreeNode.class);
        List cloudNode = root.getChildren();
        ArrayList appNode = new ArrayList();
        for (TreeNode tn : cloudNode) {
            if (tn.getChildren() == null) continue;
            appNode.addAll(tn.getChildren());
        }
        ArrayList<Object> allNode = new ArrayList<Object>();
        allNode.add(root);
        allNode.addAll(cloudNode);
        allNode.addAll(appNode);
        if (searchText.equals(searchTextFormCache)) {
            this.searchByPageCache(treeView);
        } else {
            ArrayList<TreeNode> list = new ArrayList<TreeNode>();
            for (TreeNode treeNode : allNode) {
                if (!treeNode.getText().contains(searchText)) continue;
                list.add(treeNode);
            }
            if (list.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e0e\u201c%s\u201d\u7684\u76f8\u5173\u6570\u636e", (String)"RiccEntityTreePlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]), searchText));
            } else {
                TreeNode focusNode = (TreeNode)list.get(0);
                treeView.focusNode(focusNode);
                this.treeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put("searchText", searchText);
                this.getPageCache().put(SEARCH_TEXT_TIME, "1");
                this.getPageCache().put("searchData", SerializationUtils.toJsonString(list));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        TreeView tree = (TreeView)this.getView().getControl(CTRL_TREEVIEW);
        TreeNode root = this.buildRootNode();
        this.getPageCache().put(TREE_NODE_CACHE, SerializationUtils.toJsonString((Object)root));
        tree.addNode(root);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        QFilter filter = this.nodeClickFilter();
        if (filter != null) {
            e.addQFilter(filter);
            e.setCancel(true);
        }
    }

    protected QFilter nodeClickFilter() {
        TreeNode focusNode = this.getFocusNode();
        QFilter qFilter = null;
        if (Objects.nonNull(focusNode)) {
            Object nodeData = focusNode.getData();
            if (Objects.isNull(nodeData)) {
                return null;
            }
            if (CLOUD.equalsIgnoreCase(nodeData.toString())) {
                DynamicObjectCollection appObjs = BizAppServiceHelp.getAllBizAppsByCloudID((String)focusNode.getId());
                List appIds = appObjs.stream().map(o -> o.getString("id")).collect(Collectors.toList());
                qFilter = new QFilter("bizappid", "in", appIds);
            } else {
                qFilter = new QFilter("bizappid", "=", (Object)focusNode.getId());
            }
        }
        return qFilter;
    }

    private void searchByPageCache(TreeView treeView) {
        List listFormCache;
        String searchDataString;
        String searchTextTimeString = this.getPageCache().get(SEARCH_TEXT_TIME);
        int searchTextTime = 1;
        if (StringUtils.isNotBlank((CharSequence)searchTextTimeString)) {
            searchTextTime = Integer.parseInt(searchTextTimeString);
        }
        if ((searchDataString = this.getPageCache().get("searchData")) != null && !(listFormCache = SerializationUtils.fromJsonStringToList((String)searchDataString, TreeNode.class)).isEmpty()) {
            if (listFormCache.size() > searchTextTime) {
                TreeNode focusNode = (TreeNode)listFormCache.get(searchTextTime);
                treeView.focusNode(focusNode);
                this.treeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put(SEARCH_TEXT_TIME, String.valueOf(searchTextTime + 1));
            } else {
                TreeNode focusNode = (TreeNode)listFormCache.get(0);
                treeView.focusNode(focusNode);
                this.treeNodeClick(focusNode.getId());
                treeView.expand(focusNode.getParentid());
                this.getPageCache().put(SEARCH_TEXT_TIME, "1");
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.treeNodeClick(evt.getNodeId().toString());
    }

    private void treeNodeClick(String nodeId) {
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_NODE_CACHE), TreeNode.class);
        TreeNode checkedNode = root.getTreeNode(nodeId, 10);
        TreeView tree = (TreeView)this.getControl(CTRL_TREEVIEW);
        tree.focusNode(checkedNode);
        tree.expand(nodeId);
    }

    private TreeNode getFocusNode() {
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREE_NODE_CACHE), TreeNode.class);
        return root.getTreeNode((String)currentNodeId, 10);
    }

    private TreeNode buildRootNode() {
        TreeNode rootNode = (TreeNode)BizAppServiceHelp.getSubsysTree(null, null, null, (String)"app", (boolean)false, (boolean)true, (boolean)false);
        TreeNode sysRoot = this.getTreeModel().getRoot();
        sysRoot.addChildren(rootNode.getChildren());
        return sysRoot;
    }
}

