/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.mservice.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class RiccUpdateWithOrgChangeEventPlugin
implements IEventServicePlugin {
    private static final String OPERATION_PARAMS = "base_orgchange_resetroot";
    private static final String PARAMS_NEW_ROOT_ORG = "newrootid";
    private static final String SYN_PARAMS_VIEW = "synviews";
    private static final String UNSYN_PARAMS_VIEW = "unsynviews";
    private static final String PARAMS_VIEW_ID = "viewid";
    private static final Log log = LogFactory.getLog(RiccUpdateWithOrgChangeEventPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        log.info("ricc handleRootOrgReset start");
        String variableStr = evt.getVariables();
        DBRoute sysRoute = DBRoute.of((String)"sys");
        JSONObject variables = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
        JSONObject operationParams = variables.getJSONObject(OPERATION_PARAMS);
        if (operationParams == null) {
            return evt.getEventId();
        }
        JSONArray synViewArray = operationParams.getJSONArray(SYN_PARAMS_VIEW);
        JSONArray unSynViewArray = operationParams.getJSONArray(UNSYN_PARAMS_VIEW);
        synViewArray.addAll((Collection)unSynViewArray);
        if (CollectionUtils.isEmpty((Collection)synViewArray)) {
            return evt.getEventId();
        }
        HashMap<Long, Long> viewOrgMap = new HashMap<Long, Long>(synViewArray.size());
        for (Object viewMap : synViewArray) {
            JSONObject viewObj = (JSONObject)viewMap;
            Long newRootId = viewObj.getLong(PARAMS_NEW_ROOT_ORG);
            Long viewId = viewObj.getLong(PARAMS_VIEW_ID);
            viewOrgMap.put(viewId, newRootId);
        }
        if (!viewOrgMap.containsKey(15L) || viewOrgMap.get(15L) == null) {
            log.info(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u89c6\u56fe\u6839\u7ec4\u7ec7\u4e3a\u7a7a", (String)"RiccUpdateWithOrgChangeEventPlugin_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return evt.getEventId();
        }
        Long rootOrgId1 = (Long)viewOrgMap.get(15L);
        if (!viewOrgMap.containsKey(16L) || viewOrgMap.get(16L) == null) {
            log.info(ResManager.loadKDString((String)"\u4e3b\u6570\u636e\u63a7\u5236\u89c6\u56fe\u6839\u7ec4\u7ec7\u4e3a\u7a7a", (String)"RiccUpdateWithOrgChangeEventPlugin_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return evt.getEventId();
        }
        Long rootOrgId2 = (Long)viewOrgMap.get(16L);
        try (TXHandle handle = TX.requiresNew();){
            String updateSql1 = "update t_perm_bizroleorg set forgid = ? where fid in (1554214779973816320,1554215532792652800,1407814994422136832,1407809474541912064)";
            DB.execute((DBRoute)sysRoute, (String)updateSql1, (Object[])new Object[]{rootOrgId1});
            String updateSql2 = "update t_bas_assistantdata set fcreateorgid = ? where fid = 1553483065613971456";
            DB.execute((DBRoute)sysRoute, (String)updateSql2, (Object[])new Object[]{rootOrgId2});
            String updateSql3 = "update t_bas_assistantdataentry set fcreateorgid = ? where fentryid in (1553483441901760512,1553483579911141376,1553483752791963648)";
            DB.execute((DBRoute)sysRoute, (String)updateSql3, (Object[])new Object[]{rootOrgId2});
            log.info("ricc handleRootOrgReset end");
            Long l = evt.getEventId();
            return l;
        }
    }
}

