/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.opplugin;

import java.sql.Timestamp;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class ConfigDataClearOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ConfigDataClearOp.class);
    private static final String CLEARDATA = "cleardata";
    private static final String RICC_BASEDATA_ITEM = "ricc_basedata_item";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String opKey = args.getOperationKey();
        if (StringUtils.equals((String)CLEARDATA, (String)opKey)) {
            if (!PermissionServiceHelper.isAdminUser((long)UserServiceHelper.getCurrentUserId())) {
                args.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u4f7f\u7528\u7ba1\u7406\u5458\u529f\u80fd\u3002", (String)"ConfigDataClearOp_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            try {
                this.delete();
            }
            catch (RiccBizException e) {
                logger.error("ricc_clearconfigdata_error: " + CommonUtil.getExceptionDetailInfo((Throwable)e));
                String message = ResManager.loadKDString((String)"\u6570\u636e\u6e05\u7406\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406\uff1a", (String)"ConfigDataClearOp_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
                args.setCancelMessage(message + CommonUtil.getExceptionDetailInfo((Throwable)e));
                args.setCancel(true);
            }
        }
    }

    private void delete() {
        try (TXHandle handler = TX.requiresNew();){
            int deleteResult = DeleteServiceHelper.delete((String)"ricc_initconfig", null);
            if (deleteResult == 0) {
                logger.info(String.format("\u53c2\u6570\u8bbe\u7f6e\u5df2\u7ecf\u5220\u9664\u6216\u8005\u5220\u9664\u5931\u8d25%d", deleteResult));
                return;
            }
            logger.info(String.format("1.ricc_cleardata_\u53c2\u6570\u914d\u7f6e\u7684\u914d\u7f6e\u6570\u636e\u4ee5\u53ca\u6388\u6743\u6570\u636e_\u6210\u529f\u5220\u9664%d", deleteResult));
            SysParaUtil.cleanControlConfigCache();
            Long[] preinsBizRoles = new Long[]{1407809474541912064L, 1407814994422136832L};
            QFilter[] roleFilter = new QFilter[]{new QFilter("bizrole", "in", (Object)preinsBizRoles)};
            QFilter[] idFilter = new QFilter[]{new QFilter("id", "in", (Object)preinsBizRoles)};
            logger.info(String.format("1.2ricc_cleardata_\u9884\u7f6e\u4e1a\u52a1\u89d2\u8272\u7528\u6237\u5206\u914d\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"perm_userbizrole", (QFilter[])roleFilter)));
            logger.info(String.format("1.3ricc_cleardata_\u9884\u7f6e\u4e1a\u52a1\u89d2\u8272\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"perm_bizrole", (QFilter[])idFilter)));
            logger.info(String.format("1.4ricc_cleardata_\u9884\u7f6e\u901a\u7528\u89d2\u8272\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"perm_role", (QFilter[])new QFilter("number", "=", (Object)"RICC_COMMON_ROLE_S").toArray())));
            PermissionServiceHelper.clearAllCache();
            logger.info(String.format("2.ricc_cleardata_\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7ba1\u7406_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_destaccount", null)));
            logger.info(String.format("3.ricc_cleardata_\u4f20\u8f93\u5305\u7ba1\u7406_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_datapacket", null)));
            logger.info(String.format("4.ricc_cleardata_\u5728\u7ebf\u4f20\u8f93\u4efb\u52a1_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_transfertask", null)));
            logger.info(String.format("5.ricc_cleardata_\u65e5\u5fd7\u7ba1\u7406_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_log", null)));
            logger.info(String.format("6.ricc_cleardata_\u521d\u59cb\u5316\u8bb0\u5f55\u8868\u6e05\u7a7a\u6210\u529f%d", DeleteServiceHelper.delete((String)"ricc_initcheck", null)));
            logger.info(String.format("7.ricc_clearbddata_\u540c\u6b65\u65b9\u6848\u914d\u7f6e_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_schemeconfig", null)));
            logger.info(String.format("8.ricc_clearbddata_\u65e5\u5fd7\u7ba1\u7406_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_basedata_log", null)));
            logger.info(String.format("9.ricc_clearbddata_\u57fa\u7840\u6570\u636e\u9879\u65b9\u6848_\u6210\u529f\u5220\u9664%d", this.deleteBdItemSchemeEntry(RICC_BASEDATA_ITEM, "ricc_schemeentry")));
            logger.info(String.format("10.ricc_clearbddata_\u57fa\u7840\u914d\u7f6e\u9879\u65b9\u6848_\u6210\u529f\u5220\u9664%d", this.deleteBdItemSchemeEntry("ricc_configitems", "ricc_schemeentry")));
            logger.info(String.format("11.ricc_clearbddata_\u57fa\u7840\u6570\u636e\u540c\u6b65\u65e5\u5fd7_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_bdsync_log", null)));
            QFilter batchPackSchemeDel = new QFilter("ispreset", "=", (Object)Boolean.FALSE);
            logger.info(String.format("12.ricc_packscheme_\u975e\u9884\u7f6e\u6279\u91cf\u6253\u5305\u65b9\u6848_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_packscheme", (QFilter[])batchPackSchemeDel.toArray())));
            logger.info(String.format("13.ricc_clear_batchdatacompare_rpt_\u6570\u636e\u5bf9\u6bd4\u62a5\u544a_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_datacompare_rpt", null)));
            logger.info(String.format("14.ricc_clear_batchdatacompare_plan_\u6570\u636e\u5bf9\u6bd4\u65b9\u6848_\u6210\u529f\u5220\u9664%d", DeleteServiceHelper.delete((String)"ricc_datacompare_plan", null)));
            QFilter filter = new QFilter("number", "=", (Object)"ricc");
            DynamicObject thirdApp = BusinessDataServiceHelper.loadSingle((String)"third_app", (String)"enable,syspwd,modifier,modifytime", (QFilter[])filter.toArray());
            if (thirdApp != null) {
                thirdApp.set("enable", (Object)"0");
                thirdApp.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
                thirdApp.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"third_app", (DynamicObject[])new DynamicObject[]{thirdApp}, (OperateOption)OperateOption.create());
                if (!result.isSuccess()) {
                    throw new RiccBizException(String.format(ResManager.loadKDString((String)"ricc\u7b2c\u4e09\u65b9\u5e94\u7528\u7981\u7528\u5931\u8d25\uff1a%1$s%2$s", (String)"ConfigDataClearOp_2", (String)"sys-ricc-platform", (Object[])new Object[0]), result.getAllErrorOrValidateInfo(), result.getValidateResult()));
                }
            }
        }
        boolean success = SysParaUtil.iscLinkDelete();
        logger.info("4.ricc_clearbddata_\u96c6\u6210\u8fde\u63a5\u4e0e\u6570\u636e\u6e90_\u53bb\u6389\u5173\u8054%s", (Object)String.valueOf(success));
    }

    private int deleteBdItemSchemeEntry(String itemType, String entryEntity) {
        DynamicObject[] bdItems;
        Object[] pks = QueryServiceHelper.queryPrimaryKeys((String)itemType, null, null, (int)-1).toArray();
        for (DynamicObject bdItem : bdItems = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)itemType))) {
            DynamicObjectCollection schemeEntry = bdItem.getDynamicObjectCollection(entryEntity);
            schemeEntry.clear();
        }
        return SaveServiceHelper.save((DynamicObject[])bdItems).length;
    }
}

