/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util.setter;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.FieldProp;
import kd.sys.ricc.common.util.IscUtil;
import kd.sys.ricc.common.util.setter.Setter;

public class FieldPropSetter
implements Setter {
    private FieldProp fieldProp;
    private static String label = "label";

    public FieldPropSetter(FieldProp fieldProp) {
        this.fieldProp = fieldProp;
    }

    @Override
    public void setObjValue(DynamicObject object, String property, Object value) {
        object.set(property, value);
    }

    @Override
    public void setMapValue(Map<String, Object> map, Map<String, Object> requires, String property, DynamicObject obj) {
        Object val = obj.get(property);
        map.put(property, val);
    }

    @Override
    public void setSchema(Map<String, Object> map, String parentEntityName, String property) {
        map.put("is_primary_key", this.fieldProp.isPrimaryKey());
        map.put("is_nullable", !this.fieldProp.isMustInput());
        map.put("data_type", IscUtil.formatDataType(this.fieldProp.getPropertyType().getSimpleName()));
        if ("id".equalsIgnoreCase(this.fieldProp.getName())) {
            map.put(label, "ID");
            if (this.fieldProp.getParent() instanceof EntryType) {
                map.put(label, ResManager.loadKDString((String)"\u5206\u5f55id", (String)"FieldPropSetter_0", (String)"sys-ricc-common", (Object[])new Object[0]));
            }
            map.put("is_nullable", Boolean.FALSE);
        } else {
            map.put(label, this.fieldProp.getDisplayName() == null ? this.fieldProp.getName() : this.fieldProp.getDisplayName().toString());
        }
    }

    @Override
    public void setMapValByPropertyVal(Map<String, Object> targetMap, String propertyKey, Map<String, Object> propertyValueMap, Set<String> ignorePropertyKeySet) {
        targetMap.put(propertyKey, propertyValueMap.get(propertyKey));
    }
}

