/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import com.sheca.safeengine.CertIsRevokeFromLocal;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.bouncycastle.util.encoders.Base64;

abstract class CertIsRevoke {
    CertIsRevoke() {
    }

    public int certIsRevoked(X509Certificate oCert) {
        String[] arrDPNs = this.getDPNs(oCert);
        int iNum = 0;
        while (iNum < arrDPNs.length) {
            byte[] bCRL = this.fetchDPN(arrDPNs[iNum]);
            if (bCRL == null || bCRL.length == 0) {
                if (iNum >= arrDPNs.length - 1) {
                    this.showError();
                    return -1;
                }
            } else {
                if (this.crlVerify(oCert, bCRL)) {
                    CertIsRevokeFromLocal.saveCrl(oCert, bCRL);
                    return 1;
                }
                System.out.println("Certificate revoked");
                return 0;
            }
            ++iNum;
        }
        return -1;
    }

    public abstract void showError();

    public abstract String[] getDPNs(X509Certificate var1);

    public abstract byte[] fetchDPN(String var1);

    protected boolean crlVerify(X509Certificate oCert, byte[] bCrl) {
        X509CRL oCRL = null;
        CertificateFactory cf = null;
        ByteArrayInputStream bIn = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (Exception e) {
            CertIsRevoke.printErr("crlIsRevocked factory getInstance error:", e);
            return false;
        }
        try {
            bIn = new ByteArrayInputStream(bCrl);
        }
        catch (Exception e) {
            CertIsRevoke.printErr("crlIsRevocked create ByteArrayInputStream error:", e);
            return false;
        }
        try {
            oCRL = (X509CRL)cf.generateCRL(bIn);
        }
        catch (Exception e) {
            try {
                bCrl = Base64.decode((byte[])bCrl);
                bIn = new ByteArrayInputStream(bCrl);
            }
            catch (Exception e1) {
                CertIsRevoke.printErr("crlIsRevocked create ByteArrayInputStream error:", e1);
                return false;
            }
            try {
                oCRL = (X509CRL)cf.generateCRL(bIn);
            }
            catch (Exception e1) {
                CertIsRevoke.printErr("crlIsRevocked factory generateCRL error:", e1);
                return false;
            }
        }
        return CertIsRevoke.crlVerify(oCert, oCRL);
    }

    private static boolean crlVerify(X509Certificate oCert, X509CRL oCrl) {
        boolean ret = false;
        try {
            ret = oCrl.isRevoked(oCert);
        }
        catch (Exception e) {
            CertIsRevoke.printErr("crlVerify isRevoked error:", e);
        }
        return !ret;
    }

    private static void printErr(String sInfo, Exception e) {
        String sErr = null;
        if (sInfo != null) {
            sErr = sInfo;
        }
        System.err.println(sErr);
        System.out.println();
    }
}

