/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.safeengine;

import com.sun.jndi.ldap.LdapURL;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;

class FetchCRL {
    static int m_connectTimeout;
    static int m_readTimeout;

    FetchCRL() {
    }

    public static void SetConnectTimeout(int timeout) {
        m_connectTimeout = timeout;
    }

    public static void SetReadTimeout(int timeout) {
        m_readTimeout = timeout;
    }

    public static byte[] getCRL(String sDPN) {
        byte[] rtnCRL = null;
        String str = sDPN.toLowerCase();
        rtnCRL = str.startsWith("ldap://") && str.indexOf(63) > 0 ? FetchCRL.getCRLFromLdap(sDPN) : FetchCRL.getCRLFromHttp(sDPN);
        return rtnCRL;
    }

    private static byte[] getCRLFromHttp(String sDPN) {
        byte[] btCrl = null;
        try {
            int current;
            URL url = new URL(sDPN);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(m_connectTimeout);
            conn.setReadTimeout(m_readTimeout);
            InputStream is = conn.getInputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((current = bis.read()) != -1) {
                baos.write(current);
            }
            btCrl = baos.toByteArray();
        }
        catch (Exception ex) {
            FetchCRL.printErr("getCRLFromHttp error:", ex);
            return null;
        }
        return btCrl;
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] getCRLFromLdap(String sDPN) {
        System.out.print("\nldap starting ...");
        oLURL = null;
        bRet = null;
        env = new Hashtable<String, String>();
        ctx = null;
        en = null;
        ae = null;
        attr = null;
        vals = null;
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        try {
            oLURL = new LdapURL(sDPN);
        }
        catch (Exception e) {
            FetchCRL.printErr("getCRLFromLdap create LdapURL error:", e);
            return null;
        }
        sDPN = "ldap://" + oLURL.getHost() + ":" + oLURL.getPort();
        if (sDPN == null) {
            FetchCRL.printErr("getCRLFromLdap wrong Ldap url error.", null);
            return null;
        }
        env.put("java.naming.provider.url", sDPN);
        try {
            ctx = new InitialLdapContext(env, null);
        }
        catch (Exception e) {
            FetchCRL.printErr("getCRLFromLdap create InitialLdapContext error:", e);
            return null;
        }
        constraints = new SearchControls();
        iScope = 2;
        sScope = oLURL.getScope();
        if ("sub".equalsIgnoreCase(sScope)) {
            iScope = 2;
        } else if ("one".equalsIgnoreCase(sScope)) {
            iScope = 1;
        } else if ("base".equalsIgnoreCase(sScope)) {
            iScope = 0;
        }
        constraints.setSearchScope(iScope);
        returnedAtts = new String[]{"certificateRevocationList"};
        constraints.setReturningAttributes(returnedAtts);
        sDPN = oLURL.getFilter();
        if (sDPN == null) {
            FetchCRL.printErr("getCRLFromLdap getFilter error.", null);
            return null;
        }
        if (sDPN.endsWith(")")) {
            sDPN = sDPN.substring(1, sDPN.length() - 1);
        }
        try {
            en = ctx.search(oLURL.getDN(), sDPN, constraints);
        }
        catch (Exception e) {
            e.printStackTrace();
            FetchCRL.printErr("getCRLFromLdap ldapcontext search error:", e);
            return null;
        }
        iFound = false;
        while (en != null && en.hasMoreElements()) {
            block28: {
                block29: {
                    block30: {
                        obj = en.nextElement();
                        if (!(obj instanceof SearchResult)) break block29;
                        si = (SearchResult)obj;
                        sDPN = si.getName();
                        attrs = si.getAttributes();
                        if (attrs != null) break block30;
                        System.out.println("No attributes found.");
                        break block28;
                    }
                    try {
                        ae = attrs.getAll();
                        if (true) ** GOTO lbl99
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        FetchCRL.printErr("getCRLFromLdap attributes getAll error:", e);
                        continue;
                    }
                    do {
                        try {
                            attr = ae.next();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            FetchCRL.printErr("getCRLFromLdap attribute next error:", e);
                            continue;
                        }
                        attrId = attr.getID();
                        try {
                            vals = attr.getAll();
                            if (true) ** GOTO lbl97
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            FetchCRL.printErr("getCRLFromLdap attribute getAll error:", e);
                            return null;
                        }
                        do {
                            if ((o = vals.nextElement()) instanceof byte[]) {
                                bRet = (byte[])o;
                                iFound = true;
                                break;
                            }
                            System.out.println(o);
lbl97:
                            // 2 sources

                        } while (vals.hasMoreElements());
                        if (iFound) break block28;
lbl99:
                        // 3 sources

                    } while (ae.hasMoreElements());
                    break block28;
                }
                System.out.println(obj);
            }
            if (iFound) break;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception e) {
                FetchCRL.printErr("getCRLFromLdap ldapcontext close error:", e);
            }
        }
        System.out.print("\nldap ending ...");
        return bRet;
    }

    private static void printErr(String sInfo, Exception e) {
        String sErr = null;
        if (sInfo != null) {
            sErr = sInfo;
        }
        System.err.println(sErr);
        System.out.println();
    }
}

