/*
 * Decompiled with CFR 0.152.
 */
package com.sheca.seal;

import com.sheca.safeengine.javasafeengine;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.bouncycastle.util.encoders.Base64;

public class SealStamp {
    public static int DWORD = 4;
    public static int WORD = 2;
    public static int SHA1withRSA = 3;
    public static int STAMPDATA = 968;
    public static int BASIC_LENGTH = 3316;
    public static int SEAL_POSITION_X = 0x2E0000;
    public static int SEAL_POSITION_Y = 4032392;
    private String signAlgorithm = "SHA1withRSA";
    private String algProvider = "FishermanJCE";

    public String getAlgProvider() {
        return this.algProvider;
    }

    public void setAlgProvider(String algProvider) {
        this.algProvider = algProvider;
    }

    private byte[] sealdata(byte[] bpic, byte[] bseal, byte[] sign, byte[] cert, int sealPositionX, int sealPositionY) {
        Object seal_data = null;
        SEAL_POSITION_X = sealPositionX;
        SEAL_POSITION_Y = sealPositionY;
        byte[] dversion = new byte[BASIC_LENGTH + bpic.length];
        System.arraycopy(SealStamp.toLH(1), 0, dversion, 0, DWORD);
        System.arraycopy(SealStamp.toLH(BASIC_LENGTH + bpic.length), 0, dversion, 4, DWORD);
        System.arraycopy(SealStamp.toLH((short)SHA1withRSA), 0, dversion, 8, WORD);
        System.arraycopy(SealStamp.toLH((short)sign.length), 0, dversion, 10, WORD);
        System.arraycopy(sign, 0, dversion, 12, sign.length);
        Date aDate = new Date(System.currentTimeMillis());
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(aDate);
        System.arraycopy(SealStamp.toLH((short)calendar.get(1)), 0, dversion, 268, WORD);
        System.arraycopy(SealStamp.toLH((short)calendar.get(2)), 0, dversion, 270, WORD);
        System.arraycopy(SealStamp.toLH((short)calendar.get(3)), 0, dversion, 272, WORD);
        System.arraycopy(SealStamp.toLH((short)calendar.get(5)), 0, dversion, 274, WORD);
        System.arraycopy(SealStamp.toLH((short)calendar.get(11)), 0, dversion, 276, WORD);
        System.arraycopy(SealStamp.toLH((short)calendar.get(12)), 0, dversion, 278, WORD);
        System.arraycopy(SealStamp.toLH((short)calendar.get(13)), 0, dversion, 280, WORD);
        System.arraycopy(SealStamp.toLH((short)calendar.get(14)), 0, dversion, 282, WORD);
        System.arraycopy(bseal, 0, dversion, 284, STAMPDATA);
        System.arraycopy(SealStamp.toLH(SEAL_POSITION_X), 0, dversion, 1252, DWORD);
        System.arraycopy(SealStamp.toLH(SEAL_POSITION_Y), 0, dversion, 1256, DWORD);
        System.arraycopy(SealStamp.toLH(cert.length), 0, dversion, 1260, DWORD);
        System.arraycopy(cert, 0, dversion, 1264, cert.length);
        System.arraycopy(SealStamp.toLH(bpic.length), 0, dversion, 3312, DWORD);
        System.arraycopy(bpic, 0, dversion, 3316, bpic.length);
        return dversion;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public void setSignAlgorithm(String signAlgorithm) {
        this.signAlgorithm = signAlgorithm;
    }

    private String[] parseFile(String fileName) throws IOException {
        FileInputStream inputStream = null;
        InputStreamReader inputReader = null;
        BufferedReader br = null;
        String[] arr = null;
        try {
            try {
                inputStream = new FileInputStream(fileName);
                inputReader = new InputStreamReader(inputStream);
                br = new BufferedReader(inputReader);
                String data = null;
                String reqall = "";
                while ((data = br.readLine()) != null) {
                    reqall = String.valueOf(reqall) + data;
                }
                System.out.println(reqall);
                arr = reqall.split("-----------------------------------SPLIT LINE-----------------------------------");
            }
            catch (IOException iOException) {
                br.close();
                inputReader.close();
                inputStream.close();
            }
        }
        finally {
            br.close();
            inputReader.close();
            inputStream.close();
        }
        return arr;
    }

    public String sealsign(String sealFilePath, KeyStore keystore, String sAlias, String sKeyPin, byte[] tobesign, int sealPositionX, int sealPositionY) {
        javasafeengine jse = new javasafeengine();
        String[] arr_seal = null;
        try {
            arr_seal = this.parseFile(sealFilePath);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Certificate oCert = jse.getCertFromStore(keystore, sAlias, sKeyPin);
        byte[] bcert = null;
        PrivateKey prtkey = (PrivateKey)jse.getPrivateKeyFromStore(keystore, sAlias, sKeyPin);
        byte[] sign = jse.sign(tobesign, prtkey, this.getSignAlgorithm(), this.getAlgProvider());
        byte[] bseal = null;
        byte[] bpic = null;
        try {
            bcert = oCert.getEncoded();
            bseal = Base64.decode((String)arr_seal[0]);
            bpic = Base64.decode((String)arr_seal[1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] sealstamp = this.sealdata(bpic, bseal, sign, bcert, sealPositionX, sealPositionY);
        String seal_data = new String(Base64.encode((byte[])sealstamp));
        return seal_data;
    }

    private static byte[] toLH(int n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return b;
    }

    public static byte[] toLH(short n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return b;
    }
}

