/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.crypto.BlockCipher;
import cn.com.infosec.crypto.BufferedBlockCipher;
import cn.com.infosec.crypto.CipherParameters;
import cn.com.infosec.crypto.DataLengthException;
import cn.com.infosec.crypto.InvalidCipherTextException;
import cn.com.infosec.crypto.engines.AESFastEngine;
import cn.com.infosec.crypto.engines.BlowfishEngine;
import cn.com.infosec.crypto.engines.CAST5Engine;
import cn.com.infosec.crypto.engines.CAST6Engine;
import cn.com.infosec.crypto.engines.DESEngine;
import cn.com.infosec.crypto.engines.DESedeEngine;
import cn.com.infosec.crypto.engines.GOST28147Engine;
import cn.com.infosec.crypto.engines.IDEAEngine;
import cn.com.infosec.crypto.engines.RC2Engine;
import cn.com.infosec.crypto.engines.RC532Engine;
import cn.com.infosec.crypto.engines.RC564Engine;
import cn.com.infosec.crypto.engines.RC6Engine;
import cn.com.infosec.crypto.engines.RijndaelEngine;
import cn.com.infosec.crypto.engines.SEEDEngine;
import cn.com.infosec.crypto.engines.SerpentEngine;
import cn.com.infosec.crypto.engines.SkipjackEngine;
import cn.com.infosec.crypto.engines.TEAEngine;
import cn.com.infosec.crypto.engines.TwofishEngine;
import cn.com.infosec.crypto.engines.XTEAEngine;
import cn.com.infosec.crypto.modes.AEADBlockCipher;
import cn.com.infosec.crypto.modes.CBCBlockCipher;
import cn.com.infosec.crypto.modes.CCMBlockCipher;
import cn.com.infosec.crypto.modes.CFBBlockCipher;
import cn.com.infosec.crypto.modes.CTSBlockCipher;
import cn.com.infosec.crypto.modes.EAXBlockCipher;
import cn.com.infosec.crypto.modes.GOFBBlockCipher;
import cn.com.infosec.crypto.modes.OFBBlockCipher;
import cn.com.infosec.crypto.modes.OpenPGPCFBBlockCipher;
import cn.com.infosec.crypto.modes.PGPCFBBlockCipher;
import cn.com.infosec.crypto.modes.SICBlockCipher;
import cn.com.infosec.crypto.paddings.BlockCipherPadding;
import cn.com.infosec.crypto.paddings.ISO10126d2Padding;
import cn.com.infosec.crypto.paddings.ISO7816d4Padding;
import cn.com.infosec.crypto.paddings.PaddedBufferedBlockCipher;
import cn.com.infosec.crypto.paddings.TBCPadding;
import cn.com.infosec.crypto.paddings.X923Padding;
import cn.com.infosec.crypto.paddings.ZeroBytePadding;
import cn.com.infosec.crypto.params.KeyParameter;
import cn.com.infosec.crypto.params.ParametersWithIV;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.params.ParametersWithSBox;
import cn.com.infosec.crypto.params.RC2Parameters;
import cn.com.infosec.crypto.params.RC5Parameters;
import cn.com.infosec.jce.provider.JCEPBEKey;
import cn.com.infosec.jce.provider.PBE;
import cn.com.infosec.jce.provider.WrapCipherSpi;
import cn.com.infosec.jce.spec.GOST28147ParameterSpec;
import cn.com.infosec.util.Strings;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class JCEBlockCipher
extends WrapCipherSpi
implements PBE {
    private Class[] availableSpecs = new Class[]{RC2ParameterSpec.class, RC5ParameterSpec.class, IvParameterSpec.class, PBEParameterSpec.class, GOST28147ParameterSpec.class};
    private BlockCipher baseEngine;
    private GenericBlockCipher cipher;
    private ParametersWithIV ivParam;
    private int ivLength = 0;
    private boolean padded = true;
    private PBEParameterSpec pbeSpec = null;
    private String pbeAlgorithm = null;
    private String modeName = null;

    protected JCEBlockCipher(BlockCipher engine) {
        this.baseEngine = engine;
        this.cipher = new BufferedGenericBlockCipher(engine);
    }

    protected JCEBlockCipher(BlockCipher engine, int ivLength) {
        this.baseEngine = engine;
        this.cipher = new BufferedGenericBlockCipher(engine);
        this.ivLength = ivLength / 8;
    }

    protected int engineGetBlockSize() {
        return this.baseEngine.getBlockSize();
    }

    protected byte[] engineGetIV() {
        return this.ivParam != null ? this.ivParam.getIV() : null;
    }

    protected int engineGetKeySize(Key key) {
        return key.getEncoded().length * 8;
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.cipher.getOutputSize(inputLen);
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            if (this.pbeSpec != null) {
                try {
                    this.engineParams = AlgorithmParameters.getInstance(this.pbeAlgorithm, "INFOSEC");
                    this.engineParams.init(this.pbeSpec);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (this.ivParam != null) {
                String name = this.cipher.getUnderlyingCipher().getAlgorithmName();
                if (name.indexOf(47) >= 0) {
                    name = name.substring(0, name.indexOf(47));
                }
                try {
                    this.engineParams = AlgorithmParameters.getInstance(name, "INFOSEC");
                    this.engineParams.init(this.ivParam.getIV());
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
            }
        }
        return this.engineParams;
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.modeName = Strings.toUpperCase(mode);
        if (this.modeName.equals("ECB")) {
            this.ivLength = 0;
            this.cipher = new BufferedGenericBlockCipher(this.baseEngine);
        } else if (this.modeName.equals("CBC")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new CBCBlockCipher(this.baseEngine));
        } else if (this.modeName.startsWith("OFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int wordSize = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new BufferedGenericBlockCipher(new OFBBlockCipher(this.baseEngine, wordSize));
            } else {
                this.cipher = new BufferedGenericBlockCipher(new OFBBlockCipher(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            }
        } else if (this.modeName.startsWith("CFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.modeName.length() != 3) {
                int wordSize = Integer.parseInt(this.modeName.substring(3));
                this.cipher = new BufferedGenericBlockCipher(new CFBBlockCipher(this.baseEngine, wordSize));
            } else {
                this.cipher = new BufferedGenericBlockCipher(new CFBBlockCipher(this.baseEngine, 8 * this.baseEngine.getBlockSize()));
            }
        } else if (this.modeName.startsWith("PGP")) {
            boolean inlineIV = this.modeName.equalsIgnoreCase("PGPCFBwithIV");
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new PGPCFBBlockCipher(this.baseEngine, inlineIV));
        } else if (this.modeName.equalsIgnoreCase("OpenPGPCFB")) {
            this.ivLength = 0;
            this.cipher = new BufferedGenericBlockCipher(new OpenPGPCFBBlockCipher(this.baseEngine));
        } else if (this.modeName.startsWith("SIC")) {
            this.ivLength = this.baseEngine.getBlockSize();
            if (this.ivLength < 16) {
                throw new IllegalArgumentException("Warning: SIC-Mode can become a twotime-pad if the blocksize of the cipher is too small. Use a cipher with a block size of at least 128 bits (e.g. AES)");
            }
            this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher(new SICBlockCipher(this.baseEngine)));
        } else if (this.modeName.startsWith("CTR")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher(new SICBlockCipher(this.baseEngine)));
        } else if (this.modeName.startsWith("GOFB")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher(new GOFBBlockCipher(this.baseEngine)));
        } else if (this.modeName.startsWith("CTS")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new BufferedGenericBlockCipher(new CTSBlockCipher(new CBCBlockCipher(this.baseEngine)));
        } else if (this.modeName.startsWith("CCM")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new AEADGenericBlockCipher(new CCMBlockCipher(this.baseEngine));
        } else if (this.modeName.startsWith("EAX")) {
            this.ivLength = this.baseEngine.getBlockSize();
            this.cipher = new AEADGenericBlockCipher(new EAXBlockCipher(this.baseEngine));
        } else {
            throw new NoSuchAlgorithmException("can't support mode " + mode);
        }
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = Strings.toUpperCase(padding);
        if (paddingName.equals("NOPADDING")) {
            this.padded = false;
            if (this.cipher.wrapOnNoPadding()) {
                this.cipher = new BufferedGenericBlockCipher(new BufferedBlockCipher(this.cipher.getUnderlyingCipher()));
            }
        } else {
            if ("CCM".equals(this.modeName) || "EAX".equals(this.modeName)) {
                throw new NoSuchPaddingException("Only NoPadding can be used with AEAD modes.");
            }
            if (paddingName.equals("PKCS5PADDING") || paddingName.equals("PKCS7PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher());
            } else if (paddingName.equals("ZEROBYTEPADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ZeroBytePadding());
            } else if (paddingName.equals("ISO10126PADDING") || paddingName.equals("ISO10126-2PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ISO10126d2Padding());
            } else if (paddingName.equals("X9.23PADDING") || paddingName.equals("X923PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new X923Padding());
            } else if (paddingName.equals("ISO7816-4PADDING") || paddingName.equals("ISO9797-1PADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new ISO7816d4Padding());
            } else if (paddingName.equals("TBCPADDING")) {
                this.cipher = new BufferedGenericBlockCipher(this.cipher.getUnderlyingCipher(), new TBCPadding());
            } else if (paddingName.equals("WITHCTS")) {
                this.padded = false;
                this.cipher = new BufferedGenericBlockCipher(new CTSBlockCipher(this.cipher.getUnderlyingCipher()));
            } else {
                throw new NoSuchPaddingException("Padding " + padding + " unknown.");
            }
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        this.pbeSpec = null;
        this.pbeAlgorithm = null;
        this.engineParams = null;
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key for algorithm " + key.getAlgorithm() + " not suitable for symmetric enryption.");
        }
        if (params == null && this.baseEngine.getAlgorithmName().startsWith("RC5-64")) {
            throw new InvalidAlgorithmParameterException("RC5 requires an RC5ParametersSpec to be passed in.");
        }
        if (key instanceof JCEPBEKey) {
            JCEPBEKey k = (JCEPBEKey)key;
            this.pbeAlgorithm = k.getOID() != null ? k.getOID().getId() : k.getAlgorithm();
            if (k.getParam() != null) {
                param = k.getParam();
                this.pbeSpec = new PBEParameterSpec(k.getSalt(), k.getIterationCount());
            } else if (params instanceof PBEParameterSpec) {
                this.pbeSpec = (PBEParameterSpec)params;
                param = PBE.Util.makePBEParameters(k, params, this.cipher.getUnderlyingCipher().getAlgorithmName());
            } else {
                throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
            }
            if (param instanceof ParametersWithIV) {
                this.ivParam = (ParametersWithIV)param;
            }
        } else if (params == null) {
            param = new KeyParameter(key.getEncoded());
        } else if (params instanceof IvParameterSpec) {
            if (this.ivLength != 0) {
                IvParameterSpec p = (IvParameterSpec)params;
                if (p.getIV().length != this.ivLength && !this.modeName.equals("CCM") && !this.modeName.equals("EAX")) {
                    throw new InvalidAlgorithmParameterException("IV must be " + this.ivLength + " bytes long.");
                }
                param = new ParametersWithIV(new KeyParameter(key.getEncoded()), p.getIV());
                this.ivParam = (ParametersWithIV)param;
            } else {
                if (this.modeName != null && this.modeName.equals("ECB")) {
                    throw new InvalidAlgorithmParameterException("ECB mode does not use an IV");
                }
                param = new KeyParameter(key.getEncoded());
            }
        } else if (params instanceof GOST28147ParameterSpec) {
            GOST28147ParameterSpec gost28147Param = (GOST28147ParameterSpec)params;
            param = new ParametersWithSBox(new KeyParameter(key.getEncoded()), ((GOST28147ParameterSpec)params).getSbox());
            if (gost28147Param.getIV() != null && this.ivLength != 0) {
                param = new ParametersWithIV(param, gost28147Param.getIV());
                this.ivParam = (ParametersWithIV)param;
            }
        } else if (params instanceof RC2ParameterSpec) {
            RC2ParameterSpec rc2Param = (RC2ParameterSpec)params;
            param = new RC2Parameters(key.getEncoded(), ((RC2ParameterSpec)params).getEffectiveKeyBits());
            if (rc2Param.getIV() != null && this.ivLength != 0) {
                param = new ParametersWithIV(param, rc2Param.getIV());
                this.ivParam = (ParametersWithIV)param;
            }
        } else if (params instanceof RC5ParameterSpec) {
            RC5ParameterSpec rc5Param = (RC5ParameterSpec)params;
            param = new RC5Parameters(key.getEncoded(), ((RC5ParameterSpec)params).getRounds());
            if (this.baseEngine.getAlgorithmName().startsWith("RC5")) {
                if (this.baseEngine.getAlgorithmName().equals("RC5-32")) {
                    if (rc5Param.getWordSize() != 32) {
                        throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 32 not " + rc5Param.getWordSize() + ".");
                    }
                } else if (this.baseEngine.getAlgorithmName().equals("RC5-64") && rc5Param.getWordSize() != 64) {
                    throw new InvalidAlgorithmParameterException("RC5 already set up for a word size of 64 not " + rc5Param.getWordSize() + ".");
                }
            } else {
                throw new InvalidAlgorithmParameterException("RC5 parameters passed to a cipher that is not RC5.");
            }
            if (rc5Param.getIV() != null && this.ivLength != 0) {
                param = new ParametersWithIV(param, rc5Param.getIV());
                this.ivParam = (ParametersWithIV)param;
            }
        } else {
            throw new InvalidAlgorithmParameterException("unknown parameter type.");
        }
        if (this.ivLength != 0 && !(param instanceof ParametersWithIV)) {
            SecureRandom ivRandom = random;
            if (ivRandom == null) {
                ivRandom = new SecureRandom();
            }
            if (opmode == 1 || opmode == 3) {
                byte[] iv = new byte[this.ivLength];
                ivRandom.nextBytes(iv);
                param = new ParametersWithIV(param, iv);
                this.ivParam = (ParametersWithIV)param;
            } else if (this.cipher.getUnderlyingCipher().getAlgorithmName().indexOf("PGPCFB") < 0) {
                throw new InvalidAlgorithmParameterException("no IV set when one expected");
            }
        }
        if (random != null && this.padded) {
            param = new ParametersWithRandom(param, random);
        }
        try {
            switch (opmode) {
                case 1: 
                case 3: {
                    this.cipher.init(true, param);
                    break;
                }
                case 2: 
                case 4: {
                    this.cipher.init(false, param);
                    break;
                }
                default: {
                    throw new InvalidParameterException("unknown opmode " + opmode + " passed");
                }
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            int i = 0;
            while (i != this.availableSpecs.length) {
                try {
                    paramSpec = (AlgorithmParameterSpec)params.getParameterSpec(this.availableSpecs[i]);
                    break;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            if (paramSpec == null) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + params.toString());
            }
        }
        this.engineInit(opmode, key, paramSpec, random);
        this.engineParams = params;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        int length = this.cipher.getUpdateOutputSize(inputLen);
        if (length > 0) {
            byte[] out = new byte[length];
            int len = this.cipher.processBytes(input, inputOffset, inputLen, out, 0);
            if (len == 0) {
                return null;
            }
            if (len != out.length) {
                byte[] tmp = new byte[len];
                System.arraycopy(out, 0, tmp, 0, len);
                return tmp;
            }
            return out;
        }
        this.cipher.processBytes(input, inputOffset, inputLen, null, 0);
        return null;
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        try {
            return this.cipher.processBytes(input, inputOffset, inputLen, output, outputOffset);
        }
        catch (DataLengthException e) {
            throw new ShortBufferException(e.getMessage());
        }
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int len = 0;
        byte[] tmp = new byte[this.engineGetOutputSize(inputLen)];
        if (inputLen != 0) {
            len = this.cipher.processBytes(input, inputOffset, inputLen, tmp, 0);
        }
        try {
            len += this.cipher.doFinal(tmp, len);
        }
        catch (DataLengthException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
        if (len == tmp.length) {
            return tmp;
        }
        byte[] out = new byte[len];
        System.arraycopy(tmp, 0, out, 0, len);
        return out;
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException {
        int len = 0;
        if (inputLen != 0) {
            len = this.cipher.processBytes(input, inputOffset, inputLen, output, outputOffset);
        }
        try {
            return len + this.cipher.doFinal(output, outputOffset + len);
        }
        catch (DataLengthException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
        catch (InvalidCipherTextException e) {
            throw new BadPaddingException(e.getMessage());
        }
    }

    private static class AEADGenericBlockCipher
    implements GenericBlockCipher {
        private AEADBlockCipher cipher;

        AEADGenericBlockCipher(AEADBlockCipher cipher) {
            this.cipher = cipher;
        }

        public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
            this.cipher.init(forEncryption, params);
        }

        public String getAlgorithmName() {
            return this.cipher.getUnderlyingCipher().getAlgorithmName();
        }

        public boolean wrapOnNoPadding() {
            return false;
        }

        public BlockCipher getUnderlyingCipher() {
            return this.cipher.getUnderlyingCipher();
        }

        public int getOutputSize(int len) {
            return this.cipher.getOutputSize(len);
        }

        public int getUpdateOutputSize(int len) {
            return this.cipher.getUpdateOutputSize(len);
        }

        public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
            return this.cipher.processByte(in, out, outOff);
        }

        public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
            return this.cipher.processBytes(in, inOff, len, out, outOff);
        }

        public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
            return this.cipher.doFinal(out, outOff);
        }
    }

    public static class AES
    extends JCEBlockCipher {
        public AES() {
            super(new AESFastEngine());
        }
    }

    public static class AESCBC
    extends JCEBlockCipher {
        public AESCBC() {
            super(new CBCBlockCipher(new AESFastEngine()), 128);
        }
    }

    public static class AESCFB
    extends JCEBlockCipher {
        public AESCFB() {
            super(new CFBBlockCipher(new AESFastEngine(), 128), 128);
        }
    }

    public static class AESOFB
    extends JCEBlockCipher {
        public AESOFB() {
            super(new OFBBlockCipher(new AESFastEngine(), 128), 128);
        }
    }

    public static class Blowfish
    extends JCEBlockCipher {
        public Blowfish() {
            super(new BlowfishEngine());
        }
    }

    private static class BufferedGenericBlockCipher
    implements GenericBlockCipher {
        private BufferedBlockCipher cipher;

        BufferedGenericBlockCipher(BufferedBlockCipher cipher) {
            this.cipher = cipher;
        }

        BufferedGenericBlockCipher(BlockCipher cipher) {
            this.cipher = new PaddedBufferedBlockCipher(cipher);
        }

        BufferedGenericBlockCipher(BlockCipher cipher, BlockCipherPadding padding) {
            this.cipher = new PaddedBufferedBlockCipher(cipher, padding);
        }

        public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
            this.cipher.init(forEncryption, params);
        }

        public boolean wrapOnNoPadding() {
            return !(this.cipher instanceof CTSBlockCipher);
        }

        public String getAlgorithmName() {
            return this.cipher.getUnderlyingCipher().getAlgorithmName();
        }

        public BlockCipher getUnderlyingCipher() {
            return this.cipher.getUnderlyingCipher();
        }

        public int getOutputSize(int len) {
            return this.cipher.getOutputSize(len);
        }

        public int getUpdateOutputSize(int len) {
            return this.cipher.getUpdateOutputSize(len);
        }

        public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
            return this.cipher.processByte(in, out, outOff);
        }

        public int processBytes(byte[] in, int inOff, int len, byte[] out, int outOff) throws DataLengthException {
            return this.cipher.processBytes(in, inOff, len, out, outOff);
        }

        public int doFinal(byte[] out, int outOff) throws IllegalStateException, InvalidCipherTextException {
            return this.cipher.doFinal(out, outOff);
        }
    }

    public static class CAST5
    extends JCEBlockCipher {
        public CAST5() {
            super(new CAST5Engine());
        }
    }

    public static class CAST5CBC
    extends JCEBlockCipher {
        public CAST5CBC() {
            super(new CBCBlockCipher(new CAST5Engine()), 64);
        }
    }

    public static class CAST6
    extends JCEBlockCipher {
        public CAST6() {
            super(new CAST6Engine());
        }
    }

    public static class DES
    extends JCEBlockCipher {
        public DES() {
            super(new DESEngine());
        }
    }

    public static class DESCBC
    extends JCEBlockCipher {
        public DESCBC() {
            super(new CBCBlockCipher(new DESEngine()), 64);
        }
    }

    public static class DESede
    extends JCEBlockCipher {
        public DESede() {
            super(new DESedeEngine());
        }
    }

    public static class DESedeCBC
    extends JCEBlockCipher {
        public DESedeCBC() {
            super(new CBCBlockCipher(new DESedeEngine()), 64);
        }
    }

    public static class GOST28147
    extends JCEBlockCipher {
        public GOST28147() {
            super(new GOST28147Engine());
        }
    }

    public static class GOST28147cbc
    extends JCEBlockCipher {
        public GOST28147cbc() {
            super(new CBCBlockCipher(new GOST28147Engine()), 64);
        }
    }

    private static interface GenericBlockCipher {
        public void init(boolean var1, CipherParameters var2) throws IllegalArgumentException;

        public boolean wrapOnNoPadding();

        public String getAlgorithmName();

        public BlockCipher getUnderlyingCipher();

        public int getOutputSize(int var1);

        public int getUpdateOutputSize(int var1);

        public int processByte(byte var1, byte[] var2, int var3) throws DataLengthException;

        public int processBytes(byte[] var1, int var2, int var3, byte[] var4, int var5) throws DataLengthException;

        public int doFinal(byte[] var1, int var2) throws IllegalStateException, InvalidCipherTextException;
    }

    public static class IDEA
    extends JCEBlockCipher {
        public IDEA() {
            super(new IDEAEngine());
        }
    }

    public static class IDEACBC
    extends JCEBlockCipher {
        public IDEACBC() {
            super(new CBCBlockCipher(new IDEAEngine()), 64);
        }
    }

    public static class PBEWithAESCBC
    extends JCEBlockCipher {
        public PBEWithAESCBC() {
            super(new CBCBlockCipher(new AESFastEngine()));
        }
    }

    public static class PBEWithMD5AndDES
    extends JCEBlockCipher {
        public PBEWithMD5AndDES() {
            super(new CBCBlockCipher(new DESEngine()));
        }
    }

    public static class PBEWithMD5AndRC2
    extends JCEBlockCipher {
        public PBEWithMD5AndRC2() {
            super(new CBCBlockCipher(new RC2Engine()));
        }
    }

    public static class PBEWithSHA1AndDES
    extends JCEBlockCipher {
        public PBEWithSHA1AndDES() {
            super(new CBCBlockCipher(new DESEngine()));
        }
    }

    public static class PBEWithSHA1AndRC2
    extends JCEBlockCipher {
        public PBEWithSHA1AndRC2() {
            super(new CBCBlockCipher(new RC2Engine()));
        }
    }

    public static class PBEWithSHAAnd128BitRC2
    extends JCEBlockCipher {
        public PBEWithSHAAnd128BitRC2() {
            super(new CBCBlockCipher(new RC2Engine()));
        }
    }

    public static class PBEWithSHAAnd40BitRC2
    extends JCEBlockCipher {
        public PBEWithSHAAnd40BitRC2() {
            super(new CBCBlockCipher(new RC2Engine()));
        }
    }

    public static class PBEWithSHAAndDES2Key
    extends JCEBlockCipher {
        public PBEWithSHAAndDES2Key() {
            super(new CBCBlockCipher(new DESedeEngine()));
        }
    }

    public static class PBEWithSHAAndDES3Key
    extends JCEBlockCipher {
        public PBEWithSHAAndDES3Key() {
            super(new CBCBlockCipher(new DESedeEngine()));
        }
    }

    public static class PBEWithSHAAndIDEA
    extends JCEBlockCipher {
        public PBEWithSHAAndIDEA() {
            super(new CBCBlockCipher(new IDEAEngine()));
        }
    }

    public static class PBEWithSHAAndTwofish
    extends JCEBlockCipher {
        public PBEWithSHAAndTwofish() {
            super(new CBCBlockCipher(new TwofishEngine()));
        }
    }

    public static class RC2
    extends JCEBlockCipher {
        public RC2() {
            super(new RC2Engine());
        }
    }

    public static class RC2CBC
    extends JCEBlockCipher {
        public RC2CBC() {
            super(new CBCBlockCipher(new RC2Engine()), 64);
        }
    }

    public static class RC5
    extends JCEBlockCipher {
        public RC5() {
            super(new RC532Engine());
        }
    }

    public static class RC564
    extends JCEBlockCipher {
        public RC564() {
            super(new RC564Engine());
        }
    }

    public static class RC6
    extends JCEBlockCipher {
        public RC6() {
            super(new RC6Engine());
        }
    }

    public static class Rijndael
    extends JCEBlockCipher {
        public Rijndael() {
            super(new RijndaelEngine());
        }
    }

    public static class SEED
    extends JCEBlockCipher {
        public SEED() {
            super(new SEEDEngine());
        }
    }

    public static class Serpent
    extends JCEBlockCipher {
        public Serpent() {
            super(new SerpentEngine());
        }
    }

    public static class Skipjack
    extends JCEBlockCipher {
        public Skipjack() {
            super(new SkipjackEngine());
        }
    }

    public static class TEA
    extends JCEBlockCipher {
        public TEA() {
            super(new TEAEngine());
        }
    }

    public static class Twofish
    extends JCEBlockCipher {
        public Twofish() {
            super(new TwofishEngine());
        }
    }

    public static class XTEA
    extends JCEBlockCipher {
        public XTEA() {
            super(new XTEAEngine());
        }
    }
}

