/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1Object;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.jce.interfaces.PKCS12BagAttributeCarrier;
import cn.com.infosec.jce.provider.PKCS12BagAttributeCarrierImpl;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Enumeration;

public class JCESM2PrivateKey
implements PrivateKey,
PKCS12BagAttributeCarrier {
    private static final long serialVersionUID = 9223372036731319018L;
    private int bits = 256;
    private byte[] D;
    private static final byte[] HEADER;
    private PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    static {
        byte[] byArray = new byte[35];
        byArray[0] = 48;
        byArray[1] = 65;
        byArray[2] = 2;
        byArray[3] = 1;
        byArray[5] = 48;
        byArray[6] = 19;
        byArray[7] = 6;
        byArray[8] = 7;
        byArray[9] = 42;
        byArray[10] = -122;
        byArray[11] = 72;
        byArray[12] = -50;
        byArray[13] = 61;
        byArray[14] = 2;
        byArray[15] = 1;
        byArray[16] = 6;
        byArray[17] = 8;
        byArray[18] = 42;
        byArray[19] = -127;
        byArray[20] = 28;
        byArray[21] = -49;
        byArray[22] = 85;
        byArray[23] = 1;
        byArray[24] = -126;
        byArray[25] = 45;
        byArray[26] = 4;
        byArray[27] = 39;
        byArray[28] = 48;
        byArray[29] = 37;
        byArray[30] = 2;
        byArray[31] = 1;
        byArray[32] = 1;
        byArray[33] = 4;
        byArray[34] = 32;
        HEADER = byArray;
    }

    public JCESM2PrivateKey() {
        this.D = new byte[32];
    }

    public JCESM2PrivateKey(byte[] prik) throws InvalidKeyException {
        this.D = new byte[32];
        if (prik.length < 32) {
            throw new InvalidKeyException("Illegal key length:" + prik.length);
        }
        if (prik.length <= 35) {
            System.arraycopy(prik, prik.length - 32, this.D, 0, 32);
        } else {
            this.D = this.parseKey(prik);
        }
    }

    private byte[] parseKey(byte[] prik) throws InvalidKeyException {
        try {
            ASN1Sequence ao = (ASN1Sequence)ASN1Object.fromByteArray(prik);
            DEROctetString de = (DEROctetString)ao.getObjectAt(2);
            byte[] bs = de.getOctets();
            ao = (ASN1Sequence)ASN1Object.fromByteArray(bs);
            de = (DEROctetString)ao.getObjectAt(1);
            return de.getOctets();
        }
        catch (Exception e) {
            throw new InvalidKeyException(e);
        }
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public byte[] getD() {
        return this.D;
    }

    public void setD(byte[] d) {
        System.arraycopy(d, 0, this.D, 0, 32);
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public byte[] getEncoded() {
        byte[] tmp = new byte[this.D.length + HEADER.length];
        System.arraycopy(HEADER, 0, tmp, 0, HEADER.length);
        System.arraycopy(this.D, 0, tmp, HEADER.length, this.D.length);
        return tmp;
    }

    public String getFormat() {
        return "X.509";
    }

    public void setBagAttribute(DERObjectIdentifier oid, DEREncodable attribute) {
        this.attrCarrier.setBagAttribute(oid, attribute);
    }

    public DEREncodable getBagAttribute(DERObjectIdentifier oid) {
        return this.attrCarrier.getBagAttribute(oid);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    public int hashCode() {
        if (this.D != null) {
            return new BigInteger(this.D).hashCode();
        }
        return 42949672;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof JCESM2PrivateKey) {
            JCESM2PrivateKey prik = (JCESM2PrivateKey)o;
            if (this.D != null && prik.D == null || this.D == null && prik.D != null) {
                return false;
            }
            if (this.D == prik.D) {
                return true;
            }
            return Arrays.equals(this.D, prik.D);
        }
        return false;
    }
}

