/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.api;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.api.APIVersion;
import com.cfca.util.pki.api.CertUtil;
import com.cfca.util.pki.api.EncryptUtil;
import com.cfca.util.pki.api.EnvelopUtil;
import com.cfca.util.pki.api.KeyUtil;
import com.cfca.util.pki.api.SignatureUtil;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.encoders.Base64;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;

public class APITest {
    private Session session = null;

    public APITest() {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            this.session = jcrypto.openSession("JSOFT_LIB");
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void certTest() {
        try {
            boolean verifyCertDate;
            X509Cert x509Cert;
            String message;
            BufferedReader reader;
            block13: {
                System.out.println("\u8f93\u5165\u8bc1\u4e66\u8def\u5f84:");
                reader = new BufferedReader(new InputStreamReader(System.in));
                message = reader.readLine().trim();
                x509Cert = CertUtil.generateCert(message);
                System.out.println("\u8bc1\u4e66\u4e3b\u9898\uff1a" + x509Cert.getSubject());
                System.out.println("\u8bc1\u4e66\u9881\u53d1\u8005\uff1a" + x509Cert.getIssuer());
                System.out.println("\u8bc1\u4e66\u5e8f\u5217\u53f7\uff1a" + x509Cert.getStringSerialNumber());
                System.out.println("\u8bc1\u4e66\u6709\u6548\u671f\u8d77\u59cb\u65f6\u95f4\uff1a" + x509Cert.getNotBefore());
                System.out.println("\u8bc1\u4e66\u6709\u6548\u671f\u622a\u6b62\u65f6\u95f4\uff1a" + x509Cert.getNotAfter());
                System.out.println("\u8bc1\u4e66Base64\u7f16\u7801\uff1a" + new String(Base64.encode((byte[])x509Cert.getEncoded())));
                verifyCertDate = false;
                try {
                    verifyCertDate = CertUtil.verifyCertDate(x509Cert);
                }
                catch (PKIException ex1) {
                    if (ex1.getErrCode().equals("850901")) {
                        System.out.println("\u8bc1\u4e66\u672a\u751f\u6548");
                    }
                    if (!ex1.getErrCode().equals("850902")) break block13;
                    System.out.println("\u8bc1\u4e66\u5df2\u8fc7\u671f");
                }
            }
            if (verifyCertDate) {
                System.out.println("\u8bc1\u4e66\u6709\u6548\u671f\u9a8c\u8bc1\u901a\u8fc7");
            }
            System.out.println("\u8f93\u5165CA\u8bc1\u4e66\u8def\u5f84(.cer\u6216.p7b\u6587\u4ef6):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String caCertPath = reader.readLine().trim();
            X509Cert[] caCerts = null;
            caCerts = caCertPath.toLowerCase().endsWith(".cer") ? new X509Cert[]{new X509Cert((InputStream)new FileInputStream(caCertPath))} : CertUtil.parseP7b(caCertPath);
            boolean verifySign = CertUtil.verifyCertSign(x509Cert, caCerts, this.session);
            if (verifySign) {
                System.out.println("\u9a8c\u8bc1\u8bc1\u4e66\u7b7e\u540d\u6210\u529f");
            } else {
                System.out.println("\u9a8c\u8bc1\u8bc1\u4e66\u7b7e\u540d\u5931\u8d25");
            }
            boolean CRLOnLine = CertUtil.verifyCertByCRLOnLine(x509Cert);
            if (CRLOnLine) {
                System.out.println("\u5728\u7ebf\u9a8c\u8bc1CRL:\u8bc1\u4e66\u6ca1\u6709\u88ab\u540a\u9500");
            } else {
                System.out.println("\u5728\u7ebf\u9a8c\u8bc1CRL:\u8bc1\u4e66\u88ab\u540a\u9500");
            }
            System.out.println("\u79bb\u7ebfCRL\u9a8c\u8bc1\u8bc1\u4e66,\u8f93\u5165CRL\u8def\u5f84:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            message = reader.readLine().trim();
            boolean CRLOutLine = CertUtil.verifyCertByCRLOutLine(x509Cert, message, caCerts, this.session);
            if (CRLOutLine) {
                System.out.println("\u79bb\u7ebf\u9a8c\u8bc1CRL: \u8bc1\u4e66\u6ca1\u6709\u88ab\u540a\u9500");
            } else {
                System.out.println("\u79bb\u7ebf\u9a8c\u8bc1CRL: \u8bc1\u4e66\u88ab\u540a\u9500");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void envelopFileTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u52a0\u5bc6\u8bc1\u4e66\u8def\u5f84(.cer,\u591a\u5f20\u8bc1\u4e66\u7528';'\u5206\u9694):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            String[] certPaths = certPath.split(";");
            EnvelopUtil envUtil = new EnvelopUtil();
            int i = 0;
            while (i < certPaths.length) {
                X509Cert cert = new X509Cert((InputStream)new FileInputStream(certPaths[i]));
                envUtil.addRecipient(cert);
                ++i;
            }
            envUtil.setCMSFlag();
            envUtil.envelopeFile(srcFilePath, String.valueOf(srcFilePath) + ".enc", 0x100000, "RC4", this.session);
            System.out.println("\u4ea7\u751f\u52a0\u5bc6\u6587\u4ef6\u6210\u529f,\u8def\u5f84\u4e3a:" + srcFilePath + ".enc");
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void envelopMsgTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String content = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u52a0\u5bc6\u8bc1\u4e66\u8def\u5f84(.cer,\u591a\u5f20\u8bc1\u4e66\u7528';'\u5206\u9694):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            String[] certPaths = certPath.split(";");
            EnvelopUtil envUtil = new EnvelopUtil();
            int i = 0;
            while (i < certPaths.length) {
                X509Cert cert = new X509Cert((InputStream)new FileInputStream(certPaths[i]));
                envUtil.addRecipient(cert);
                ++i;
            }
            envUtil.setCMSFlag();
            byte[] b64MsgEnvelop = envUtil.envelopeMessage(content.getBytes(), "DESede/CBC/PKCS7Padding", this.session);
            System.out.println("\u4ea7\u751f\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u6210\u529f,\u52a0\u5bc6\u540e\u6d88\u606f\u4e3a:" + new String(b64MsgEnvelop));
            System.out.println("\u8f93\u5165\u89e3\u5bc6\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u89e3\u5bc6\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            byte[] src = envUtil.openEnvelopedMessage(b64MsgEnvelop, priKey, cert, this.session);
            System.out.println("\u89e3\u5bc6\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u6210\u529f,\u539f\u6587\u4e3a:" + new String(src));
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void openEnvelopFileTest() {
        try {
            System.out.println("\u8f93\u5165\u52a0\u5bc6\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String envFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u89e3\u5bc6\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u89e3\u5bc6\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            EnvelopUtil envUtil = new EnvelopUtil();
            int index = envFilePath.lastIndexOf(".");
            String srcPath = envFilePath.substring(0, index);
            envUtil.openEnvelopedFile(String.valueOf(srcPath) + ".dec", envFilePath, 0x100000, priKey, cert, this.session);
            System.out.println("\u89e3\u5bc6\u6587\u4ef6\u6210\u529f,\u8def\u5f84\u4e3a:" + srcPath + ".dec");
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p1SignMsgTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String src = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            SignatureUtil signUtil = new SignatureUtil();
            byte[] b64SignMsg = signUtil.p1SignMessage(src.getBytes(), "SHA1withRSAEncryption", priKey, this.session);
            System.out.println("\u7b7e\u540d\u6210\u529f,\u7b7e\u540d\u7ed3\u679c\u4e3a:" + new String(b64SignMsg));
            System.out.println("\u8f93\u5165\u9a8c\u7b7e\u8bc1\u4e66\u8def\u5f84(.cer):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pubCertPath = reader.readLine().trim();
            X509Cert cert = new X509Cert((InputStream)new FileInputStream(pubCertPath));
            boolean verify = signUtil.p1VerifySignMessage(src.getBytes(), b64SignMsg, "SHA1withRSAEncryption", cert, this.session);
            if (verify) {
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u6210\u529f");
            } else {
                System.out.println("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7SignFileTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            SignatureUtil signUtil = new SignatureUtil();
            signUtil.p7SignFile(true, srcFilePath, String.valueOf(srcFilePath) + ".sig", 0x100000, "SHA1withRSAEncryption", priKey, cert, this.session);
            System.out.println("\u6587\u4ef6\u7b7e\u540d\u6210\u529f,\u7b7e\u540d\u6587\u4ef6\u8def\u5f84\u4e3a:" + srcFilePath + ".sig");
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7SignFileDetachedTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            SignatureUtil signUtil = new SignatureUtil();
            signUtil.p7SignFile(false, srcFilePath, String.valueOf(srcFilePath) + ".nosrc.sig", 0x100000, "SHA1withRSAEncryption", priKey, cert, this.session);
            System.out.println("\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u6210\u529f,\u7b7e\u540d\u6587\u4ef6\u8def\u5f84\u4e3a:" + srcFilePath + ".nosrc.sig");
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7SignFileDetachedOutMsgTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            SignatureUtil signUtil = new SignatureUtil();
            byte[] signData = signUtil.p7SignFileDetachedOutMsg(srcFilePath, 0x100000, "SHA1withRSAEncryption", priKey, cert, this.session);
            System.out.println("\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u6210\u529f,\u7b7e\u540d\u7ed3\u679c\u4e3a:" + new String(signData));
            boolean verify = signUtil.p7VerifySignFileDetachedOutMsg(srcFilePath, signData, 0x100000, this.session);
            if (verify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
            } else {
                System.out.println("\u9a8c\u8bc1\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7ReSignFileDetachedTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b2c\u4e00\u4e2a\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            SignatureUtil signUtil = new SignatureUtil();
            signUtil.p7SignFile(false, srcFilePath, String.valueOf(srcFilePath) + ".nosrc.sig", 0x100000, "SHA1withRSAEncryption", priKey, cert, this.session);
            System.out.println("\u8f93\u5165\u7b2c\u4e8c\u4e2a\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            pwd = reader.readLine().trim();
            priKey = KeyUtil.getPriKey(certPath, pwd);
            cert = CertUtil.getCert(certPath, pwd);
            signUtil.p7ReSignFileDetached(srcFilePath, String.valueOf(srcFilePath) + ".nosrc.sig", String.valueOf(srcFilePath) + ".nosrc.resig", 0x100000, "SHA1withRSAEncryption", priKey, cert, this.session);
            System.out.println("\u591a\u4eba\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u6210\u529f,\u7b7e\u540d\u6587\u4ef6\u8def\u5f84\u4e3a:" + srcFilePath + ".nosrc.resig");
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7ReSignFileTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b2c\u4e00\u4e2a\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            SignatureUtil signUtil = new SignatureUtil();
            signUtil.p7SignFile(true, srcFilePath, String.valueOf(srcFilePath) + ".sig", 256, "SHA1withRSAEncryption", priKey, cert, this.session);
            System.out.println("\u8f93\u5165\u7b2c\u4e8c\u4e2a\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            pwd = reader.readLine().trim();
            priKey = KeyUtil.getPriKey(certPath, pwd);
            cert = CertUtil.getCert(certPath, pwd);
            signUtil.p7ReSignFile(String.valueOf(srcFilePath) + ".sig", String.valueOf(srcFilePath) + ".resig", 256, "SHA1withRSAEncryption", priKey, cert, this.session);
            System.out.println("\u591a\u4eba\u6587\u4ef6\u7b7e\u540d(\u975e\u5206\u79bb\u5f0f)\u6210\u529f,\u7b7e\u540d\u6587\u4ef6\u8def\u5f84\u4e3a:" + srcFilePath + ".resig");
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7VerifySignFileDetachedTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u6587\u4ef6\u8def\u5f84:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String signFilePath = reader.readLine().trim();
            SignatureUtil signUtil = new SignatureUtil();
            boolean verify = signUtil.p7VerifySignFileDetached(srcFilePath, signFilePath, 0x100000, this.session);
            if (verify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
            } else {
                System.out.println("\u9a8c\u8bc1\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u5931\u8d25" + signFilePath);
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7VerifySignFileTest() {
        try {
            System.out.println("\u8f93\u5165\u7b7e\u540d\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String signFilePath = reader.readLine().trim();
            SignatureUtil signUtil = new SignatureUtil();
            boolean verify = signUtil.p7VerifySignFile(String.valueOf(signFilePath) + ".ver", signFilePath, 0x100000, this.session);
            if (verify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u6587\u4ef6(\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
                System.out.println("\u9a8c\u8bc1\u6587\u4ef6(\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f,\u539f\u6587\u8f93\u51fa\u8def\u5f84\u4e3a:" + signFilePath + ".ver");
            } else {
                System.out.println("\u9a8c\u8bc1\u6587\u4ef6(\u5206\u79bb\u5f0f)\u7b7e\u540d\u5931\u8d25" + signFilePath);
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7SignMsgTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String src = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            X509Cert[] certs = new X509Cert[]{cert};
            SignatureUtil signUtil = new SignatureUtil();
            byte[] b64SignData = signUtil.p7SignMessage(true, src.getBytes(), "SHA1withRSAEncryption", priKey, certs, this.session);
            System.out.println("\u7b7e\u540d\u6210\u529f,\u7b7e\u540d\u7ed3\u679c\u4e3a:" + new String(b64SignData));
            boolean verify = signUtil.p7VerifySignMessage(b64SignData, this.session);
            if (verify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u975e\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
                byte[] srcData = signUtil.getSignedContent();
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u975e\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f,\u539f\u6587\u4e3a:" + new String(srcData));
            } else {
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u975e\u5206\u79bb\u5f0f)\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7SignMsgDetachedTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String input = reader.readLine().trim();
            String src = new String(input.getBytes());
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            X509Cert[] certs = new X509Cert[]{cert};
            SignatureUtil signUtil = new SignatureUtil();
            byte[] b64SignData = signUtil.p7SignMessage(false, src.getBytes(), "SHA1withRSAEncryption", priKey, certs, this.session);
            System.out.println("\u7b7e\u540d\u6210\u529f,\u7b7e\u540d\u7ed3\u679c\u4e3a:" + new String(b64SignData));
            boolean verify = signUtil.p7VerifySignMessageDetached(src.getBytes(), b64SignData, this.session);
            if (verify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
            } else {
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u5206\u79bb\u5f0f)\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7ReSignMsgTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String src = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b2c\u4e00\u4e2a\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            X509Cert[] certs = new X509Cert[]{cert};
            SignatureUtil signUtil = new SignatureUtil();
            byte[] b64SignData = signUtil.p7SignMessage(true, src.getBytes(), "SHA1withRSAEncryption", priKey, certs, this.session);
            System.out.println("\u7b2c\u4e00\u6b21\u7b7e\u540d\u6210\u529f");
            System.out.println("\u8f93\u5165\u7b2c\u4e8c\u4e2a\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            pwd = reader.readLine().trim();
            priKey = KeyUtil.getPriKey(certPath, pwd);
            cert = CertUtil.getCert(certPath, pwd);
            certs = new X509Cert[]{cert};
            byte[] b64ReSignData = signUtil.p7ReSignMessage(b64SignData, "SHA1withRSAEncryption", priKey, certs, this.session);
            System.out.println("\u7b2c\u4e8c\u6b21\u7b7e\u540d\u6210\u529f,\u7b7e\u540d\u7ed3\u679c\u4e3a:" + new String(b64ReSignData));
            boolean reVerify = signUtil.p7VerifySignMessage(b64ReSignData, this.session);
            if (reVerify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u591a\u4eba\u6d88\u606f(\u975e\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
                byte[] srcData = signUtil.getSignedContent();
                System.out.println("\u9a8c\u8bc1\u591a\u4eba\u6d88\u606f(\u975e\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f,\u539f\u6587\u4e3a:" + new String(srcData));
            } else {
                System.out.println("\u9a8c\u8bc1\u591a\u4eba\u6d88\u606f(\u975e\u5206\u79bb\u5f0f)\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7ReSignMsgDetachedTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String src = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b2c\u4e00\u4e2a\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            X509Cert[] certs = new X509Cert[]{cert};
            SignatureUtil signUtil = new SignatureUtil();
            byte[] b64SignData = signUtil.p7SignMessage(false, src.getBytes(), "SHA1withRSAEncryption", priKey, certs, this.session);
            System.out.println("\u7b2c\u4e00\u6b21\u7b7e\u540d\u6210\u529f");
            System.out.println("\u8f93\u5165\u7b2c\u4e8c\u4e2a\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            pwd = reader.readLine().trim();
            priKey = KeyUtil.getPriKey(certPath, pwd);
            cert = CertUtil.getCert(certPath, pwd);
            certs = new X509Cert[]{cert};
            byte[] b64ReSignData = signUtil.p7ReSignMessageDetached(src.getBytes(), b64SignData, "SHA1withRSAEncryption", priKey, certs, this.session);
            System.out.println("\u7b2c\u4e8c\u6b21\u7b7e\u540d\u6210\u529f,\u7b7e\u540d\u7ed3\u679c\u4e3a:" + new String(b64ReSignData));
            boolean reVerify = signUtil.p7VerifySignMessageDetached(src.getBytes(), b64ReSignData, this.session);
            if (reVerify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u591a\u4eba\u6d88\u606f(\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
            } else {
                System.out.println("\u9a8c\u8bc1\u591a\u4eba\u6d88\u606f(\u5206\u79bb\u5f0f)\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void encryptMsgTest() {
        try {
            System.out.println("\u7528\u5bf9\u79f0\u5bc6\u94a5\u52a0\u5bc6\u89e3\u5bc6\u6570\u636e");
            System.out.println("\u8f93\u5165\u539f\u6587:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String content = reader.readLine().trim();
            System.out.println("\u9009\u62e9\u4ea7\u751f\u5bc6\u94a5\u7b97\u6cd5\uff1a1-DES,2-DES3,3-RC4");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String encAlg = reader.readLine().trim();
            String keyType = "RC4";
            keyType = encAlg.equals("1") ? "DES" : (encAlg.equals("2") ? "DESede" : "RC4");
            JKey key = KeyUtil.generateKey(keyType, this.session);
            System.out.println("\u9009\u62e9\u5bf9\u79f0\u52a0\u5bc6\u6a21\u5f0f\uff1a1-ECB,2-CBC,3-RC4");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String encMode = reader.readLine().trim();
            encMode = encMode.equals("1") && encAlg.equals("1") ? "DES/ECB/PKCS7Padding" : (encMode.equals("1") && encAlg.equals("2") ? "DESede/ECB/PKCS7Padding" : (encMode.equals("2") && encAlg.equals("1") ? "DES/CBC/PKCS7Padding" : (encMode.equals("2") && encAlg.equals("2") ? "DESede/CBC/PKCS7Padding" : "RC4")));
            byte[] encData = EncryptUtil.encryptByKey(encMode, key, content.getBytes(), this.session);
            System.out.println("\u52a0\u5bc6\u7ed3\u679c\u6570\u636e\uff1a" + new String(encData));
            byte[] decData = EncryptUtil.decryptByKey(encMode, key, encData, this.session);
            if (Arrays.equals(content.getBytes(), decData)) {
                System.out.println("\u89e3\u5bc6\u6210\u529f\uff0c\u539f\u6587\u4e3a\uff1a" + new String(decData));
            } else {
                System.out.println("\u89e3\u5bc6\u5931\u8d25");
            }
            System.out.println("\u7528\u53e3\u4ee4\u52a0\u5bc6\u89e3\u5bc6\u6570\u636e");
            System.out.println("\u8f93\u5165\u539f\u6587:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            content = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u52a0\u5bc6\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            encAlg = "PBEWithSHA1AndDES";
            encData = EncryptUtil.encryptByPWD(encAlg, pwd, content.getBytes(), this.session);
            System.out.println("\u52a0\u5bc6\u7ed3\u679c\u6570\u636e\uff1a" + new String(encData));
            System.out.println("\u8f93\u5165\u89e3\u5bc6\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            pwd = reader.readLine().trim();
            decData = EncryptUtil.decryptByPWD(encAlg, pwd, encData, this.session);
            if (Arrays.equals(content.getBytes(), decData)) {
                System.out.println("\u89e3\u5bc6\u6210\u529f\uff0c\u539f\u6587\u4e3a\uff1a" + new String(decData));
            } else {
                System.out.println("\u89e3\u5bc6\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void encryptFileTest() {
        try {
            System.out.println("\u7528\u5bf9\u79f0\u5bc6\u94a5\u5bf9\u6587\u4ef6\u8fdb\u884c\u52a0\u5bc6\u548c\u89e3\u5bc6");
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFile = reader.readLine().trim();
            System.out.println("\u9009\u62e9\u4ea7\u751f\u5bc6\u94a5\u7b97\u6cd5\uff1a1-DES,2-DES3,3-RC4");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String encAlg = reader.readLine().trim();
            String keyType = "RC4";
            keyType = encAlg.equals("1") ? "DES" : (encAlg.equals("2") ? "DESede" : "RC4");
            JKey key = KeyUtil.generateKey(keyType, this.session);
            System.out.println("\u9009\u62e9\u5bf9\u79f0\u52a0\u5bc6\u6a21\u5f0f\uff1a1-ECB,2-CBC,3-RC4");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String encMode = reader.readLine().trim();
            encMode = encMode.equals("1") && encAlg.equals("1") ? "DES/ECB/PKCS7Padding" : (encMode.equals("1") && encAlg.equals("2") ? "DESede/ECB/PKCS7Padding" : (encMode.equals("2") && encAlg.equals("1") ? "DES/CBC/PKCS7Padding" : (encMode.equals("2") && encAlg.equals("2") ? "DESede/CBC/PKCS7Padding" : "RC4")));
            String encFile = String.valueOf(srcFile) + ".enc";
            EncryptUtil.encryptFileByKey(encMode, key, srcFile, encFile, 0x100000, this.session);
            System.out.println("\u52a0\u5bc6\u5b8c\u6210\uff0c\u52a0\u5bc6\u6587\u4ef6\u8def\u5f84\uff1a" + encFile);
            String decFile = String.valueOf(srcFile) + ".dec";
            EncryptUtil.decryptFileByKey(encMode, key, encFile, decFile, 0x100000, this.session);
            System.out.println("\u89e3\u5bc6\u5b8c\u6210\uff0c\u8bf7\u6bd4\u8f83\u89e3\u5bc6\u6587\u4ef6\u548c\u539f\u6587\u3002\u89e3\u5bc6\u540e\u8def\u5f84\u4e3a\uff1a" + decFile);
            System.out.println("\u7528\u53e3\u4ee4\u52a0\u5bc6\u89e3\u5bc6\u6587\u4ef6");
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            srcFile = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u52a0\u5bc6\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            encAlg = "PBEWithSHA1AndDES";
            encFile = String.valueOf(srcFile) + ".enc";
            EncryptUtil.encryptFileByPWD(encAlg, pwd, srcFile, encFile, 0x100000, this.session);
            System.out.println("\u52a0\u5bc6\u5b8c\u6210\uff0c\u52a0\u5bc6\u6587\u4ef6\u8def\u5f84\uff1a" + encFile);
            System.out.println("\u8f93\u5165\u89e3\u5bc6\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            pwd = reader.readLine().trim();
            decFile = String.valueOf(srcFile) + ".dec";
            EncryptUtil.decryptFileByPWD(encAlg, pwd, srcFile, encFile, 0x100000, this.session);
            System.out.println("\u89e3\u5bc6\u5b8c\u6210\uff0c\u8bf7\u6bd4\u8f83\u89e3\u5bc6\u6587\u4ef6\u548c\u539f\u6587\u3002\u89e3\u5bc6\u540e\u8def\u5f84\u4e3a\uff1a" + decFile);
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public String getVersion() {
        return APIVersion.getVersion();
    }

    public void hashTest() {
        try {
            System.out.println("\u9009\u62e9\u6587\u6458\u7b97\u6cd5\uff1a1-MD5,2-SHA1");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String hashAlg = reader.readLine().trim();
            hashAlg = hashAlg.equals("1") ? "MD5" : "SHA1";
            System.out.println("\u5bf9\u6570\u636e\u505a\u6587\u6458 ...");
            System.out.println("\u8f93\u5165\u539f\u6587:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String content = reader.readLine().trim();
            SignatureUtil signUtil = new SignatureUtil();
            byte[] hashBase64 = signUtil.hash(content.getBytes(), hashAlg, this.session);
            System.out.println("\u5bf9\u6570\u636e\u505a\u6587\u6458\u6210\u529f\uff0c\u6587\u6458\u503c\u4e3a\uff1a" + new String(hashBase64));
            System.out.println("");
            System.out.println("\u5bf9\u6570\u636e\u6d41\u505a\u6587\u6458 ...");
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6\u5168\u8def\u5f84:");
            String filePath = reader.readLine().trim();
            signUtil = new SignatureUtil();
            hashBase64 = signUtil.hash(filePath, 0, hashAlg, this.session);
            System.out.println("\u5bf9\u6570\u636e\u6d41\u505a\u6587\u6458\u6210\u529f\uff0c\u6587\u6458\u503c\u4e3a\uff1a" + new String(hashBase64));
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void timeStampTest() {
        try {
            System.out.println("\u8f93\u5165\u65f6\u95f4\u6233\u6587\u4ef6(Base64\u7f16\u7801)\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String stFile = reader.readLine().trim();
            FileInputStream srcFIS = new FileInputStream(stFile);
            int fileLen = srcFIS.available();
            byte[] data = new byte[fileLen];
            srcFIS.read(data);
            srcFIS.close();
            SignatureUtil signUtil = new SignatureUtil();
            boolean verify = signUtil.verifyTimeStamp(data, this.session);
            if (verify) {
                System.out.println("\u65f6\u95f4\u6233\u9a8c\u8bc1\u901a\u8fc7");
                X509Cert[] certs = signUtil.getSigerCert();
                System.out.println("\u65f6\u95f4\u6233\u670d\u52a1\u5668\u8bc1\u4e66\u4e3a:" + certs[0].getSubject());
                String strTime = signUtil.getTimeFromTimeStamp(data);
                System.out.println("\u65f6\u95f4\u6233\u7684\u65f6\u95f4\u4e3a:" + strTime);
            } else {
                System.out.println("\u65f6\u95f4\u6233\u9a8c\u8bc1\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7SignMsgWithMACTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String src = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            X509Cert[] certs = new X509Cert[]{cert};
            SignatureUtil signUtil = new SignatureUtil();
            byte[] b64SignData = signUtil.p7SignMessageWithMAC(true, src.getBytes(), "SHA1withRSAEncryption", priKey, certs, this.session);
            System.out.println("\u7b7e\u540d\u6210\u529f,\u7b7e\u540d\u7ed3\u679c\u4e3a:" + new String(b64SignData));
            boolean verify = signUtil.p7VerifySignMessage(b64SignData, this.session);
            if (verify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u975e\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
                byte[] srcData = signUtil.getSignedContent();
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u975e\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f,\u539f\u6587\u4e3a:" + new String(srcData));
            } else {
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u975e\u5206\u79bb\u5f0f)\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7SignMsgDetachedWithMACTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String input = reader.readLine().trim();
            String src = new String(input.getBytes());
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            X509Cert[] certs = new X509Cert[]{cert};
            SignatureUtil signUtil = new SignatureUtil();
            byte[] b64SignData = signUtil.p7SignMessageWithMAC(false, src.getBytes(), "SHA1withRSAEncryption", priKey, certs, this.session);
            System.out.println("\u7b7e\u540d\u6210\u529f,\u7b7e\u540d\u7ed3\u679c\u4e3a:" + new String(b64SignData));
            boolean verify = signUtil.p7VerifySignMessageDetached(src.getBytes(), b64SignData, this.session);
            if (verify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u5206\u79bb\u5f0f)\u7b7e\u540d\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
            } else {
                System.out.println("\u9a8c\u8bc1\u6d88\u606f(\u5206\u79bb\u5f0f)\u7b7e\u540d\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7SignFileWithMACTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            SignatureUtil signUtil = new SignatureUtil();
            signUtil.p7SignFileWithMAC(true, srcFilePath, String.valueOf(srcFilePath) + ".sig", 0x100000, "SHA1withRSAEncryption", priKey, cert, this.session);
            System.out.println("\u6587\u4ef6\u7b7e\u540d\u6210\u529f,\u7b7e\u540d\u6587\u4ef6\u8def\u5f84\u4e3a:" + srcFilePath + ".sig");
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public void p7SignFileDetachedOutMsgWithMACTest() {
        try {
            System.out.println("\u8f93\u5165\u539f\u6587\u4ef6\u8def\u5f84:");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String srcFilePath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u8def\u5f84(.pfx):");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String certPath = reader.readLine().trim();
            System.out.println("\u8f93\u5165\u7b7e\u540d\u8bc1\u4e66\u53e3\u4ee4:");
            reader = new BufferedReader(new InputStreamReader(System.in));
            String pwd = reader.readLine().trim();
            JKey priKey = KeyUtil.getPriKey(certPath, pwd);
            X509Cert cert = CertUtil.getCert(certPath, pwd);
            SignatureUtil signUtil = new SignatureUtil();
            byte[] signData = signUtil.p7SignFileDetachedOutMsgWithMAC(srcFilePath, 0x100000, "SHA1withRSAEncryption", priKey, cert, this.session);
            System.out.println("\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u6210\u529f,\u7b7e\u540d\u7ed3\u679c\u4e3a:" + new String(signData));
            boolean verify = signUtil.p7VerifySignFileDetachedOutMsg(srcFilePath, signData, 0x100000, this.session);
            if (verify) {
                X509Cert[] x509Certs = signUtil.getSigerCert();
                System.out.println("\u9a8c\u8bc1\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u6210\u529f, \u8bc1\u4e66\u4e3a:");
                int i = 0;
                while (i < x509Certs.length) {
                    System.out.println(x509Certs[i].getSubject());
                    ++i;
                }
            } else {
                System.out.println("\u9a8c\u8bc1\u6587\u4ef6\u7b7e\u540d(\u5206\u79bb\u5f0f)\u5931\u8d25");
            }
        }
        catch (PKIException ex) {
            System.out.println(ex.toString());
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }

    public static String printMessage() {
        System.out.println("*****************************************");
        System.out.println("          CFCA\u5de5\u5177\u53052.0\u529f\u80fd\u6d4b\u8bd5\u7a0b\u5e8f       ");
        System.out.println("*****************************************");
        System.out.println("\t1:\t\u8bc1\u4e66\u6d4b\u8bd5");
        System.out.println("\t2:\tPKCS7 \u6d88\u606f\u52a0\u5bc6\uff0c\u89e3\u5bc6\u6d4b\u8bd5");
        System.out.println("\t3:\tPKCS7 \u6587\u4ef6\u52a0\u5bc6\u6d4b\u8bd5");
        System.out.println("\t4:\tPKCS7 \u6587\u4ef6\u89e3\u5bc6\u6d4b\u8bd5");
        System.out.println("\t5:\tPKCS1 \u6d88\u606f\u7b7e\u540d\uff0c\u9a8c\u7b7e\u6d4b\u8bd5");
        System.out.println("\t6:\tPKCS7 \u6d88\u606f\u7b7e\u540d\uff0c\u9a8c\u7b7e\u6d4b\u8bd5");
        System.out.println("\t7:\tPKCS7 \u5206\u79bb\u5f0f\u6d88\u606f\u7b7e\u540d\uff0c\u9a8c\u7b7e\u6d4b\u8bd5");
        System.out.println("\t8:\tPKCS7 \u591a\u4eba\u6d88\u606f\u7b7e\u540d\uff0c\u9a8c\u7b7e\u6d4b\u8bd5");
        System.out.println("\t9:\tPKCS7 \u591a\u4eba\u5206\u79bb\u5f0f\u6d88\u606f\u7b7e\u540d\uff0c\u9a8c\u7b7e\u6d4b\u8bd5");
        System.out.println("\t10:\tPKCS7 \u5206\u79bb\u5f0f\u6587\u4ef6\u7b7e\u540d,\u9a8c\u8bc1\u6d4b\u8bd5(\u7b7e\u540d\u7ed3\u679c\u662fBase64\u7f16\u7801\u5b57\u7b26\u4e32)");
        System.out.println("\t11:\tPKCS7 \u6587\u4ef6\u7b7e\u540d\u6d4b\u8bd5");
        System.out.println("\t12:\tPKCS7 \u5206\u79bb\u5f0f\u6587\u4ef6\u7b7e\u540d\u6d4b\u8bd5(\u7b7e\u540d\u7ed3\u679c\u662f\u6587\u4ef6)");
        System.out.println("\t13:\tPKCS7 \u591a\u4eba\u975e\u5206\u79bb\u5f0f\u6587\u4ef6\u7b7e\u540d\u6d4b\u8bd5");
        System.out.println("\t14:\tPKCS7 \u591a\u4eba\u5206\u79bb\u5f0f\u6587\u4ef6\u7b7e\u540d\u6d4b\u8bd5(\u7b7e\u540d\u7ed3\u679c\u662f\u6587\u4ef6)");
        System.out.println("\t15:\tPKCS7 \u9a8c\u8bc1\u6587\u4ef6\u7b7e\u540d\u6d4b\u8bd5");
        System.out.println("\t16:\tPKCS7 \u9a8c\u8bc1\u5206\u79bb\u5f0f\u6587\u4ef6\u7b7e\u540d\u6d4b\u8bd5(\u7b7e\u540d\u7ed3\u679c\u662f\u6587\u4ef6)");
        System.out.println("\t17:\t\u6d88\u606f\u5bf9\u79f0\u52a0\u5bc6\uff0c\u89e3\u5bc6\u6d4b\u8bd5");
        System.out.println("\t18:\t\u6587\u4ef6\u5bf9\u79f0\u52a0\u5bc6\uff0c\u89e3\u5bc6\u6d4b\u8bd5");
        System.out.println("\t19:\t\u6587\u6458\u6d4b\u8bd5(\u5bf9\u6d88\u606f\u548c\u6587\u4ef6)");
        System.out.println("\t20:\t\u65f6\u95f4\u6233\u9a8c\u8bc1\u6d4b\u8bd5");
        System.out.println("\t21:\tPKCS7 \u6d88\u606f\u7b7e\u540d\uff0c\u9a8c\u7b7e\u6d4b\u8bd5(\u5e26MAC)");
        System.out.println("\t22:\tPKCS7 \u5206\u79bb\u5f0f\u6d88\u606f\u7b7e\u540d\uff0c\u9a8c\u7b7e\u6d4b\u8bd5(\u5e26MAC)");
        System.out.println("\t23:\tPKCS7 \u5206\u79bb\u5f0f\u6587\u4ef6\u7b7e\u540d,\u9a8c\u8bc1\u6d4b\u8bd5(\u5e26MAC)(\u7b7e\u540d\u7ed3\u679c\u662fBase64\u7f16\u7801\u5b57\u7b26\u4e32)");
        System.out.println("\t24:\tPKCS7 \u6587\u4ef6\u7b7e\u540d\u6d4b\u8bd5(\u5e26MAC)");
        System.out.println("\t25:\t\u663e\u793a\u7248\u672c\u53f7");
        System.out.println("\t26:\t\u9000\u51fa\u6d4b\u8bd5");
        System.out.println("*****************************************");
        System.out.println("\u8bf7\u8f93\u5165\u9009\u9879:");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String choose = null;
        try {
            choose = reader.readLine().trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return choose;
    }

    public static void main(String[] args) {
        try {
            APITest apiTest = new APITest();
            String choose = APITest.printMessage();
            while (true) {
                if (choose.equals("1")) {
                    apiTest.certTest();
                } else if (choose.equals("2")) {
                    apiTest.envelopMsgTest();
                } else if (choose.equals("3")) {
                    apiTest.envelopFileTest();
                } else if (choose.equals("4")) {
                    apiTest.openEnvelopFileTest();
                } else if (choose.equals("5")) {
                    apiTest.p1SignMsgTest();
                } else if (choose.equals("6")) {
                    apiTest.p7SignMsgTest();
                } else if (choose.equals("7")) {
                    apiTest.p7SignMsgDetachedTest();
                } else if (choose.equals("8")) {
                    apiTest.p7ReSignMsgTest();
                } else if (choose.equals("9")) {
                    apiTest.p7ReSignMsgDetachedTest();
                } else if (choose.equals("10")) {
                    apiTest.p7SignFileDetachedOutMsgTest();
                } else if (choose.equals("11")) {
                    apiTest.p7SignFileTest();
                } else if (choose.equals("12")) {
                    apiTest.p7SignFileDetachedTest();
                } else if (choose.equals("13")) {
                    apiTest.p7ReSignFileTest();
                } else if (choose.equals("14")) {
                    apiTest.p7ReSignFileDetachedTest();
                } else if (choose.equals("15")) {
                    apiTest.p7VerifySignFileTest();
                } else if (choose.equals("16")) {
                    apiTest.p7VerifySignFileDetachedTest();
                } else if (choose.equals("17")) {
                    apiTest.encryptMsgTest();
                } else if (choose.equals("18")) {
                    apiTest.encryptFileTest();
                } else if (choose.equals("19")) {
                    apiTest.hashTest();
                } else if (choose.equals("20")) {
                    apiTest.timeStampTest();
                } else if (choose.equals("21")) {
                    apiTest.p7SignMsgWithMACTest();
                } else if (choose.equals("22")) {
                    apiTest.p7SignMsgDetachedWithMACTest();
                } else if (choose.equals("23")) {
                    apiTest.p7SignFileDetachedOutMsgWithMACTest();
                } else if (choose.equals("24")) {
                    apiTest.p7SignFileWithMACTest();
                } else if (choose.equals("25")) {
                    System.out.println(apiTest.getVersion());
                }
                if (!choose.equals("26")) {
                    System.out.println("");
                    choose = APITest.printMessage();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
        }
    }
}

