/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.api;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.api.CertUtil;
import com.cfca.util.pki.api.EncryptUtil;
import com.cfca.util.pki.api.KeyUtil;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cipher.lib.JSoftLib;
import com.cfca.util.pki.cipher.param.CBCParam;
import com.cfca.util.pki.cms.CMSEnvelopedData;
import com.cfca.util.pki.cms.CMSEnvelopedDataGenerator;
import com.cfca.util.pki.cms.CMSEnvelopedDataParser;
import com.cfca.util.pki.cms.CMSEnvelopedDataStreamGenerator;
import com.cfca.util.pki.cms.CMSProcessable;
import com.cfca.util.pki.cms.CMSProcessableByteArray;
import com.cfca.util.pki.cms.CMSTypedStream;
import com.cfca.util.pki.cms.RecipientId;
import com.cfca.util.pki.cms.RecipientInformation;
import com.cfca.util.pki.cms.RecipientInformationStore;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS7EncryptedData;
import com.cfca.util.pki.pkcs.PKCS7EnvelopedData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class EnvelopUtil {
    private List recipientCerts = new ArrayList();
    public static final String RC4 = "RC4";
    public static final String DES_ECB = "DES/ECB/PKCS7Padding";
    public static final String DES_CBC = "DES/CBC/PKCS7Padding";
    public static final String DES3_ECB = "DESede/ECB/PKCS7Padding";
    public static final String DES3_CBC = "DESede/CBC/PKCS7Padding";
    public static final String DIGEST_SHA1 = "1.3.14.3.2.26";
    public static final String DIGEST_MD5 = "1.2.840.113549.2.5";
    public boolean cmsFlag = false;

    public void addRecipient(X509Cert receiveCert) throws PKIException {
        this.recipientCerts.add(receiveCert);
    }

    public void setCMSFlag() {
        this.cmsFlag = true;
    }

    public byte[] envelopeMessage(byte[] content, String encryptType, Session session) throws PKIException {
        CBCParam cbc;
        if (!(encryptType.equals(RC4) || encryptType.equals(DES_ECB) || encryptType.equals(DES_CBC) || encryptType.equals(DES3_ECB) || encryptType.equals(DES3_CBC))) {
            throw new PKIException("850916", "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
        }
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator(session);
        if (this.recipientCerts.size() == 0) {
            throw new PKIException("850917", "\u6570\u5b57\u4fe1\u5c01\u63a5\u6536\u8005\u8bc1\u4e66\u4e3a\u7a7a");
        }
        Iterator certItera = this.recipientCerts.iterator();
        while (certItera.hasNext()) {
            X509Cert x509Cert = (X509Cert)certItera.next();
            if (this.cmsFlag) {
                JKey pubKey = x509Cert.getPublicKey();
                byte[] subKeyID = null;
                if (x509Cert.getSubjectKeyIdentifier() == null) {
                    throw new PKIException("850933", "\u8bc1\u4e66\u4e2d\u4e0d\u5305\u542b\u4e3b\u9898\u5bc6\u94a5\u6807\u8bc6\u7b26");
                }
                subKeyID = x509Cert.getSubjectKeyIdentifier().getSubKeyIdentifier();
                edGen.addKeyTransRecipient(pubKey, subKeyID);
                continue;
            }
            edGen.addKeyTransRecipient(x509Cert);
        }
        Mechanism encryptMech = null;
        if (encryptType.indexOf("CBC") > 0 && encryptType.indexOf("AES") > 0) {
            cbc = new CBCParam();
            cbc.setIv(EncryptUtil.IV_16);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else if (encryptType.indexOf("CBC") > 0) {
            cbc = new CBCParam();
            cbc.setIv(EncryptUtil.IV_8);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else {
            encryptMech = new Mechanism(encryptType);
        }
        try {
            CMSEnvelopedData ed = edGen.generate((CMSProcessable)new CMSProcessableByteArray(content), encryptMech);
            return Base64.encode((byte[])ed.getEncoded());
        }
        catch (Exception ex) {
            throw new PKIException("850932", "\u4ea7\u751f\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25", ex);
        }
    }

    public byte[] openEnvelopedMessage(byte[] envelopData, JKey privateKey, X509Cert recipientCert, Session session) throws PKIException {
        byte[] recData = null;
        try {
            if (recipientCert == null || privateKey == null) {
                throw new PKIException("850918", "\u89e3\u6790\u6587\u4ef6\u6570\u5b57\u4fe1\u5c01\uff0c\u63a5\u6536\u8005\u79c1\u94a5\u548c\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
            }
            byte[] bEnvelop = Base64.decode((byte[])envelopData);
            CMSEnvelopedData ed = new CMSEnvelopedData(bEnvelop);
            RecipientInformationStore recipients = ed.getRecipientInfos();
            String recipientIssuer = recipientCert.getIssuer();
            BigInteger recipientSN = recipientCert.getSerialNumber();
            byte[] subjectPubKeyID = recipientCert.getSubjectKeyIdentifier().getSubKeyIdentifier();
            boolean hasRecipent = false;
            Collection c = recipients.getRecipients();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                RecipientInformation recipient = (RecipientInformation)it.next();
                RecipientId recipientID = recipient.getRID();
                String issuer = recipientID.getIssuerAsString();
                BigInteger sn = recipientID.getSerialNumber();
                byte[] recipientSubjectKeyID = recipientID.getSubjectKeyIdentifier();
                if (recipientSubjectKeyID != null && Arrays.equals(recipientSubjectKeyID, subjectPubKeyID) || recipientIssuer.equals(issuer) && recipientSN.compareTo(sn) == 0) {
                    hasRecipent = true;
                }
                recData = recipient.getContent((Key)Parser.convertPrivateKey((JKey)privateKey), "BC");
            }
            if (!hasRecipent) {
                throw new PKIException("850634", "\u4f7f\u7528\u7684\u79c1\u94a5\u8bc1\u4e66\u548c\u5c01\u88c5\u6570\u5b57\u4fe1\u5c01\u7684\u516c\u94a5\u8bc1\u4e66\u4e0d\u5339\u914d");
            }
        }
        catch (Exception ex) {
            throw new PKIException("850935", "\u89e3\u6790\u6d88\u606f\u6570\u5b57\u4fe1\u5c01\u5931\u8d25 " + ex.toString(), ex);
        }
        return recData;
    }

    public byte[] envelopeMS(byte[] content, String encryptType, String digestAlg, JKey signPriKey, X509Cert recipientCert, X509Cert signerCert, Session session) throws PKIException {
        CBCParam cbc;
        if (!(encryptType.equals(RC4) || encryptType.equals(DES_ECB) || encryptType.equals(DES_CBC) || encryptType.equals(DES3_ECB) || encryptType.equals(DES3_CBC))) {
            throw new PKIException("850916", "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
        }
        if (!digestAlg.equals(DIGEST_SHA1) && !digestAlg.equals(DIGEST_MD5)) {
            throw new PKIException("850923", "\u4e0d\u652f\u6301\u7684\u6587\u6458\u7b97\u6cd5\u7c7b\u578b");
        }
        Mechanism encryptMech = null;
        if (encryptType.indexOf("CBC") > 0 && encryptType.indexOf("AES") > 0) {
            cbc = new CBCParam();
            cbc.setIv(EncryptUtil.IV_16);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else if (encryptType.indexOf("CBC") > 0) {
            cbc = new CBCParam();
            cbc.setIv(EncryptUtil.IV_8);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else {
            encryptMech = new Mechanism(encryptType);
        }
        PKCS7EnvelopedData P7SignEnvData = new PKCS7EnvelopedData(session);
        byte[] cryptoAPICMS = P7SignEnvData.generateSignAndEnvDataExtendCryptAPI(PKCS7EncryptedData.DATA, content, digestAlg, encryptMech, signPriKey, signerCert, recipientCert);
        cryptoAPICMS = P7SignEnvData.generateCryptoAPISignAndEnvContent(cryptoAPICMS);
        return Base64.encode((byte[])cryptoAPICMS);
    }

    public byte[] openEnvelopedMS(byte[] envelopData, JKey revPriKey, Session session) throws PKIException {
        if (revPriKey == null) {
            throw new PKIException("850918", "\u89e3\u6790\u6587\u4ef6\u6570\u5b57\u4fe1\u5c01\uff0c\u63a5\u6536\u8005\u79c1\u94a5\u548c\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PKCS7EnvelopedData p7EnvelopedData = new PKCS7EnvelopedData(session);
        p7EnvelopedData.loadBase64(envelopData);
        byte[] data = p7EnvelopedData.getContentExtendCryptoAPI(revPriKey);
        return data;
    }

    public void envelopeFile(String srcFilePath, String envFilePath, int bufferSize, String encryptType, Session session) throws PKIException {
        CBCParam cbc;
        CMSEnvelopedDataStreamGenerator edGen = new CMSEnvelopedDataStreamGenerator(session);
        if (this.recipientCerts.size() == 0) {
            throw new PKIException("850917", "\u6570\u5b57\u4fe1\u5c01\u63a5\u6536\u8005\u8bc1\u4e66\u4e3a\u7a7a");
        }
        if (!(encryptType.equals(RC4) || encryptType.equals(DES_ECB) || encryptType.equals(DES_CBC) || encryptType.equals(DES3_ECB) || encryptType.equals(DES3_CBC))) {
            throw new PKIException("850916", "\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7b97\u6cd5\u7c7b\u578b");
        }
        Mechanism encryptMech = null;
        if (encryptType.indexOf("CBC") > 0 && encryptType.indexOf("AES") > 0) {
            cbc = new CBCParam();
            cbc.setIv(EncryptUtil.IV_16);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else if (encryptType.indexOf("CBC") > 0) {
            cbc = new CBCParam();
            cbc.setIv(EncryptUtil.IV_8);
            encryptMech = new Mechanism(encryptType, (Object)cbc);
        } else {
            encryptMech = new Mechanism(encryptType);
        }
        Iterator certItera = this.recipientCerts.iterator();
        while (certItera.hasNext()) {
            X509Cert x509Cert = (X509Cert)certItera.next();
            if (this.cmsFlag) {
                JKey pubKey = x509Cert.getPublicKey();
                byte[] subKeyID = null;
                if (x509Cert.getSubjectKeyIdentifier() == null) {
                    throw new PKIException("850933", "\u8bc1\u4e66\u4e2d\u4e0d\u5305\u542b\u4e3b\u9898\u5bc6\u94a5\u6807\u8bc6\u7b26");
                }
                subKeyID = x509Cert.getSubjectKeyIdentifier().getSubKeyIdentifier();
                edGen.addKeyTransRecipient(pubKey, subKeyID);
                continue;
            }
            edGen.addKeyTransRecipient(x509Cert);
        }
        try {
            BufferedOutputStream bfOut;
            OutputStream out;
            FileOutputStream fos;
            if (session instanceof JSoftLib) {
                fos = new FileOutputStream(envFilePath);
                out = edGen.open((OutputStream)fos, encryptMech);
                bfOut = new BufferedOutputStream(out, bufferSize);
                FileInputStream srcFIS = new FileInputStream(srcFilePath);
                BufferedInputStream srcBufIS = new BufferedInputStream(srcFIS, bufferSize);
                int fileLen = srcFIS.available();
                int readTotalLen = 0;
                byte[] data = new byte[bufferSize];
                while (readTotalLen < fileLen) {
                    int readLen = srcBufIS.read(data);
                    if (readLen == -1) {
                        if (fileLen == readTotalLen) break;
                        throw new Exception("\u8bfb\u53d6\u539f\u6587\u6570\u636e\u9519\u8bef");
                    }
                    bfOut.write(data, 0, readLen);
                    readTotalLen += readLen;
                }
                srcBufIS.close();
                bfOut.close();
                fos.close();
            } else {
                fos = new FileOutputStream(envFilePath);
                out = edGen.open((OutputStream)fos, encryptMech);
                bfOut = new BufferedOutputStream(out, bufferSize);
                FileInputStream srcFIS = new FileInputStream(srcFilePath);
                BufferedInputStream srcBufIS = new BufferedInputStream(srcFIS, bufferSize);
                int fileLen = srcFIS.available();
                int readTotalLen = 0;
                byte[] data = new byte[bufferSize];
                while (readTotalLen < fileLen) {
                    int readLen = srcBufIS.read(data);
                    if (readLen == -1) {
                        if (fileLen == readTotalLen) break;
                        throw new Exception("\u8bfb\u53d6\u539f\u6587\u6570\u636e\u9519\u8bef");
                    }
                    bfOut.write(data, 0, readLen);
                    readTotalLen += readLen;
                }
                srcBufIS.close();
                bfOut.close();
                fos.close();
            }
        }
        catch (Exception ex) {
            throw new PKIException("850919", "\u4ea7\u751f\u6587\u4ef6\u6570\u5b57\u4fe1\u5c01\u5931\u8d25 " + ex.getMessage(), ex);
        }
    }

    public void openEnvelopedFile(String srcFilePath, String envFilePath, int bufferSize, JKey privateKey, X509Cert recipientCert, Session session) throws PKIException {
        try {
            if (recipientCert == null || privateKey == null) {
                throw new PKIException("850918", "\u89e3\u6790\u6587\u4ef6\u6570\u5b57\u4fe1\u5c01\uff0c\u63a5\u6536\u8005\u79c1\u94a5\u548c\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String recipientIssuer = recipientCert.getIssuer();
            BigInteger recipientSN = recipientCert.getSerialNumber();
            byte[] subjectPubKeyID = recipientCert.getSubjectKeyIdentifier().getSubKeyIdentifier();
            FileInputStream fis = new FileInputStream(envFilePath);
            BufferedInputStream srcBufIS = new BufferedInputStream(fis, bufferSize);
            CMSEnvelopedDataParser ep = new CMSEnvelopedDataParser((InputStream)srcBufIS);
            RecipientInformationStore recipients = ep.getRecipientInfos();
            Collection c = recipients.getRecipients();
            Iterator it = c.iterator();
            boolean hasRecipent = false;
            while (it.hasNext()) {
                RecipientInformation recipient = (RecipientInformation)it.next();
                RecipientId recipientID = recipient.getRID();
                String issuer = recipientID.getIssuerAsString();
                BigInteger sn = recipientID.getSerialNumber();
                byte[] recipientSubjectKeyID = recipientID.getSubjectKeyIdentifier();
                if ((recipientSubjectKeyID == null || !Arrays.equals(recipientSubjectKeyID, subjectPubKeyID)) && (!recipientIssuer.equals(issuer) || recipientSN.compareTo(sn) != 0)) continue;
                hasRecipent = true;
                CMSTypedStream recData = recipient.getContentStream((Key)Parser.convertPrivateKey((JKey)privateKey), "BC");
                InputStream srcIS = recData.getContentStream();
                BufferedInputStream srcBufferIS = new BufferedInputStream(srcIS, bufferSize);
                FileOutputStream srcFOS = new FileOutputStream(srcFilePath);
                BufferedOutputStream srcBufferOut = new BufferedOutputStream(srcFOS, bufferSize);
                byte[] data = new byte[bufferSize];
                int readLen = 0;
                while ((readLen = srcBufferIS.read(data, 0, data.length)) > 0) {
                    srcBufferOut.write(data, 0, readLen);
                }
                srcBufferIS.close();
                srcBufferOut.close();
                break;
            }
            ep.close();
            if (!hasRecipent) {
                throw new PKIException("850634", "\u4f7f\u7528\u7684\u79c1\u94a5\u8bc1\u4e66\u548c\u5c01\u88c5\u6570\u5b57\u4fe1\u5c01\u7684\u516c\u94a5\u8bc1\u4e66\u4e0d\u5339\u914d");
            }
        }
        catch (Exception ex) {
            throw new PKIException("850934", "\u89e3\u6790\u6587\u4ef6\u6570\u5b57\u4fe1\u5c01\u5931\u8d25 " + ex.toString(), ex);
        }
    }

    public static void main(String[] args) {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            JKey priKey = KeyUtil.getPriKey("F:\\\u89e3\u5bc6\u6587\u4ef6\\\u89e3\u5bc6\u6587\u4ef6\\server.pfx", "123456");
            X509Cert cert = CertUtil.generateCert("F:\\\u89e3\u5bc6\u6587\u4ef6\\\u89e3\u5bc6\u6587\u4ef6\\server.cer");
            EnvelopUtil envelopUtil = new EnvelopUtil();
            envelopUtil.addRecipient(cert);
            envelopUtil.openEnvelopedFile("F:\\\u89e3\u5bc6\u6587\u4ef6\\\u89e3\u5bc6\u6587\u4ef6\\900000000000015044", "F:\\\u89e3\u5bc6\u6587\u4ef6\\\u89e3\u5bc6\u6587\u4ef6\\900000000000015044.enc", 32768, priKey, cert, session);
            byte[] bEnvelop = envelopUtil.envelopeMessage("aaaaa".getBytes(), DES_CBC, session);
            byte[] bData = envelopUtil.openEnvelopedMessage(bEnvelop, priKey, cert, session);
            String aa = new String(bData);
            int a = 99;
        }
        catch (PKIException ex) {
            System.out.println("\u9519\u8bef\u7801:" + ex.getErrCode());
            System.out.println("\u9519\u8bef\u4fe1\u606f:" + ex.getErrDesc());
            Exception exception = ex.getHistory();
        }
    }
}

