/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.api;

import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.JKeyPair;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS12;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;

public class KeyUtil {
    public static final String RC4 = "RC4";
    public static final String DES = "DES";
    public static final String DES3 = "DESede";

    public static JKey getPriKey(String pfxPath, String pfxPWD) throws PKIException {
        PKCS12 p12 = new PKCS12();
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(pfxPath);
        }
        catch (FileNotFoundException ex) {
            throw new PKIException("850909", "PFX\u79c1\u94a5\u8bc1\u4e66\u4e0d\u5b58\u5728", (Exception)ex);
        }
        p12.load((InputStream)fin);
        p12.decrypt(pfxPWD.toCharArray());
        JKey prvKey = p12.getPrivateKey();
        return prvKey;
    }

    public static JKey getPriKey(byte[] pfxData, String pfxPWD) throws PKIException {
        PKCS12 p12 = new PKCS12();
        p12.load(pfxData);
        p12.decrypt(pfxPWD.toCharArray());
        JKey prvKey = p12.getPrivateKey();
        return prvKey;
    }

    public static JKeyPair genKeyPair(int keyLen, Session session) throws PKIException {
        Mechanism keyGen = new Mechanism("RSA");
        JKeyPair keyPair = session.generateKeyPair(keyGen, keyLen);
        return keyPair;
    }

    public static JKey generateKey(String keyType, Session session) throws PKIException {
        int keyLen = 64;
        if (!(keyType.equalsIgnoreCase(DES) || keyType.equalsIgnoreCase(RC4) || keyType.equalsIgnoreCase(DES3))) {
            throw new PKIException("850910", "\u4e0d\u652f\u6301\u7684\u5bc6\u94a5\u7c7b\u578b");
        }
        keyLen = keyType.equalsIgnoreCase(DES) ? 64 : (keyType.equalsIgnoreCase(RC4) ? 128 : 192);
        return session.generateKey(new Mechanism(keyType), keyLen);
    }

    public static void generateKeyFile(String keyType, String keyFile, Session session) throws PKIException {
        int keyLen = 64;
        if (!(keyType.equalsIgnoreCase(DES) || keyType.equalsIgnoreCase(RC4) || keyType.equalsIgnoreCase(DES3))) {
            throw new PKIException("850910", "\u4e0d\u652f\u6301\u7684\u5bc6\u94a5\u7c7b\u578b");
        }
        keyLen = keyType.equalsIgnoreCase(DES) ? 64 : (keyType.equalsIgnoreCase(RC4) ? 128 : 192);
        JKey key = session.generateKey(new Mechanism(keyType), keyLen);
        try {
            FileOutputStream fos = new FileOutputStream(keyFile);
            fos.write(Base64.encode((byte[])key.getKey()));
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            throw new PKIException("850925", "\u5c06\u5bf9\u79f0\u5bc6\u94a5\u5199\u5165\u6587\u4ef6\u5931\u8d25", ex);
        }
    }

    public static void main(String[] args) {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            JKey priKey = KeyUtil.getPriKey("c:/test.pfx", "11111111");
        }
        catch (PKIException ex) {
            System.out.println("\u9519\u8bef\u7801:" + ex.getErrCode());
            System.out.println("\u9519\u8bef\u4fe1\u606f:" + ex.getErrDesc());
            Exception exception = ex.getHistory();
        }
    }
}

