/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.util.pki.api;

import com.cfca.util.ini.MACAddressUtil;
import com.cfca.util.pki.PKIException;
import com.cfca.util.pki.Parser;
import com.cfca.util.pki.asn1.ASN1EncodableVector;
import com.cfca.util.pki.asn1.DEREncodable;
import com.cfca.util.pki.asn1.DEREncodableVector;
import com.cfca.util.pki.asn1.DERNull;
import com.cfca.util.pki.asn1.DERObjectIdentifier;
import com.cfca.util.pki.asn1.DEROctetString;
import com.cfca.util.pki.asn1.DERSequence;
import com.cfca.util.pki.asn1.DERSet;
import com.cfca.util.pki.asn1.cms.Attribute;
import com.cfca.util.pki.asn1.cms.AttributeTable;
import com.cfca.util.pki.asn1.cms.CMSAttributes;
import com.cfca.util.pki.asn1.cms.Time;
import com.cfca.util.pki.asn1.pkcs.PKCSObjectIdentifiers;
import com.cfca.util.pki.asn1.x509.AlgorithmIdentifier;
import com.cfca.util.pki.asn1.x509.DigestInfo;
import com.cfca.util.pki.cert.X509Cert;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.JKey;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.cms.CMSAttributeTableGenerator;
import com.cfca.util.pki.cms.CMSException;
import com.cfca.util.pki.cms.CMSSignedData;
import com.cfca.util.pki.cms.CMSSignedDataParser;
import com.cfca.util.pki.cms.CMSSignedDataStreamGenerator;
import com.cfca.util.pki.cms.CMSTypedStream;
import com.cfca.util.pki.cms.DefaultSignedAttributeTableGenerator;
import com.cfca.util.pki.cms.SignerInformation;
import com.cfca.util.pki.cms.SignerInformationStore;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS12;
import com.cfca.util.pki.pkcs.PKCS7SignedData;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class SignatureUtil {
    static final String CFCA_MAC_ID = "CFCASECLD";
    public static final String MD5_RSA = "MD5withRSAEncryption";
    public static final String SHA1_RSA = "SHA1withRSAEncryption";
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA1";
    private String signedMAC = null;
    private byte[] signedContent = null;
    private List signerCertsList = null;
    private X509Cert[] sigerX509Cert = null;
    private boolean verifyFileOpt = false;
    private boolean verifyMsgOpt = false;

    public byte[] hash(byte[] src, String hashAlg, Session session) throws PKIException {
        if (!hashAlg.equals(MD5) && !hashAlg.equals(SHA1)) {
            throw new PKIException("850923", "\u4e0d\u652f\u6301\u7684\u6587\u6458\u7b97\u6cd5\u7c7b\u578b");
        }
        byte[] hash = session.digest(new Mechanism(hashAlg), src);
        return Base64.encode((byte[])hash);
    }

    public byte[] hash(String sourceFilePath, int bufferSize, String hashAlg, Session session) throws PKIException {
        if (!hashAlg.equals(MD5) && !hashAlg.equals(SHA1)) {
            throw new PKIException("850923", "\u4e0d\u652f\u6301\u7684\u6587\u6458\u7b97\u6cd5\u7c7b\u578b");
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFilePath);
        }
        catch (FileNotFoundException ex) {
            throw new PKIException("850924", "\u5bf9\u6587\u4ef6\u505aHASH\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        byte[] hash = session.digest(new Mechanism(hashAlg), (InputStream)fis, bufferSize);
        return Base64.encode((byte[])hash);
    }

    public byte[] p1SignMessage(byte[] sourceData, String signAlg, JKey privateKey, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        byte[] signData = session.sign(new Mechanism(signAlg), privateKey, sourceData);
        return Base64.encode((byte[])signData);
    }

    public byte[] p1SignByHash(byte[] hash, String signAlg, JKey privateKey, Session session) throws PKIException {
        DERObjectIdentifier digestOID = null;
        if (signAlg.equals(MD5_RSA)) {
            digestOID = PKCSObjectIdentifiers.md5;
        } else if (signAlg.equals(SHA1_RSA)) {
            digestOID = PKCSObjectIdentifiers.sha1;
        } else {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        AlgorithmIdentifier digestAlg = new AlgorithmIdentifier(digestOID, (DEREncodable)new DERNull());
        DigestInfo digestInfo = new DigestInfo(digestAlg, Base64.decode((byte[])hash));
        byte[] bDigestInfo = Parser.writeDERObj2Bytes((DEREncodable)digestInfo);
        byte[] encryptHash = session.encrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), privateKey, bDigestInfo);
        return Base64.encode((byte[])encryptHash);
    }

    public boolean p1VerifySignMessage(byte[] sourceData, byte[] signData, String signAlg, X509Cert signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        boolean verify = session.verifySign(new Mechanism(signAlg), signerCert.getPublicKey(), sourceData, Base64.decode((byte[])signData));
        this.verifyMsgOpt = true;
        return verify;
    }

    public boolean p1VerifySignByHash(byte[] hash, byte[] signData, String signAlg, X509Cert signerCert, Session session) throws PKIException {
        DERObjectIdentifier digestOID = null;
        if (signAlg.equals(MD5_RSA)) {
            digestOID = PKCSObjectIdentifiers.md5;
        } else if (signAlg.equals(SHA1_RSA)) {
            digestOID = PKCSObjectIdentifiers.sha1;
        } else {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        AlgorithmIdentifier digestAlg = new AlgorithmIdentifier(digestOID, (DEREncodable)new DERNull());
        DigestInfo digestInfo = new DigestInfo(digestAlg, Base64.decode((byte[])hash));
        byte[] bDigestInfo = Parser.writeDERObj2Bytes((DEREncodable)digestInfo);
        byte[] decryptHash = session.decrypt(new Mechanism("RSA/ECB/PKCS1PADDING"), signerCert.getPublicKey(), Base64.decode((byte[])signData));
        this.verifyMsgOpt = true;
        return Arrays.equals(decryptHash, bDigestInfo);
    }

    public byte[] p7SignMessage(boolean encapsulated, byte[] sourceData, String signAlg, JKey privateKey, X509Cert[] signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        Mechanism mechanism = null;
        mechanism = signAlg.equals(MD5_RSA) ? new Mechanism(MD5) : new Mechanism(SHA1);
        byte[] signData = null;
        signData = p7.generateSignedData(encapsulated, PKCS7SignedData.DATA, sourceData, mechanism, privateKey, signerCert, null);
        signData = p7.generateSignedDataContent(signData);
        return Base64.encode((byte[])signData);
    }

    public byte[] p7SignMessageWithMAC(boolean encapsulated, byte[] sourceData, String signAlg, JKey privateKey, X509Cert[] signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        Mechanism mechanism = null;
        mechanism = signAlg.equals(MD5_RSA) ? new Mechanism(MD5) : new Mechanism(SHA1);
        byte[] signData = null;
        signData = p7.generateSignedDataWithMAC(encapsulated, PKCS7SignedData.DATA, sourceData, mechanism, privateKey, signerCert, null);
        signData = p7.generateSignedDataContent(signData);
        return Base64.encode((byte[])signData);
    }

    public byte[] p7SignByHash(byte[] hash, String signAlg, JKey privateKey, X509Cert[] signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        Mechanism mechanism = null;
        mechanism = signAlg.equals(MD5_RSA) ? new Mechanism(MD5) : new Mechanism(SHA1);
        byte[] signData = null;
        signData = p7.generateSignedDataByHash(PKCS7SignedData.DATA, Base64.decode((byte[])hash), mechanism, privateKey, signerCert, null);
        signData = p7.generateSignedDataContent(signData);
        return Base64.encode((byte[])signData);
    }

    public byte[] p7ReSignMessage(byte[] signedData, String signAlg, JKey privateKey, X509Cert[] signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(signedData);
        Mechanism mechanism = null;
        mechanism = signAlg.equals(MD5_RSA) ? new Mechanism(MD5) : new Mechanism(SHA1);
        byte[] signData = null;
        signData = p7.reSignSignedData(mechanism, privateKey, signerCert, null);
        signData = p7.generateSignedDataContent(signData);
        return Base64.encode((byte[])signData);
    }

    public byte[] p7ReSignMessageDetached(byte[] srcData, byte[] signedData, String signAlg, JKey privateKey, X509Cert[] signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(signedData);
        Mechanism mechanism = null;
        mechanism = signAlg.equals(MD5_RSA) ? new Mechanism(MD5) : new Mechanism(SHA1);
        byte[] signData = null;
        signData = p7.reSignSignedData(srcData, mechanism, privateKey, signerCert, null);
        signData = p7.generateSignedDataContent(signData);
        return Base64.encode((byte[])signData);
    }

    public byte[] p7ReSignByHash(byte[] hash, byte[] signedData, String signAlg, JKey privateKey, X509Cert[] signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(signedData);
        Mechanism mechanism = null;
        mechanism = signAlg.equals(MD5_RSA) ? new Mechanism(MD5) : new Mechanism(SHA1);
        byte[] signData = null;
        signData = p7.reSignSignedDataByHash(Base64.decode((byte[])hash), mechanism, privateKey, signerCert, null);
        signData = p7.generateSignedDataContent(signData);
        return Base64.encode((byte[])signData);
    }

    public boolean p7VerifySignMessageDetached(byte[] sourceData, byte[] signData, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(signData);
        boolean verifyed = p7.verifyP7SignedData(sourceData);
        this.signedMAC = p7.getSignedMAC();
        this.verifyMsgOpt = true;
        this.sigerX509Cert = p7.getSignerCerts();
        return verifyed;
    }

    public boolean p7VerifySignByHash(byte[] hash, byte[] signData, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(signData);
        boolean verifyed = p7.verifyP7SignedDataByHash(Base64.decode((byte[])hash));
        this.verifyMsgOpt = true;
        this.sigerX509Cert = p7.getSignerCerts();
        return verifyed;
    }

    public boolean p7VerifySignMessage(byte[] signData, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(signData);
        boolean verifyed = p7.verifyP7SignedData();
        this.signedMAC = p7.getSignedMAC();
        this.verifyMsgOpt = true;
        this.signedContent = p7.getContent();
        this.sigerX509Cert = p7.getSignerCerts();
        return verifyed;
    }

    public byte[] getSignedContent() throws PKIException {
        if (!this.verifyMsgOpt) {
            throw new PKIException("850913", "\u6ca1\u6709\u6267\u884c\u9a8c\u7b7e\u540d\u64cd\u4f5c");
        }
        return this.signedContent;
    }

    public X509Cert[] getSigerCert() throws PKIException {
        if (this.verifyMsgOpt) {
            return this.sigerX509Cert;
        }
        if (this.verifyFileOpt) {
            int size = this.signerCertsList.size();
            if (size == 0) {
                return null;
            }
            this.sigerX509Cert = new X509Cert[size];
            int i = 0;
            while (i < size) {
                try {
                    this.sigerX509Cert[i] = new X509Cert(((X509Certificate)this.signerCertsList.get(i)).getEncoded());
                }
                catch (CertificateEncodingException ex) {
                    throw new PKIException("850915", "\u83b7\u5f97\u7b7e\u540d\u8005\u8bc1\u4e66\u7684X509Certificate\u7f16\u7801\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
                }
                ++i;
            }
            return this.sigerX509Cert;
        }
        throw new PKIException("850913", "\u6ca1\u6709\u6267\u884c\u9a8c\u7b7e\u540d\u64cd\u4f5c");
    }

    public void p7SignFile(boolean encapsulated, String srcFilePath, String signFilePath, int bufferSize, String signAlg, JKey privateKey, X509Cert signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator(session);
        String digestOID = PKCSObjectIdentifiers.sha1.getId();
        digestOID = signAlg.equals(MD5_RSA) ? PKCSObjectIdentifiers.md5.getId() : PKCSObjectIdentifiers.sha1.getId();
        try {
            gen.addSigner(privateKey, signerCert, digestOID);
        }
        catch (InvalidKeyException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (NoSuchProviderException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (NoSuchAlgorithmException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(Parser.convertX509Cert((X509Cert)signerCert));
        CertStore certs = null;
        try {
            certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        }
        catch (NoSuchProviderException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        try {
            gen.addCertificatesAndCRLs(certs);
        }
        catch (CMSException ex1) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)((Object)ex1));
        }
        catch (CertStoreException ex1) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)ex1);
        }
        File file = new File(signFilePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        try {
            OutputStream sigOut = gen.open((OutputStream)fos, encapsulated);
            BufferedOutputStream bfOut = new BufferedOutputStream(sigOut, bufferSize);
            FileInputStream srcFIS = new FileInputStream(srcFilePath);
            BufferedInputStream srcBufIS = new BufferedInputStream(srcFIS, bufferSize);
            int fileLen = srcFIS.available();
            int readTotalLen = 0;
            byte[] data = new byte[bufferSize];
            while (readTotalLen < fileLen) {
                int readLen = srcBufIS.read(data);
                if (readLen == -1) {
                    if (fileLen == readTotalLen) break;
                    throw new Exception("\u8bfb\u53d6\u539f\u6587\u6570\u636e\u9519\u8bef");
                }
                bfOut.write(data, 0, readLen);
                readTotalLen += readLen;
            }
            srcBufIS.close();
            bfOut.close();
            fos.close();
        }
        catch (Exception ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), ex);
        }
    }

    public void p7SignFileWithMAC(boolean encapsulated, String srcFilePath, String signFilePath, int bufferSize, String signAlg, JKey privateKey, X509Cert signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator(session);
        String digestOID = PKCSObjectIdentifiers.sha1.getId();
        digestOID = signAlg.equals(MD5_RSA) ? PKCSObjectIdentifiers.md5.getId() : PKCSObjectIdentifiers.sha1.getId();
        try {
            DERObjectIdentifier authMACAddressID = PKCSObjectIdentifiers.id_ct_MACAddress;
            String strAuthMACAddress = CFCA_MAC_ID + MACAddressUtil.getMacAddress();
            DEROctetString derOctetMACAddress = new DEROctetString(strAuthMACAddress.getBytes());
            DERSet authOctetMACAddress = new DERSet((DEREncodable)derOctetMACAddress);
            ASN1EncodableVector authMacAddressVect = new ASN1EncodableVector();
            authMacAddressVect.add((DEREncodable)authMACAddressID);
            authMacAddressVect.add((DEREncodable)authOctetMACAddress);
            DERSequence authMacAddressSeq = new DERSequence((DEREncodableVector)authMacAddressVect);
            ASN1EncodableVector authMacAddVecFinal = new ASN1EncodableVector();
            authMacAddVecFinal.add((DEREncodable)authMacAddressSeq);
            AttributeTable attTable = new AttributeTable((DEREncodableVector)authMacAddVecFinal);
            DefaultSignedAttributeTableGenerator signedAttrGenerator = new DefaultSignedAttributeTableGenerator(attTable);
            gen.addSigner(privateKey, signerCert, digestOID, (CMSAttributeTableGenerator)signedAttrGenerator, null);
        }
        catch (InvalidKeyException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (NoSuchProviderException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (NoSuchAlgorithmException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (IOException e) {
            throw new PKIException("850614", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", (Exception)e);
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(Parser.convertX509Cert((X509Cert)signerCert));
        CertStore certs = null;
        try {
            certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        }
        catch (NoSuchProviderException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        try {
            gen.addCertificatesAndCRLs(certs);
        }
        catch (CMSException ex1) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)((Object)ex1));
        }
        catch (CertStoreException ex1) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)ex1);
        }
        File file = new File(signFilePath);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        try {
            OutputStream sigOut = gen.open((OutputStream)fos, encapsulated);
            BufferedOutputStream bfOut = new BufferedOutputStream(sigOut, bufferSize);
            FileInputStream srcFIS = new FileInputStream(srcFilePath);
            BufferedInputStream srcBufIS = new BufferedInputStream(srcFIS, bufferSize);
            int fileLen = srcFIS.available();
            int readTotalLen = 0;
            byte[] data = new byte[bufferSize];
            while (readTotalLen < fileLen) {
                int readLen = srcBufIS.read(data);
                if (readLen == -1) {
                    if (fileLen == readTotalLen) break;
                    throw new Exception("\u8bfb\u53d6\u539f\u6587\u6570\u636e\u9519\u8bef");
                }
                bfOut.write(data, 0, readLen);
                readTotalLen += readLen;
            }
            srcBufIS.close();
            bfOut.close();
            fos.close();
        }
        catch (Exception ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), ex);
        }
    }

    public byte[] p7SignFileDetachedOutMsg(String srcFilePath, int bufferSize, String signAlg, JKey privateKey, X509Cert signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator(session);
        String digestOID = PKCSObjectIdentifiers.sha1.getId();
        digestOID = signAlg.equals(MD5_RSA) ? PKCSObjectIdentifiers.md5.getId() : PKCSObjectIdentifiers.sha1.getId();
        try {
            gen.addSigner(privateKey, signerCert, digestOID);
        }
        catch (InvalidKeyException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (NoSuchProviderException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (NoSuchAlgorithmException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(Parser.convertX509Cert((X509Cert)signerCert));
        CertStore certs = null;
        try {
            certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        }
        catch (NoSuchProviderException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        try {
            gen.addCertificatesAndCRLs(certs);
        }
        catch (CMSException ex1) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)((Object)ex1));
        }
        catch (CertStoreException ex1) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)ex1);
        }
        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        try {
            OutputStream sigOut = gen.open((OutputStream)byteArrayOS, false);
            BufferedOutputStream bfOut = new BufferedOutputStream(sigOut, bufferSize);
            FileInputStream srcFIS = new FileInputStream(srcFilePath);
            BufferedInputStream srcBufIS = new BufferedInputStream(srcFIS, bufferSize);
            int fileLen = srcFIS.available();
            int readTotalLen = 0;
            byte[] data = new byte[bufferSize];
            while (readTotalLen < fileLen) {
                int readLen = srcBufIS.read(data);
                if (readLen == -1) {
                    if (fileLen == readTotalLen) break;
                    throw new Exception("\u8bfb\u53d6\u539f\u6587\u6570\u636e\u9519\u8bef");
                }
                bfOut.write(data, 0, readLen);
                readTotalLen += readLen;
            }
            srcBufIS.close();
            bfOut.close();
            byteArrayOS.close();
            return Base64.encode((byte[])byteArrayOS.toByteArray());
        }
        catch (Exception ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), ex);
        }
    }

    public byte[] p7SignFileDetachedOutMsgWithMAC(String srcFilePath, int bufferSize, String signAlg, JKey privateKey, X509Cert signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator(session);
        String digestOID = PKCSObjectIdentifiers.sha1.getId();
        digestOID = signAlg.equals(MD5_RSA) ? PKCSObjectIdentifiers.md5.getId() : PKCSObjectIdentifiers.sha1.getId();
        try {
            DERObjectIdentifier authMACAddressID = PKCSObjectIdentifiers.id_ct_MACAddress;
            String strAuthMACAddress = CFCA_MAC_ID + MACAddressUtil.getMacAddress();
            DEROctetString derOctetMACAddress = new DEROctetString(strAuthMACAddress.getBytes());
            DERSet authOctetMACAddress = new DERSet((DEREncodable)derOctetMACAddress);
            ASN1EncodableVector authMacAddressVect = new ASN1EncodableVector();
            authMacAddressVect.add((DEREncodable)authMACAddressID);
            authMacAddressVect.add((DEREncodable)authOctetMACAddress);
            DERSequence authMacAddressSeq = new DERSequence((DEREncodableVector)authMacAddressVect);
            ASN1EncodableVector authMacAddVecFinal = new ASN1EncodableVector();
            authMacAddVecFinal.add((DEREncodable)authMacAddressSeq);
            AttributeTable attTable = new AttributeTable((DEREncodableVector)authMacAddVecFinal);
            DefaultSignedAttributeTableGenerator signedAttrGenerator = new DefaultSignedAttributeTableGenerator(attTable);
            gen.addSigner(privateKey, signerCert, digestOID, (CMSAttributeTableGenerator)signedAttrGenerator, null);
        }
        catch (InvalidKeyException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (NoSuchProviderException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (NoSuchAlgorithmException ex2) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), (Exception)ex2);
        }
        catch (IOException e) {
            throw new PKIException("850614", "\u4ea7\u751f\u7b7e\u540d\u6570\u636e\u5305\u5931\u8d25", (Exception)e);
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(Parser.convertX509Cert((X509Cert)signerCert));
        CertStore certs = null;
        try {
            certs = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
        }
        catch (NoSuchProviderException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        try {
            gen.addCertificatesAndCRLs(certs);
        }
        catch (CMSException ex1) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)((Object)ex1));
        }
        catch (CertStoreException ex1) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)ex1);
        }
        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        try {
            OutputStream sigOut = gen.open((OutputStream)byteArrayOS, false);
            BufferedOutputStream bfOut = new BufferedOutputStream(sigOut, bufferSize);
            FileInputStream srcFIS = new FileInputStream(srcFilePath);
            BufferedInputStream srcBufIS = new BufferedInputStream(srcFIS, bufferSize);
            int fileLen = srcFIS.available();
            int readTotalLen = 0;
            byte[] data = new byte[bufferSize];
            while (readTotalLen < fileLen) {
                int readLen = srcBufIS.read(data);
                if (readLen == -1) {
                    if (fileLen == readTotalLen) break;
                    throw new Exception("\u8bfb\u53d6\u539f\u6587\u6570\u636e\u9519\u8bef");
                }
                bfOut.write(data, 0, readLen);
                readTotalLen += readLen;
            }
            srcBufIS.close();
            bfOut.close();
            byteArrayOS.close();
            return Base64.encode((byte[])byteArrayOS.toByteArray());
        }
        catch (Exception ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), ex);
        }
    }

    public void p7ReSignFileDetached(String srcFilePath, String origiSignFilePath, String reSignFilePath, int bufferSize, String signAlg, JKey privateKey, X509Cert signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        try {
            FileInputStream signData = new FileInputStream(origiSignFilePath);
            BufferedInputStream bis = new BufferedInputStream(signData, bufferSize);
            CMSSignedData originalSignedData = new CMSSignedData((InputStream)bis);
            CertStore originalCertCrlStore = originalSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore originalSignerInfo = originalSignedData.getSignerInfos();
            Collection<? extends Certificate> certStore = originalCertCrlStore.getCertificates(null);
            String digestOID = PKCSObjectIdentifiers.sha1.getId();
            digestOID = signAlg.equals(MD5_RSA) ? PKCSObjectIdentifiers.md5.getId() : PKCSObjectIdentifiers.sha1.getId();
            FileOutputStream fos2 = new FileOutputStream(reSignFilePath);
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator(session);
            gen.addSigner(privateKey, signerCert, digestOID);
            gen.addSigners(originalSignerInfo);
            ArrayList<? extends Certificate> certList = new ArrayList<Certificate>();
            certList.add(Parser.convertX509Cert((X509Cert)signerCert));
            certList.addAll(certStore);
            CertStore newCerts = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
            gen.addCertificatesAndCRLs(newCerts);
            OutputStream sigOut = gen.open((OutputStream)fos2);
            BufferedOutputStream bfOut2 = new BufferedOutputStream(sigOut, bufferSize);
            FileInputStream srcFIS2 = new FileInputStream(srcFilePath);
            BufferedInputStream srcBufIS2 = new BufferedInputStream(srcFIS2, bufferSize);
            int fileLen2 = srcFIS2.available();
            int readTotalLen2 = 0;
            byte[] data2 = new byte[bufferSize];
            while (readTotalLen2 < fileLen2) {
                int readLen2 = srcBufIS2.read(data2);
                if (readLen2 == -1) {
                    if (fileLen2 == readTotalLen2) break;
                    throw new Exception("\u8bfb\u53d6\u6570\u636e\u9519\u8bef");
                }
                bfOut2.write(data2, 0, readLen2);
                readTotalLen2 += readLen2;
            }
            srcBufIS2.close();
            bfOut2.close();
            bis.close();
            fos2.close();
        }
        catch (Exception ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), ex);
        }
    }

    public byte[] p7ReSignFileDetachedOutMsg(String srcFilePath, byte[] origiSignData, int bufferSize, String signAlg, JKey privateKey, X509Cert signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        try {
            ByteArrayInputStream byteArrayIS = new ByteArrayInputStream(Base64.decode((byte[])origiSignData));
            BufferedInputStream bis = new BufferedInputStream(byteArrayIS, bufferSize);
            CMSSignedData originalSignedData = new CMSSignedData((InputStream)bis);
            CertStore originalCertCrlStore = originalSignedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore originalSignerInfo = originalSignedData.getSignerInfos();
            Collection<? extends Certificate> certStore = originalCertCrlStore.getCertificates(null);
            String digestOID = PKCSObjectIdentifiers.sha1.getId();
            digestOID = signAlg.equals(MD5_RSA) ? PKCSObjectIdentifiers.md5.getId() : PKCSObjectIdentifiers.sha1.getId();
            ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator(session);
            gen.addSigner(privateKey, signerCert, digestOID);
            gen.addSigners(originalSignerInfo);
            ArrayList<? extends Certificate> certList = new ArrayList<Certificate>();
            certList.add(Parser.convertX509Cert((X509Cert)signerCert));
            certList.addAll(certStore);
            CertStore newCerts = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
            gen.addCertificatesAndCRLs(newCerts);
            OutputStream sigOut = gen.open((OutputStream)byteArrayOS);
            BufferedOutputStream bfOut2 = new BufferedOutputStream(sigOut, bufferSize);
            FileInputStream srcFIS2 = new FileInputStream(srcFilePath);
            BufferedInputStream srcBufIS2 = new BufferedInputStream(srcFIS2, bufferSize);
            int fileLen2 = srcFIS2.available();
            int readTotalLen2 = 0;
            byte[] data2 = new byte[bufferSize];
            while (readTotalLen2 < fileLen2) {
                int readLen2 = srcBufIS2.read(data2);
                if (readLen2 == -1) {
                    if (fileLen2 == readTotalLen2) break;
                    throw new Exception("\u8bfb\u53d6\u6570\u636e\u9519\u8bef");
                }
                bfOut2.write(data2, 0, readLen2);
                readTotalLen2 += readLen2;
            }
            srcBufIS2.close();
            bfOut2.close();
            bis.close();
            byteArrayOS.close();
            return Base64.encode((byte[])byteArrayOS.toByteArray());
        }
        catch (Exception ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), ex);
        }
    }

    public boolean p7VerifySignFileDetached(String srcFilePath, String signFilePath, int bufferSize, Session session) throws PKIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(signFilePath);
        }
        catch (FileNotFoundException ex) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        BufferedInputStream bis = new BufferedInputStream(fis, bufferSize);
        FileInputStream srcFis = null;
        try {
            srcFis = new FileInputStream(srcFilePath);
        }
        catch (FileNotFoundException ex1) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)ex1);
        }
        CMSTypedStream cmsTypeStream = new CMSTypedStream(PKCSObjectIdentifiers.data.getId(), (InputStream)srcFis, bufferSize);
        CMSSignedDataParser sp = null;
        boolean verify = false;
        try {
            sp = new CMSSignedDataParser(cmsTypeStream, (InputStream)bis);
            sp.getSignedContent().drain();
            CertStore certStore = sp.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Collection<? extends Certificate> certCollection;
                Iterator<? extends Certificate> certIt;
                X509Certificate cert;
                SignerInformation signer = (SignerInformation)it.next();
                verify = signer.verify(cert = (X509Certificate)(certIt = (certCollection = certStore.getCertificates((CertSelector)signer.getSID())).iterator()).next(), "BC");
                if (!verify) break;
                this.signedMAC = signer.getSignedMAC();
            }
            Collection<? extends Certificate> certColl = certStore.getCertificates(null);
            Iterator<? extends Certificate> certIntera = certColl.iterator();
            this.signerCertsList = new ArrayList();
            while (certIntera.hasNext()) {
                this.signerCertsList.add(certIntera.next());
            }
            sp.close();
            this.verifyFileOpt = true;
            return verify;
        }
        catch (Exception ex2) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), ex2);
        }
    }

    public boolean p7VerifySignFileDetachedOutMsg(String srcFilePath, byte[] signData, int bufferSize, Session session) throws PKIException {
        ByteArrayInputStream byteArrayIS = new ByteArrayInputStream(Base64.decode((byte[])signData));
        BufferedInputStream bis = new BufferedInputStream(byteArrayIS, bufferSize);
        FileInputStream srcFis = null;
        try {
            srcFis = new FileInputStream(srcFilePath);
        }
        catch (FileNotFoundException ex1) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex1.getMessage(), (Exception)ex1);
        }
        CMSTypedStream cmsTypeStream = new CMSTypedStream(PKCSObjectIdentifiers.data.getId(), (InputStream)srcFis, bufferSize);
        CMSSignedDataParser sp = null;
        boolean verify = false;
        try {
            sp = new CMSSignedDataParser(cmsTypeStream, (InputStream)bis);
            sp.getSignedContent().drain();
            CertStore certStore = sp.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Collection<? extends Certificate> certCollection;
                Iterator<? extends Certificate> certIt;
                X509Certificate cert;
                SignerInformation signer = (SignerInformation)it.next();
                verify = signer.verify(cert = (X509Certificate)(certIt = (certCollection = certStore.getCertificates((CertSelector)signer.getSID())).iterator()).next(), "BC");
                if (!verify) break;
                this.signedMAC = signer.getSignedMAC();
            }
            Collection<? extends Certificate> certColl = certStore.getCertificates(null);
            Iterator<? extends Certificate> certIntera = certColl.iterator();
            this.signerCertsList = new ArrayList();
            while (certIntera.hasNext()) {
                this.signerCertsList.add(certIntera.next());
            }
            sp.close();
            this.verifyFileOpt = true;
            return verify;
        }
        catch (Exception ex2) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), ex2);
        }
    }

    public boolean p7VerifySignFile(String srcFilePath, String signFilePath, int bufferSize, Session session) throws PKIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(signFilePath);
        }
        catch (FileNotFoundException ex) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), (Exception)ex);
        }
        BufferedInputStream bis = new BufferedInputStream(fis, bufferSize);
        CMSSignedDataParser sp = null;
        boolean verify = false;
        try {
            sp = new CMSSignedDataParser((InputStream)bis);
            sp.getSignedContent().drain(srcFilePath);
            CertStore certStore = sp.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Collection<? extends Certificate> certCollection;
                Iterator<? extends Certificate> certIt;
                X509Certificate cert;
                SignerInformation signer = (SignerInformation)it.next();
                verify = signer.verify(cert = (X509Certificate)(certIt = (certCollection = certStore.getCertificates((CertSelector)signer.getSID())).iterator()).next(), "BC");
                if (!verify) break;
                this.signedMAC = signer.getSignedMAC();
            }
            Collection<? extends Certificate> certColl = certStore.getCertificates(null);
            Iterator<? extends Certificate> certIntera = certColl.iterator();
            this.signerCertsList = new ArrayList();
            while (certIntera.hasNext()) {
                this.signerCertsList.add(certIntera.next());
            }
            sp.close();
            this.verifyFileOpt = true;
            return verify;
        }
        catch (Exception ex2) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), ex2);
        }
    }

    public void p7ReSignFile(String origiSignFilePath, String reSignFilePath, int bufferSize, String signAlg, JKey privateKey, X509Cert signerCert, Session session) throws PKIException {
        if (!signAlg.equals(MD5_RSA) && !signAlg.equals(SHA1_RSA)) {
            throw new PKIException("850911", "\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
        }
        try {
            FileInputStream signData = new FileInputStream(origiSignFilePath);
            BufferedInputStream bis = new BufferedInputStream(signData, bufferSize);
            CMSSignedDataParser sp = new CMSSignedDataParser((InputStream)bis);
            ByteArrayOutputStream bufferOS = new ByteArrayOutputStream();
            sp.getSignedContent().drain((OutputStream)bufferOS);
            CertStore originalCertCrlStore = sp.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore originalSignerInfo = sp.getSignerInfos();
            Collection<? extends Certificate> certStore = originalCertCrlStore.getCertificates(null);
            String digestOID = PKCSObjectIdentifiers.sha1.getId();
            digestOID = signAlg.equals(MD5_RSA) ? PKCSObjectIdentifiers.md5.getId() : PKCSObjectIdentifiers.sha1.getId();
            FileOutputStream fos2 = new FileOutputStream(reSignFilePath);
            CMSSignedDataStreamGenerator gen = new CMSSignedDataStreamGenerator(session);
            gen.addSigner(privateKey, signerCert, digestOID);
            gen.addSigners(originalSignerInfo);
            ArrayList<? extends Certificate> certList = new ArrayList<Certificate>();
            certList.add(Parser.convertX509Cert((X509Cert)signerCert));
            certList.addAll(certStore);
            CertStore newCerts = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
            gen.addCertificatesAndCRLs(newCerts);
            OutputStream sigOut = gen.open((OutputStream)fos2, true);
            BufferedOutputStream bfOut2 = new BufferedOutputStream(sigOut, bufferSize);
            bufferOS.writeTo(bfOut2);
            bfOut2.close();
            bufferOS.close();
            sp.close();
            fos2.close();
        }
        catch (Exception ex) {
            throw new PKIException("850912", "\u4ea7\u751f\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex.getMessage(), ex);
        }
    }

    public boolean verifyTimeStamp(byte[] bTimeStamp, Session session) throws PKIException {
        CMSSignedDataParser sp = null;
        byte[] base64TimeStamp = Parser.convertBase64((byte[])bTimeStamp);
        boolean verify = false;
        try {
            sp = new CMSSignedDataParser((InputStream)new ByteArrayInputStream(Base64.decode((byte[])base64TimeStamp)));
            sp.getSignedContent().drain();
            CertStore certStore = sp.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Collection<? extends Certificate> certCollection;
                Iterator<? extends Certificate> certIt;
                X509Certificate cert;
                SignerInformation signer = (SignerInformation)it.next();
                verify = signer.verify(cert = (X509Certificate)(certIt = (certCollection = certStore.getCertificates((CertSelector)signer.getSID())).iterator()).next(), "BC");
                if (!verify) break;
            }
            Collection<? extends Certificate> certColl = certStore.getCertificates(null);
            Iterator<? extends Certificate> certIntera = certColl.iterator();
            this.signerCertsList = new ArrayList();
            while (certIntera.hasNext()) {
                this.signerCertsList.add(certIntera.next());
            }
            sp.close();
            this.verifyFileOpt = true;
            return verify;
        }
        catch (Exception ex2) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), ex2);
        }
    }

    public String getTimeFromTimeStamp(byte[] bTimeStamp) throws PKIException {
        CMSSignedDataParser sp = null;
        try {
            byte[] base64TimeStamp = Parser.convertBase64((byte[])bTimeStamp);
            sp = new CMSSignedDataParser((InputStream)new ByteArrayInputStream(Base64.decode((byte[])base64TimeStamp)));
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            String strSignDate = null;
            while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                AttributeTable attributeTable = signer.getSignedAttributes();
                Attribute signTimeAttri = attributeTable.get(CMSAttributes.signingTime);
                Time time = Time.getInstance((Object)signTimeAttri.getAttrValues().getObjectAt(0).getDERObject());
                Date signTimeDate = time.getDate();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                strSignDate = format.format(signTimeDate);
            }
            sp.close();
            return strSignDate;
        }
        catch (Exception ex2) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), ex2);
        }
    }

    public static void main(String[] args) {
        try {
            JCrypto jcrypto = JCrypto.getInstance();
            jcrypto.initialize("JSOFT_LIB", null);
            Session session = jcrypto.openSession("JSOFT_LIB");
            SignatureUtil signUtil = new SignatureUtil();
            String sourceData = "rape you";
            PKCS12 p12 = new PKCS12();
            p12.load("C:\\Documents and Settings\\Administrator\\\u684c\u9762\\\u5e38\u7528\u8bc1\u4e66\\ra3.pfx");
            p12.decrypt("111111".toCharArray());
            JKey priKey = p12.getPrivateKey();
            X509Cert[] x509Cert = new X509Cert[]{p12.getCertificate()};
            signUtil.p7SignFileWithMAC(true, "c:\\a.text", "c:\\as.text", 512, SHA1_RSA, priKey, x509Cert[0], session);
            byte[] p7sigFile = signUtil.p7SignFileDetachedOutMsgWithMAC("c:\\b.text", 512, SHA1_RSA, priKey, x509Cert[0], session);
            boolean verib = signUtil.p7VerifySignFile("c:\\a.text", "c:\\as.text", 512, session);
            String strMAC1 = signUtil.getSignedMAC();
            boolean veric = signUtil.p7VerifySignFileDetachedOutMsg("c:\\b.text", p7sigFile, 512, session);
            String strMAC2 = signUtil.getSignedMAC();
            boolean veribb = signUtil.p7VerifySignFileDetached("c:\\p7file.txt", "c:\\p7file.txt.p7s", 512, session);
            String strMAC3 = signUtil.getSignedMAC();
            byte[] bMsgSigned1 = signUtil.p7SignMessageWithMAC(false, sourceData.getBytes(), SHA1_RSA, priKey, x509Cert, session);
            byte[] bMsgSigned2 = signUtil.p7SignMessageWithMAC(true, sourceData.getBytes(), SHA1_RSA, priKey, x509Cert, session);
            String signData = "MIIFPAYJKoZIhvcNAQcCoIIFLTCCBSkCAQExCzAJBgUrDgMCGgUAMB0GCSqGSIb3DQEHAaAQBA5mdWNrIHlvdSBhZ2FpbqCCA6swggOnMIIDEKADAgECAhAZKG85fczfRxhoo32fnvwOMA0GCSqGSIb3DQEBBQUAMCQxCzAJBgNVBAYTAkNOMRUwEwYDVQQKEwxDRkNBIFRFU1QgQ0EwHhcNMDgxMjI1MDEyMjQyWhcNMDkxMjI1MDEyMjQyWjB4MQswCQYDVQQGEwJDTjEVMBMGA1UEChMMQ0ZDQSBURVNUIENBMREwDwYDVQQLEwhMb2NhbCBSQTEUMBIGA1UECxMLRW50ZXJwcmlzZXMxKTAnBgNVBAMUIDA0MUA4MjAwODEyMjUwMDAxQHl1emhpQDAwMDAwMDAxMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDT2iRKAX0kIsygIjn0FpVtVy2N64NIW9Z1LxYjQcvQsmPkhyUJnFN2/Vf86EjiNFYTVn0/Zxfi9NF6hbceKprGtlpUd6wzcNKRR8Ta68kLQ7ng/7mz53xLCu0NXRqLa9PY9VmdwEuJdDRw5kKwKLciso4ndKRmqMDDydpXc+m9OwIDAQABo4IBhDCCAYAwHwYDVR0jBBgwFoAURnLcJXKfAk5Vg7WA+Qvb6ZOz9EUwHQYDVR0OBBYEFBBxZjL3sL2a6L9Tpc8UkWOsSbzJMAsGA1UdDwQEAwIFoDAMBgNVHRMEBTADAQEAMDsGA1UdJQQ0MDIGCCsGAQUFBwMBBggrBgEFBQcDAgYIKwYBBQUHAwMGCCsGAQUFBwMEBggrBgEFBQcDCDCB5QYDVR0fBIHdMIHaME6gTKBKpEgwRjELMAkGA1UEBhMCQ04xFTATBgNVBAoTDENGQ0EgVEVTVCBDQTEMMAoGA1UECxMDQ1JMMRIwEAYDVQQDEwljcmwxMjdfMjgwgYeggYSggYGGf2xkYXA6Ly8yMTAuNzQuNDEuODc6Mzg5L0NOPWNybDEyN18yOCxPVT1DUkwsTz1DRkNBIFRFU1QgQ0EsQz1DTj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0P2Jhc2U/b2JqZWN0Y2xhc3M9Y1JMRGlzdHJpYnV0aW9uUG9pbnQwDQYJKoZIhvcNAQEFBQADgYEAVViByVc/b97lgrhYF+6iXJrqqbdu5THLcdkTHVm+rmGB9u+dzkjcFQUm7NS/fxwoQfYuOsVB29VDve4z6ODEtF4o8q8FB0lfih40/KLudgquHVepweg4cfzKgyqkfG04yNkibElxx0SpBNpGazHGhbLb5J1xaJtJ4X5X/ETj130xggFHMIIBQwIBATA4MCQxCzAJBgNVBAYTAkNOMRUwEwYDVQQKEwxDRkNBIFRFU1QgQ0ECEBkobzl9zN9HGGijfZ+e/A4wCQYFKw4DAhoFAKBnMBgGCSqGSIb3DQEJAzELBgkqhkiG9w0BBwEwIwYJKoZIhvcNAQkEMRYEFNyJT17OYKdlbaFnyoNj5Vb74T4RMCYGCyqGSIb3DQEJEAECMRcEFUNGQ0FTRUNMRDAwNTA1NmMwMDAwODANBgkqhkiG9w0BAQEFAASBgNCJ6RhQU7lKuTg0YIDhWL2EokX0Ww2aE02yy3DBZXnoA8f4eSC69i+gy0KoeuBg4ryvXr2NrknftLPth0aAhYVn6jsXksll25WavdqJggkMGGxkj1huvzM0HI2n2brbZf0U8u+uwBm2q7veUAHcWHDeGa9RN3U5LStRYqi5F8wZ";
            boolean bverify = signUtil.p7VerifySignMessageDetached(sourceData.getBytes(), bMsgSigned1, session);
            String strMAC4 = signUtil.getSignedMAC();
            boolean bverifyy = signUtil.p7VerifySignMessage(bMsgSigned2, session);
            String strMAC5 = signUtil.getSignedMAC();
            X509Cert[] sigerX509Certs = signUtil.getSigerCert();
            int i = 0;
            while (i < sigerX509Certs.length) {
                sigerX509Certs[i].getSubject();
                ++i;
            }
        }
        catch (PKIException ex) {
            System.out.println("\u9519\u8bef\u7801:" + ex.getErrCode());
            System.out.println("\u9519\u8bef\u4fe1\u606f:" + ex.getErrDesc());
            Exception exception = ex.getHistory();
        }
        catch (Exception ex) {
            System.out.println("\u9519\u8bef:" + ex.toString());
        }
    }

    public String getSignedMAC() {
        return this.signedMAC;
    }
}

