/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.ess;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.ess.ESSCertID;
import cn.com.infosec.asn1.x509.PolicyInformation;

public class SigningCertificate
extends ASN1Encodable {
    ASN1Sequence certs;
    ASN1Sequence policies;

    public static SigningCertificate getInstance(Object object) {
        if (object == null || object instanceof SigningCertificate) {
            return (SigningCertificate)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SigningCertificate((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in 'SigningCertificate' factory : " + object.getClass().getName() + ".");
    }

    public SigningCertificate(ASN1Sequence aSN1Sequence) {
        this.certs = (ASN1Sequence)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() > 1) {
            this.policies = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
        }
    }

    public SigningCertificate(ESSCertID eSSCertID) {
        this.certs = new DERSequence(eSSCertID);
    }

    public ESSCertID[] getCerts() {
        ESSCertID[] eSSCertIDArray = new ESSCertID[this.certs.size()];
        int n = 0;
        while (n != this.certs.size()) {
            eSSCertIDArray[n] = ESSCertID.getInstance(this.certs.getObjectAt(n));
            ++n;
        }
        return eSSCertIDArray;
    }

    public PolicyInformation[] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        PolicyInformation[] policyInformationArray = new PolicyInformation[this.policies.size()];
        int n = 0;
        while (n != this.policies.size()) {
            policyInformationArray[n] = PolicyInformation.getInstance(this.policies.getObjectAt(n));
            ++n;
        }
        return policyInformationArray;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.certs);
        if (this.policies != null) {
            aSN1EncodableVector.add(this.policies);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

