/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.pkcs;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERTaggedObject;

public class CertBag
extends ASN1Encodable {
    ASN1Sequence seq;
    DERObjectIdentifier certId;
    DERObject certValue;

    public CertBag(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
        this.certId = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.certValue = ((DERTaggedObject)aSN1Sequence.getObjectAt(1)).getObject();
    }

    public CertBag(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.certId = dERObjectIdentifier;
        this.certValue = dERObject;
    }

    public DERObjectIdentifier getCertId() {
        return this.certId;
    }

    public DERObject getCertValue() {
        return this.certValue;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.certId);
        aSN1EncodableVector.add(new DERTaggedObject(0, this.certValue));
        return new DERSequence(aSN1EncodableVector);
    }
}

