/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.test;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERNull;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.oiw.ElGamalParameter;
import cn.com.infosec.asn1.oiw.OIWObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.AuthorityKeyIdentifier;
import cn.com.infosec.asn1.x509.GeneralName;
import cn.com.infosec.asn1.x509.GeneralNames;
import cn.com.infosec.asn1.x509.IssuingDistributionPoint;
import cn.com.infosec.asn1.x509.KeyUsage;
import cn.com.infosec.asn1.x509.RSAPublicKeyStructure;
import cn.com.infosec.asn1.x509.SubjectKeyIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x509.TBSCertList;
import cn.com.infosec.asn1.x509.TBSCertificateStructure;
import cn.com.infosec.asn1.x509.Time;
import cn.com.infosec.asn1.x509.V1TBSCertificateGenerator;
import cn.com.infosec.asn1.x509.V2TBSCertListGenerator;
import cn.com.infosec.asn1.x509.V3TBSCertificateGenerator;
import cn.com.infosec.asn1.x509.X509Extension;
import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.util.encoders.Base64;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class GenerationTest
implements Test {
    private byte[] v1Cert = Base64.decode("MIGtAgEBMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMTAkFVMRYwFAYDVQQKEw1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAxMlowNjELMAkGA1UEAxMCQVUxFjAUBgNVBAoTDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsTBlRlc3QgMTAaMA0GCSqGSIb3DQEBAQUAAwkAMAYCAQECAQI=");
    private byte[] v3Cert = Base64.decode("MIIBSKADAgECAgECMA0GCSqGSIb3DQEBBAUAMCUxCzAJBgNVBAMTAkFVMRYwFAYDVQQKEw1Cb3VuY3kgQ2FzdGxlMB4XDTcwMDEwMTAwMDAwMVoXDTcwMDEwMTAwMDAwMlowNjELMAkGA1UEAxMCQVUxFjAUBgNVBAoTDUJvdW5jeSBDYXN0bGUxDzANBgNVBAsTBlRlc3QgMjAYMBAGBisOBwIBATAGAgEBAgECAwQAAgEDo4GVMIGSMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTEPMA0GA1UECxMGVGVzdCAyggECMCAGA1UdDgEB/wQWBBQ2T3aRz8you6PBCaJJEFNrqgh0UTALBgNVHQ8EBAMCBBA=");
    private byte[] v2CertList = Base64.decode("MIIBRQIBATANBgkqhkiG9w0BAQUFADAlMQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZRcNNzAwMTAxMDAwMDAwWhcNNzAwMTAxMDAwMDAyWjAkMCICAQEXDTcwMDEwMTAwMDAwMVowDjAMBgNVHRUEBQoDAIAAoIHFMIHCMGEGA1UdIwEB/wRXMFWAFDZPdpHPzKi7o8EJokkQU2uqCHRRoTqkODA2MQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTEPMA0GA1UECxMGVGVzdCAyggECMEMGA1UdEgQ8MDqkODA2MQswCQYDVQQDEwJBVTEWMBQGA1UEChMNQm91bmN5IENhc3RsZTEPMA0GA1UECxMGVGVzdCAzMAoGA1UdFAQDAgEBMAwGA1UdHAEB/wQCMAA=");

    private boolean isSameAs(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n != byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private TestResult tbsV1CertGen() {
        try {
            V1TBSCertificateGenerator v1TBSCertificateGenerator = new V1TBSCertificateGenerator();
            Date date = new Date(1000L);
            Date date2 = new Date(12000L);
            v1TBSCertificateGenerator.setSerialNumber(new DERInteger(1));
            v1TBSCertificateGenerator.setStartDate(new Time(date));
            v1TBSCertificateGenerator.setEndDate(new Time(date2));
            v1TBSCertificateGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            v1TBSCertificateGenerator.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 1"));
            v1TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, new DERNull()), new RSAPublicKeyStructure(BigInteger.valueOf(1L), BigInteger.valueOf(2L)));
            v1TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
            TBSCertificateStructure tBSCertificateStructure = v1TBSCertificateGenerator.generateTBSCertificate();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(tBSCertificateStructure);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v1Cert)) {
                return new SimpleTestResult(false, this.getName() + ": failed v1 cert generation");
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.v2CertList));
            DERObject dERObject = aSN1InputStream.readObject();
            byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(dERObject);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v1 cert read back test");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": v1 cert list failed " + exception.toString(), exception);
        }
    }

    private AuthorityKeyIdentifier createAuthorityKeyId(SubjectPublicKeyInfo subjectPublicKeyInfo, X509Name x509Name, int n) {
        GeneralName generalName = new GeneralName(x509Name);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(generalName);
        return new AuthorityKeyIdentifier(subjectPublicKeyInfo, new GeneralNames(new DERSequence(aSN1EncodableVector)), BigInteger.valueOf(n));
    }

    private TestResult tbsV3CertGen() {
        try {
            V3TBSCertificateGenerator v3TBSCertificateGenerator = new V3TBSCertificateGenerator();
            Date date = new Date(1000L);
            Date date2 = new Date(2000L);
            v3TBSCertificateGenerator.setSerialNumber(new DERInteger(2));
            v3TBSCertificateGenerator.setStartDate(new Time(date));
            v3TBSCertificateGenerator.setEndDate(new Time(date2));
            v3TBSCertificateGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            v3TBSCertificateGenerator.setSubject(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"));
            v3TBSCertificateGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption, new DERNull()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
            v3TBSCertificateGenerator.setSubjectPublicKeyInfo(subjectPublicKeyInfo);
            Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
            Hashtable<DERObjectIdentifier, X509Extension> hashtable = new Hashtable<DERObjectIdentifier, X509Extension>();
            vector.addElement(X509Extensions.AuthorityKeyIdentifier);
            vector.addElement(X509Extensions.SubjectKeyIdentifier);
            vector.addElement(X509Extensions.KeyUsage);
            hashtable.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(subjectPublicKeyInfo, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
            hashtable.put(X509Extensions.SubjectKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(new SubjectKeyIdentifier(subjectPublicKeyInfo))));
            hashtable.put(X509Extensions.KeyUsage, new X509Extension(false, (ASN1OctetString)new DEROctetString(new KeyUsage(16))));
            X509Extensions x509Extensions = new X509Extensions(vector, hashtable);
            v3TBSCertificateGenerator.setExtensions(x509Extensions);
            TBSCertificateStructure tBSCertificateStructure = v3TBSCertificateGenerator.generateTBSCertificate();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(tBSCertificateStructure);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v3Cert)) {
                return new SimpleTestResult(false, this.getName() + ": failed v3 cert generation");
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.v2CertList));
            DERObject dERObject = aSN1InputStream.readObject();
            byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(dERObject);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v3 cert read back test");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": v3 cert list failed " + exception.toString(), exception);
        }
    }

    private TestResult tbsV2CertListGen() {
        try {
            V2TBSCertListGenerator v2TBSCertListGenerator = new V2TBSCertListGenerator();
            v2TBSCertListGenerator.setIssuer(new X509Name("CN=AU,O=Bouncy Castle"));
            v2TBSCertListGenerator.addCRLEntry(new DERInteger(1), new Time(new Date(1000L)), 32768);
            v2TBSCertListGenerator.setNextUpdate(new Time(new Date(2000L)));
            v2TBSCertListGenerator.setThisUpdate(new Time(new Date(500L)));
            v2TBSCertListGenerator.setSignature(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, new DERNull()));
            Vector<DERObjectIdentifier> vector = new Vector<DERObjectIdentifier>();
            Hashtable<DERObjectIdentifier, X509Extension> hashtable = new Hashtable<DERObjectIdentifier, X509Extension>();
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(BigInteger.valueOf(1L), BigInteger.valueOf(2L))), new DERInteger(3));
            vector.addElement(X509Extensions.AuthorityKeyIdentifier);
            vector.addElement(X509Extensions.IssuerAlternativeName);
            vector.addElement(X509Extensions.CRLNumber);
            vector.addElement(X509Extensions.IssuingDistributionPoint);
            hashtable.put(X509Extensions.AuthorityKeyIdentifier, new X509Extension(true, (ASN1OctetString)new DEROctetString(this.createAuthorityKeyId(subjectPublicKeyInfo, new X509Name("CN=AU,O=Bouncy Castle,OU=Test 2"), 2))));
            hashtable.put(X509Extensions.IssuerAlternativeName, new X509Extension(false, (ASN1OctetString)new DEROctetString(new GeneralNames(new DERSequence(new GeneralName(new X509Name("CN=AU,O=Bouncy Castle,OU=Test 3")))))));
            hashtable.put(X509Extensions.CRLNumber, new X509Extension(false, (ASN1OctetString)new DEROctetString(new DERInteger(1))));
            hashtable.put(X509Extensions.IssuingDistributionPoint, new X509Extension(true, (ASN1OctetString)new DEROctetString(new IssuingDistributionPoint(new DERSequence()))));
            X509Extensions x509Extensions = new X509Extensions(vector, hashtable);
            v2TBSCertListGenerator.setExtensions(x509Extensions);
            TBSCertList tBSCertList = v2TBSCertListGenerator.generateTBSCertList();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(tBSCertList);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v2 cert list generation");
            }
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(this.v2CertList));
            DERObject dERObject = aSN1InputStream.readObject();
            byteArrayOutputStream = new ByteArrayOutputStream();
            aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(dERObject);
            if (!this.isSameAs(byteArrayOutputStream.toByteArray(), this.v2CertList)) {
                return new SimpleTestResult(false, this.getName() + ": failed v2 cert list read back test");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": v2 cert list failed " + exception.toString(), exception);
        }
    }

    public TestResult perform() {
        TestResult testResult = this.tbsV1CertGen();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.tbsV3CertGen();
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return this.tbsV2CertListGen();
    }

    public String getName() {
        return "Generation";
    }

    public static void main(String[] stringArray) {
        GenerationTest generationTest = new GenerationTest();
        TestResult testResult = generationTest.perform();
        System.out.println(testResult);
    }
}

