/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class DSAParameter
extends ASN1Encodable {
    DERInteger p;
    DERInteger q;
    DERInteger g;

    public static DSAParameter getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DSAParameter.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static DSAParameter getInstance(Object object) {
        if (object == null || object instanceof DSAParameter) {
            return (DSAParameter)object;
        }
        if (object instanceof ASN1Sequence) {
            return new DSAParameter((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid DSAParameter: " + object.getClass().getName());
    }

    public DSAParameter(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = new DERInteger(bigInteger);
        this.q = new DERInteger(bigInteger2);
        this.g = new DERInteger(bigInteger3);
    }

    public DSAParameter(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.p = (DERInteger)enumeration.nextElement();
        this.q = (DERInteger)enumeration.nextElement();
        this.g = (DERInteger)enumeration.nextElement();
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.p);
        aSN1EncodableVector.add(this.q);
        aSN1EncodableVector.add(this.g);
        return new DERSequence(aSN1EncodableVector);
    }
}

