/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.x509;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DERSequence;

public class PolicyInformation
extends ASN1Encodable {
    private DERObjectIdentifier policyIdentifier;
    private ASN1Sequence policyQualifiers;

    public PolicyInformation(ASN1Sequence aSN1Sequence) {
        this.policyIdentifier = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        if (aSN1Sequence.size() > 1) {
            this.policyQualifiers = (ASN1Sequence)aSN1Sequence.getObjectAt(1);
        }
    }

    public PolicyInformation(DERObjectIdentifier dERObjectIdentifier) {
        this.policyIdentifier = dERObjectIdentifier;
    }

    public PolicyInformation(DERObjectIdentifier dERObjectIdentifier, ASN1Sequence aSN1Sequence) {
        this.policyIdentifier = dERObjectIdentifier;
        this.policyQualifiers = aSN1Sequence;
    }

    public static PolicyInformation getInstance(Object object) {
        if (object == null || object instanceof PolicyInformation) {
            return (PolicyInformation)object;
        }
        return new PolicyInformation(ASN1Sequence.getInstance(object));
    }

    public DERObjectIdentifier getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public ASN1Sequence getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.policyIdentifier);
        if (this.policyQualifiers != null) {
            aSN1EncodableVector.add(this.policyQualifiers);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

