/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.crypto.test;

import cn.com.infosec.crypto.AsymmetricCipherKeyPair;
import cn.com.infosec.crypto.agreement.DHAgreement;
import cn.com.infosec.crypto.agreement.DHBasicAgreement;
import cn.com.infosec.crypto.generators.DHBasicKeyPairGenerator;
import cn.com.infosec.crypto.generators.DHKeyPairGenerator;
import cn.com.infosec.crypto.generators.DHParametersGenerator;
import cn.com.infosec.crypto.params.DHKeyGenerationParameters;
import cn.com.infosec.crypto.params.DHParameters;
import cn.com.infosec.crypto.params.DHPrivateKeyParameters;
import cn.com.infosec.crypto.params.DHPublicKeyParameters;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DHTest
implements Test {
    private BigInteger g512 = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
    private BigInteger p512 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
    private BigInteger g768 = new BigInteger("7c240073c1316c621df461b71ebb0cdcc90a6e5527e5e126633d131f87461c4dc4afc60c2cb0f053b6758871489a69613e2a8b4c8acde23954c08c81cbd36132cfd64d69e4ed9f8e51ed6e516297206672d5c0a69135df0a5dcf010d289a9ca1", 16);
    private BigInteger p768 = new BigInteger("8c9dd223debed1b80103b8b309715be009d48860ed5ae9b9d5d8159508efd802e3ad4501a7f7e1cfec78844489148cd72da24b21eddd01aa624291c48393e277cfc529e37075eccef957f3616f962d15b44aeab4039d01b817fde9eaa12fd73f", 16);
    private BigInteger g1024 = new BigInteger("1db17639cdf96bc4eabba19454f0b7e5bd4e14862889a725c96eb61048dcd676ceb303d586e30f060dbafd8a571a39c4d823982117da5cc4e0f89c77388b7a08896362429b94a18a327604eb7ff227bffbc83459ade299e57b5f77b50fb045250934938efa145511166e3197373e1b5b1e52de713eb49792bedde722c6717abf", 16);
    private BigInteger p1024 = new BigInteger("a00e283b3c624e5b2b4d9fbc2653b5185d99499b00fd1bf244c6f0bb817b4d1c451b2958d62a0f8a38caef059fb5ecd25d75ed9af403f5b5bdab97a642902f824e3c13789fed95fa106ddfe0ff4a707c85e2eb77d49e68f2808bcea18ce128b178cd287c6bc00efa9a1ad2a673fe0dceace53166f75b81d6709d5f8af7c66bb7", 16);

    public String getName() {
        return "DH";
    }

    private TestResult testGP(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        DHParameters dHParameters = new DHParameters(bigInteger2, bigInteger);
        DHKeyGenerationParameters dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), dHParameters);
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(dHKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters2 = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters2 = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DHAgreement dHAgreement = new DHAgreement();
        DHAgreement dHAgreement2 = new DHAgreement();
        dHAgreement.init(dHPrivateKeyParameters);
        dHAgreement2.init(dHPrivateKeyParameters2);
        BigInteger bigInteger3 = dHAgreement.calculateMessage();
        BigInteger bigInteger4 = dHAgreement2.calculateMessage();
        BigInteger bigInteger5 = dHAgreement.calculateAgreement(dHPublicKeyParameters2, bigInteger4);
        BigInteger bigInteger6 = dHAgreement2.calculateAgreement(dHPublicKeyParameters, bigInteger3);
        if (!bigInteger5.equals(bigInteger6)) {
            return new SimpleTestResult(false, n + " bit 2-way test failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    private TestResult testSimple(int n, BigInteger bigInteger, BigInteger bigInteger2) {
        DHParameters dHParameters = new DHParameters(bigInteger2, bigInteger);
        DHKeyGenerationParameters dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), dHParameters);
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(dHKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters2 = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters2 = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        DHBasicAgreement dHBasicAgreement2 = new DHBasicAgreement();
        dHBasicAgreement.init(dHPrivateKeyParameters);
        dHBasicAgreement2.init(dHPrivateKeyParameters2);
        BigInteger bigInteger3 = dHBasicAgreement.calculateAgreement(dHPublicKeyParameters2);
        BigInteger bigInteger4 = dHBasicAgreement2.calculateAgreement(dHPublicKeyParameters);
        if (!bigInteger3.equals(bigInteger4)) {
            return new SimpleTestResult(false, "basic " + n + " bit 2-way test failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    private TestResult testGeneration(int n) {
        DHParametersGenerator dHParametersGenerator = new DHParametersGenerator();
        dHParametersGenerator.init(n, 10, new SecureRandom());
        DHParameters dHParameters = dHParametersGenerator.generateParameters();
        DHKeyGenerationParameters dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), dHParameters);
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(dHKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), dHPublicKeyParameters.getParameters());
        dHBasicKeyPairGenerator.init(dHKeyGenerationParameters);
        asymmetricCipherKeyPair = dHBasicKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters2 = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters2 = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        DHBasicAgreement dHBasicAgreement2 = new DHBasicAgreement();
        dHBasicAgreement.init(dHPrivateKeyParameters);
        dHBasicAgreement2.init(dHPrivateKeyParameters2);
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(dHPublicKeyParameters2);
        BigInteger bigInteger2 = dHBasicAgreement2.calculateAgreement(dHPublicKeyParameters);
        if (!bigInteger.equals(bigInteger2)) {
            return new SimpleTestResult(false, "basic " + n + " bit 2-way test failed");
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        TestResult testResult = this.testSimple(512, this.g512, this.p512);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testSimple(768, this.g768, this.p768);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testSimple(1024, this.g1024, this.p1024);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testGP(512, this.g512, this.p512);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testGP(768, this.g768, this.p768);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testGP(1024, this.g1024, this.p1024);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testGeneration(256);
        return testResult;
    }

    public static void main(String[] stringArray) {
        DHTest dHTest = new DHTest();
        TestResult testResult = dHTest.perform();
        System.out.println(testResult);
    }
}

