/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DEREncodableVector;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.DERSet;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.SignedData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class PKIXCertPath
extends CertPath {
    static final List certPathEncodings;
    private List certificates;

    PKIXCertPath(List list) {
        super("X.509");
        this.certificates = new ArrayList(list);
    }

    PKIXCertPath(InputStream inputStream, String string) throws CertificateException {
        block8: {
            super("X.509");
            try {
                if (string.equals("PkiPath")) {
                    ASN1InputStream aSN1InputStream = new ASN1InputStream(inputStream);
                    DERObject dERObject = aSN1InputStream.readObject();
                    if (dERObject == null || !(dERObject instanceof ASN1Sequence)) {
                        throw new CertificateException("input stream does not contain a ASN1 SEQUENCE while reading PkiPath encoded data to load CertPath");
                    }
                    Enumeration enumeration = ((ASN1Sequence)dERObject).getObjects();
                    this.certificates = new ArrayList();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "INFOSEC");
                    while (enumeration.hasMoreElements()) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
                        dEROutputStream.writeObject(enumeration.nextElement());
                        dEROutputStream.close();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                        this.certificates.add(0, certificateFactory.generateCertificate(byteArrayInputStream));
                    }
                    break block8;
                }
                if (string.equals("PKCS7")) {
                    this.certificates = new ArrayList();
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "INFOSEC");
                    Certificate certificate = null;
                    while ((certificate = certificateFactory.generateCertificate(inputStream)) != null) {
                        this.certificates.add(certificate);
                    }
                    break block8;
                }
                throw new CertificateException("unsupported encoding: " + string);
            }
            catch (IOException iOException) {
                throw new CertificateException("IOException throw while decoding CertPath:\n" + iOException.toString());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new CertificateException("BouncyCastle provider not found while trying to get a CertificateFactory:\n" + noSuchProviderException.toString());
            }
        }
    }

    public Iterator getEncodings() {
        return certPathEncodings.iterator();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        Object e;
        Iterator iterator = this.getEncodings();
        if (iterator.hasNext() && (e = iterator.next()) instanceof String) {
            return this.getEncoded((String)e);
        }
        return null;
    }

    public byte[] getEncoded(String string) throws CertificateEncodingException {
        Object object;
        Object object2;
        DERObject dERObject = null;
        if (string.equals("PkiPath")) {
            object2 = new ASN1EncodableVector();
            object = this.certificates.listIterator(this.certificates.size());
            while (object.hasPrevious()) {
                ((DEREncodableVector)object2).add(this.getEncodedX509Certificate((X509Certificate)object.previous()));
            }
            dERObject = new DERSequence((DEREncodableVector)object2);
        } else if (string.equals("PKCS7")) {
            Object object3;
            object2 = new ContentInfo(PKCSObjectIdentifiers.data, null);
            object = new ASN1EncodableVector();
            int n = 0;
            while (n != this.certificates.size()) {
                object3 = new ASN1InputStream(((X509Certificate)this.certificates.get(n)).getEncoded());
                try {
                    ((DEREncodableVector)object).add(((ASN1InputStream)object3).readObject());
                }
                catch (Exception exception) {
                    throw new CertificateEncodingException("can't parse certificate");
                }
                ++n;
            }
            object3 = new SignedData(new DERInteger(1), new DERSet(), (ContentInfo)object2, new DERSet((DEREncodableVector)object), null, new DERSet());
            dERObject = new ContentInfo(PKCSObjectIdentifiers.signedData, (DEREncodable)object3).toASN1Object();
        } else {
            throw new CertificateEncodingException("unsupported encoding");
        }
        if (dERObject == null) {
            return null;
        }
        object2 = new ByteArrayOutputStream();
        object = new DEROutputStream((OutputStream)object2);
        try {
            ((DEROutputStream)object).writeObject(dERObject);
            ((FilterOutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("IOExeption thrown: " + iOException.toString());
        }
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    public List getCertificates() {
        return new ArrayList(this.certificates);
    }

    private DERObject getEncodedX509Certificate(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(x509Certificate.getEncoded());
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException("IOException caught while encoding certificate\n" + iOException.toString());
        }
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("PkiPath");
        arrayList.add("PKCS7");
        certPathEncodings = Collections.unmodifiableList(arrayList);
    }
}

