/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.ocsp;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OutputStream;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.ocsp.ResponderID;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.ocsp.OCSPException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;

public class RespID {
    ResponderID id;

    public RespID(ResponderID responderID) {
        this.id = responderID;
    }

    public RespID(X500Principal x500Principal) {
        try {
            this.id = new ResponderID(new X509Principal(x500Principal.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't decode name.");
        }
    }

    public RespID(PublicKey publicKey) throws OCSPException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(subjectPublicKeyInfo.getPublicKey());
            messageDigest.update(byteArrayOutputStream.toByteArray());
            DEROctetString dEROctetString = new DEROctetString(messageDigest.digest());
            this.id = new ResponderID(dEROctetString);
        }
        catch (Exception exception) {
            throw new OCSPException("problem creating ID: " + exception, exception);
        }
    }

    public ResponderID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RespID)) {
            return false;
        }
        RespID respID = (RespID)object;
        return this.id.equals(respID.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

