/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.openssl.test;

import cn.com.infosec.asn1.cms.CMSObjectIdentifiers;
import cn.com.infosec.asn1.cms.ContentInfo;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.openssl.PEMReader;
import cn.com.infosec.openssl.PasswordFinder;
import cn.com.infosec.util.test.SimpleTestResult;
import cn.com.infosec.util.test.Test;
import cn.com.infosec.util.test.TestResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.Security;

public class ReaderTest
implements Test {
    public String getName() {
        return "PEMReaderTest";
    }

    public TestResult perform() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("test.pem")));
        Password password = new Password("secret".toCharArray());
        PEMReader pEMReader = new PEMReader((Reader)bufferedReader, password);
        try {
            Object object;
            Object object2;
            while ((object2 = pEMReader.readObject()) != null) {
                if (!(object2 instanceof KeyPair)) continue;
                object = (KeyPair)object2;
            }
            bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("pkcs7.pem")));
            pEMReader = new PEMReader(bufferedReader);
            object = (ContentInfo)pEMReader.readObject();
            if (!((ContentInfo)object).getContentType().equals(CMSObjectIdentifiers.envelopedData)) {
                return new SimpleTestResult(false, this.getName() + ": failed envelopedData check");
            }
        }
        catch (IOException iOException) {
            return new SimpleTestResult(false, this.getName() + ": exception - " + iOException.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new InfosecProvider());
        ReaderTest readerTest = new ReaderTest();
        TestResult testResult = readerTest.perform();
        System.out.println(testResult.toString());
    }

    private static class Password
    implements PasswordFinder {
        char[] password;

        Password(char[] cArray) {
            this.password = cArray;
        }

        public char[] getPassword() {
            return this.password;
        }
    }
}

