/*
 * Decompiled with CFR 0.152.
 */
package cn.sm2_cert_parse;

import cn.sm2_cert_parse.PKCS12_SM2;
import cn.sm2_cert_parse.X509Cert_SM2;
import cn.win_trust_erpc.Util;
import java.io.FileInputStream;
import java.math.BigInteger;

public class CertUtil_SM2 {
    public static final X509Cert_SM2 rootCert = null;
    public static byte[] sm2PriKey = null;
    public static byte[] sm2PubKey = null;
    public static byte[] certData = null;
    public static BigInteger priKeyBig = null;
    public static String certId = null;
    public static X509Cert_SM2 encryptCert = null;

    public static void init(String pubPath, String priPath, String pwd) {
        try {
            CertUtil_SM2.initSignCert(priPath, pwd);
            CertUtil_SM2.initVerifyCert(pubPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initSignCert(String path, String pwd) throws Exception {
        byte[] arrayOfByte = CertUtil_SM2.getSM2File(path);
        PKCS12_SM2 P12 = new PKCS12_SM2(arrayOfByte);
        priKeyBig = P12.getPrivateKey(pwd);
        X509Cert_SM2 cert = P12.getPublicCert()[0];
        String tenCertId = cert.getCert().getSerialNumber().toString();
        BigInteger nb = new BigInteger(tenCertId, 10);
        certId = nb.toString(16);
        System.out.println("certId\ufebf" + certId);
    }

    public static void initSignCertB64(String sm2Cert, String pwd) throws Exception {
        byte[] arrayOfByte = sm2Cert.getBytes();
        PKCS12_SM2 P12 = new PKCS12_SM2(arrayOfByte);
        priKeyBig = P12.getPrivateKey(pwd);
        sm2PriKey = priKeyBig.toByteArray();
        X509Cert_SM2 cert = P12.getPublicCert()[0];
        sm2PubKey = Util.hexToByte("04" + Util.byteToHex(cert.getPublicKey()));
        certData = cert.getCert().getEncoded();
    }

    public static byte[] getSM2File(String filePath) throws Exception {
        int rLength;
        FileInputStream crls = new FileInputStream(filePath);
        byte[] out = new byte[crls.available()];
        byte[] buffer = new byte[65536];
        int offset = 0;
        while ((rLength = crls.read(buffer, 0, buffer.length)) != -1) {
            System.arraycopy(buffer, 0, out, offset, rLength);
            offset += rLength;
        }
        byte[] arrayOfByte1 = out;
        crls.close();
        return arrayOfByte1;
    }

    public static BigInteger getPrivateKey() {
        return priKeyBig;
    }

    public static String getCertId() {
        return certId;
    }

    public static byte[] getEncryptPubKey() {
        return encryptCert.getPublicKey();
    }

    public static X509Cert_SM2 getEncryptCert() {
        return encryptCert;
    }

    public static X509Cert_SM2 getRootCert() {
        return rootCert;
    }

    public static void initVerifyCert(String pubPath) throws Exception {
    }

    public static byte[] getSm2PriKey() {
        return sm2PriKey;
    }

    public static void setSm2PriKey(byte[] sm2PriKey) {
        CertUtil_SM2.sm2PriKey = sm2PriKey;
    }

    public static byte[] getSm2PubKey() {
        return sm2PubKey;
    }

    public static void setSm2PubKey(byte[] sm2PubKey) {
        CertUtil_SM2.sm2PubKey = sm2PubKey;
    }
}

