/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc;

import cn.win_trust_erpc.SM2;
import cn.win_trust_erpc.SM2Utils;
import cn.win_trust_erpc.Util;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Encodable;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Integer;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1OctetString;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Set;
import cn.win_trust_erpc.bouncycastle.asn1.BEROctetString;
import cn.win_trust_erpc.bouncycastle.asn1.BERSet;
import cn.win_trust_erpc.bouncycastle.asn1.DEROctetString;
import cn.win_trust_erpc.bouncycastle.asn1.DERSet;
import cn.win_trust_erpc.bouncycastle.asn1.DLSequence;
import cn.win_trust_erpc.bouncycastle.asn1.DLSet;
import cn.win_trust_erpc.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.cms.ContentInfo;
import cn.win_trust_erpc.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cn.win_trust_erpc.bouncycastle.asn1.cms.SignedData;
import cn.win_trust_erpc.bouncycastle.asn1.cms.SignerIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.cms.SignerInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.Certificate;
import cn.win_trust_erpc.bouncycastle.cert.X509CertificateHolder;
import cn.win_trust_erpc.bouncycastle.cert.jcajce.JcaCertStore;
import cn.win_trust_erpc.bouncycastle.cms.CMSProcessableByteArray;
import cn.win_trust_erpc.bouncycastle.cms.CMSSignedData;
import cn.win_trust_erpc.bouncycastle.cms.CMSSignedDataGenerator;
import cn.win_trust_erpc.bouncycastle.cms.SignerInfoGeneratorBuilder;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.signers.SM2Signer;
import cn.win_trust_erpc.bouncycastle.jce.provider.BouncyCastleProvider;
import cn.win_trust_erpc.bouncycastle.operator.ContentSigner;
import cn.win_trust_erpc.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import cn.win_trust_erpc.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import cn.win_trust_erpc.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import cn.win_trust_erpc.bouncycastle.operator.bc.BcSM2ContentSignerBuilder;
import cn.win_trust_erpc.bouncycastle.util.encoders.Base64;
import java.math.BigInteger;
import java.security.Security;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class PKCS7Signer {
    public static byte[] generatePKCS7SignatureSM2(boolean attach, byte[] message, byte[] certbytes, byte[] privateKey) throws Exception {
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);
        ECPrivateKeyParameters ecpp = new ECPrivateKeyParameters(userD, sm2.ecdp);
        ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier("1.2.156.10197.1.301.1");
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(asn1ObjectIdentifier);
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find("SM3");
        X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(certbytes);
        Certificate certificate = Certificate.getInstance(certbytes);
        SignerIdentifier signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber(x509CertificateHolder.toASN1Structure()));
        LinkedHashSet<AlgorithmIdentifier> digestAlgs = new LinkedHashSet<AlgorithmIdentifier>();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        ASN1ObjectIdentifier contentTypeOID = CMSObjectIdentifiers.dataSM2;
        SignerInfo signerInfo = null;
        ASN1Set signedAttr = null;
        SM2Signer sm2Signer = new SM2Signer();
        sm2Signer.init(true, ecpp);
        sm2Signer.update(message, 0, message.length);
        byte[] signature = sm2Signer.generateSignature();
        signedAttr = null;
        signerInfo = new SignerInfo(signerIdentifier, digAlgId, signedAttr, algorithmIdentifier, (ASN1OctetString)new DEROctetString(signature), null);
        digestAlgs.add(signerInfo.getDigestAlgorithm());
        signerInfos.add(signerInfo);
        BERSet certificates = null;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(certificate);
        certificates = new BERSet(v);
        ASN1Set certrevlist = null;
        DLSet dlset = new DLSet(digestAlgs.toArray(new AlgorithmIdentifier[digestAlgs.size()]));
        ContentInfo encInfo = null;
        encInfo = attach ? new ContentInfo(contentTypeOID, new BEROctetString(message)) : new ContentInfo(contentTypeOID, null);
        SignedData signedData = new SignedData(dlset, encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedDataSM2, signedData);
        return contentInfo.getEncoded();
    }

    public static byte[] getItemPKCS7SignatureSM2(byte[] p7SignedMessage, int type) throws Exception {
        ContentInfo contentInfo = ContentInfo.getInstance(p7SignedMessage);
        ASN1ObjectIdentifier signedDataSM2ASN1ObjectIdentifier = contentInfo.getContentType();
        ASN1Encodable asn1Encodable = contentInfo.getContent();
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find("SM3");
        ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier("1.2.156.10197.1.301.1");
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(asn1ObjectIdentifier);
        SignedData signedData = SignedData.getInstance(asn1Encodable);
        ASN1Set certASN1Set = signedData.getCertificates();
        ASN1Encodable sm3ASN1Encodable = signedData.getDigestAlgorithms().getObjectAt(0);
        ASN1Set signerInfoASN1Set = signedData.getSignerInfos();
        DLSequence signerInfoDLSequence = (DLSequence)signerInfoASN1Set.getObjectAt(0);
        ASN1Integer signerInfoVersionASN1Integer = (ASN1Integer)signerInfoDLSequence.getObjectAt(0);
        DLSequence signerInfoSubjectDLSequence = (DLSequence)signerInfoDLSequence.getObjectAt(1);
        DLSequence signerInfoDigestAlgDLSequence = (DLSequence)signerInfoDLSequence.getObjectAt(2);
        DLSequence signerInfoSignatureAlgDLSequence = (DLSequence)signerInfoDLSequence.getObjectAt(3);
        DEROctetString signatureDerOctetString = (DEROctetString)signerInfoDLSequence.getObjectAt(4);
        ContentInfo encapContentInfo = signedData.getEncapContentInfo();
        ASN1Encodable contentASN1Encodable = encapContentInfo.getContent();
        DEROctetString derOctetString = (DEROctetString)contentASN1Encodable;
        byte[] signature = signatureDerOctetString.getOctets();
        DLSequence certificateDLSequence = (DLSequence)certASN1Set.getObjectAt(0);
        byte[] certbytes = certificateDLSequence.getEncoded();
        if (1 == type) {
            if (derOctetString != null) {
                return derOctetString.getOctets();
            }
            return null;
        }
        if (2 == type) {
            return certbytes;
        }
        if (3 == type) {
            return signature;
        }
        return null;
    }

    public static byte[] constructPKCS7SignatureSM2(byte[] message, byte[] certbytes, byte[] signature) throws Exception {
        ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier("1.2.156.10197.1.301.1");
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(asn1ObjectIdentifier);
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find("SM3");
        X509CertificateHolder x509CertificateHolder = new X509CertificateHolder(certbytes);
        Certificate certificate = Certificate.getInstance(certbytes);
        SignerIdentifier signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber(x509CertificateHolder.toASN1Structure()));
        LinkedHashSet<AlgorithmIdentifier> digestAlgs = new LinkedHashSet<AlgorithmIdentifier>();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        ASN1ObjectIdentifier contentTypeOID = CMSObjectIdentifiers.dataSM2;
        SignerInfo signerInfo = null;
        ASN1Set signedAttr = null;
        signedAttr = null;
        signerInfo = new SignerInfo(signerIdentifier, digAlgId, signedAttr, algorithmIdentifier, (ASN1OctetString)new DEROctetString(signature), null);
        digestAlgs.add(signerInfo.getDigestAlgorithm());
        signerInfos.add(signerInfo);
        BERSet certificates = null;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(certificate);
        certificates = new BERSet(v);
        ASN1Set certrevlist = null;
        DLSet dlset = new DLSet(digestAlgs.toArray(new AlgorithmIdentifier[digestAlgs.size()]));
        ContentInfo encInfo = null;
        encInfo = message != null ? new ContentInfo(contentTypeOID, new BEROctetString(message)) : new ContentInfo(contentTypeOID, null);
        SignedData signedData = new SignedData(dlset, encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedDataSM2, signedData);
        return contentInfo.getEncoded();
    }

    static byte[] getrs(byte[] in) {
        int pos;
        byte[] r = null;
        byte[] s = null;
        byte[] out = null;
        if (48 != in[0]) {
            return null;
        }
        if (2 != in[2]) {
            return null;
        }
        if (33 == in[3]) {
            r = new byte[32];
            System.arraycopy(in, 5, r, 0, 32);
        } else if (32 == in[3]) {
            pos = 4;
            while (in[pos] == 0) {
                if ((in[pos + 1] & 0xFF) >= 128) break;
                ++pos;
            }
            r = new byte[32 - (pos - 4)];
            System.arraycopy(in, pos, r, 0, r.length);
        } else if (32 > in[3]) {
            r = new byte[in[3]];
            System.arraycopy(in, 4, r, 0, in[3]);
        }
        int index = 4 + in[3];
        if (2 != in[index]) {
            return null;
        }
        if (33 == in[++index]) {
            s = new byte[32];
            System.arraycopy(in, index += 2, s, 0, 32);
        } else if (32 == in[index]) {
            pos = index + 1;
            while (in[pos] == 0) {
                if ((in[pos + 1] & 0xFF) >= 128) break;
                ++pos;
            }
            s = new byte[32 - (pos - index - 1)];
            System.arraycopy(in, pos, s, 0, s.length);
        } else if (32 > in[index]) {
            s = new byte[in[index]];
            System.arraycopy(in, index + 1, s, 0, in[index]);
        } else {
            return null;
        }
        int outLen = r.length + s.length;
        if (r.length == 32 && (r[0] & 0xFF) >= 128) {
            ++outLen;
        }
        if (s.length == 32 && (s[0] & 0xFF) >= 128) {
            ++outLen;
        }
        out = new byte[outLen += 6];
        index = 0;
        out[index++] = 48;
        out[index++] = (byte)(outLen - 2);
        out[index++] = 2;
        if (r.length == 32 && (r[0] & 0xFF) >= 128) {
            out[index++] = 33;
            out[index] = 0;
        } else {
            out[index] = (byte)r.length;
        }
        System.arraycopy(r, 0, out, ++index, r.length);
        index += r.length;
        out[index++] = 2;
        if (s.length == 32 && (s[0] & 0xFF) >= 128) {
            out[index++] = 33;
            out[index] = 0;
        } else {
            out[index] = (byte)s.length;
        }
        System.arraycopy(s, 0, out, ++index, s.length);
        index += s.length;
        return out;
    }

    public static boolean verifyPKCS7SignatureSM2(byte[] p7SignedMessage, byte[] content) throws Exception {
        ContentInfo contentInfo = ContentInfo.getInstance(p7SignedMessage);
        ASN1ObjectIdentifier signedDataSM2ASN1ObjectIdentifier = contentInfo.getContentType();
        ASN1Encodable asn1Encodable = contentInfo.getContent();
        AlgorithmIdentifier digAlgId = new DefaultDigestAlgorithmIdentifierFinder().find("SM3");
        ASN1ObjectIdentifier asn1ObjectIdentifier = new ASN1ObjectIdentifier("1.2.156.10197.1.301.1");
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(asn1ObjectIdentifier);
        SignedData signedData = SignedData.getInstance(asn1Encodable);
        ASN1Set certASN1Set = signedData.getCertificates();
        ASN1Encodable sm3ASN1Encodable = signedData.getDigestAlgorithms().getObjectAt(0);
        digAlgId.equals(sm3ASN1Encodable);
        ASN1Set signerInfoASN1Set = signedData.getSignerInfos();
        DLSequence signerInfoDLSequence = (DLSequence)signerInfoASN1Set.getObjectAt(0);
        ASN1Integer signerInfoVersionASN1Integer = (ASN1Integer)signerInfoDLSequence.getObjectAt(0);
        DLSequence signerInfoSubjectDLSequence = (DLSequence)signerInfoDLSequence.getObjectAt(1);
        DLSequence signerInfoDigestAlgDLSequence = (DLSequence)signerInfoDLSequence.getObjectAt(2);
        DLSequence signerInfoSignatureAlgDLSequence = (DLSequence)signerInfoDLSequence.getObjectAt(3);
        DEROctetString signatureDerOctetString = (DEROctetString)signerInfoDLSequence.getObjectAt(4);
        algorithmIdentifier.equals(signerInfoSignatureAlgDLSequence);
        digAlgId.equals(signerInfoDigestAlgDLSequence);
        ContentInfo encapContentInfo = signedData.getEncapContentInfo();
        ASN1Encodable contentASN1Encodable = encapContentInfo.getContent();
        DEROctetString derOctetString = (DEROctetString)contentASN1Encodable;
        byte[] signature = signatureDerOctetString.getOctets();
        System.out.println("***** signature: " + Util.byteToHex(signature) + "\n");
        signature = PKCS7Signer.getrs(signature);
        System.out.println("***** signature: " + Util.byteToHex(signature) + "\n");
        DLSequence certificateDLSequence = (DLSequence)certASN1Set.getObjectAt(0);
        byte[] certbytes = certificateDLSequence.getEncoded();
        if (derOctetString == null) {
            return SM2Utils.VerifySinatureByCert(certbytes, content, signature);
        }
        content = derOctetString.getOctets();
        return SM2Utils.VerifySinatureByCert(certbytes, content, signature);
    }

    CMSSignedDataGenerator genGenerator(Certificate[] certchain, byte[] certbytes, AsymmetricKeyParameter prvKey) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        ArrayList<Certificate> certlist = new ArrayList<Certificate>();
        int i = 0;
        int length = certchain == null ? 0 : certchain.length;
        while (i < length) {
            certlist.add(certchain[i]);
            ++i;
        }
        JcaCertStore certstore = new JcaCertStore(certlist);
        AlgorithmIdentifier sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find("SM3withSM2");
        ContentSigner signer = new BcSM2ContentSignerBuilder(sigAlgId, sigAlgId).build(prvKey);
        CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
        SignerInfoGeneratorBuilder builder = new SignerInfoGeneratorBuilder(new BcDigestCalculatorProvider());
        generator.addSignerInfoGenerator(builder.build(signer, new X509CertificateHolder(certbytes)));
        generator.addCertificates(certstore);
        return generator;
    }

    CMSSignedDataGenerator genGenerator(Certificate[] certchain, byte[] certbytes, byte[] privateKey) throws Exception {
        SM2 sm2 = SM2.Instance();
        BigInteger userD = new BigInteger(1, privateKey);
        ECPrivateKeyParameters ecpp = new ECPrivateKeyParameters(userD, sm2.ecdp);
        return this.genGenerator(certchain, certbytes, ecpp);
    }

    byte[] signPkcs7(byte[] content, CMSSignedDataGenerator generator) throws Exception {
        CMSProcessableByteArray cmsdata = new CMSProcessableByteArray(content);
        CMSSignedData signeddata = generator.generate(cmsdata, false);
        return signeddata.getEncoded();
    }

    public static void main(String[] args) throws Exception {
        PKCS7Signer signer = new PKCS7Signer();
        String prik = "1104B2C1C2D32C3AFEB001F42D0C2EBD0C4FF9C16FF77B85CD9D84027D72DDCE";
        String pubk = "04B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773";
        byte[] testcert = Util.hexToByte("308201B73082015EA00302010202021212300A06082A811CCF550183753034310B300906035504061302434E310B300906035504030C0241413118301606092A864886F70D010901160941414061612E636F6D301E170D3232303532363032323634335A170D3235303631303032323634335A3034310B300906035504061302434E310B300906035504030C0241413118301606092A864886F70D010901160941414061612E636F6D3059301306072A8648CE3D020106082A811CCF5501822D03420004B1392BA4C22535ACF42D2B029DA2A7CF0E6C7D7B7B498AA528D35004450CE0B2250C63516BF20FCDCC1671B37C4BBA02A330D2DCED4A5241E95F92494A123773A360305E300F0603551D130101FF040530030101FF301D0603551D0E041604146BAFBA6F30371CB22D0EEE69955944BA9BC02836301F0603551D230418301680146BAFBA6F30371CB22D0EEE69955944BA9BC02836300B0603551D0F0404030201FE300A06082A811CCF55018375034700304402201E8082A6F684E7349C26A1CFCBD54FB07D00175B6FC9F24C05BBECDF18E345A5022031D3F6141CCF0F29028BF08A432A2B1694B0794CC92690DC1ED1820A3620A763");
        String content = "1";
        byte[] signedBytes = PKCS7Signer.generatePKCS7SignatureSM2(true, content.getBytes("UTF-8"), testcert, Util.hexToByte(prik));
        System.out.println("Signed Encoded Bytes: " + new String(Base64.encode(signedBytes)));
        System.out.println("Signed Encoded Bytes: " + PKCS7Signer.verifyPKCS7SignatureSM2(signedBytes, content.getBytes("UTF-8")));
        byte[] palin = PKCS7Signer.getItemPKCS7SignatureSM2(signedBytes, 1);
        byte[] cert = PKCS7Signer.getItemPKCS7SignatureSM2(signedBytes, 2);
        byte[] signature = PKCS7Signer.getItemPKCS7SignatureSM2(signedBytes, 3);
        signedBytes = PKCS7Signer.constructPKCS7SignatureSM2(palin, cert, signature);
        System.out.println("Signed Encoded Bytes: " + PKCS7Signer.verifyPKCS7SignatureSM2(signedBytes, content.getBytes("UTF-8")));
    }
}

