/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.asn1.tsp;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1Encodable;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Integer;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Object;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1TaggedObject;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.DERTaggedObject;

public class Accuracy
extends ASN1Object {
    ASN1Integer seconds;
    ASN1Integer millis;
    ASN1Integer micros;
    protected static final int MIN_MILLIS = 1;
    protected static final int MAX_MILLIS = 999;
    protected static final int MIN_MICROS = 1;
    protected static final int MAX_MICROS = 999;

    protected Accuracy() {
    }

    public Accuracy(ASN1Integer seconds, ASN1Integer millis, ASN1Integer micros) {
        int microsValue;
        int millisValue;
        if (millis != null && ((millisValue = millis.intValueExact()) < 1 || millisValue > 999)) {
            throw new IllegalArgumentException("Invalid millis field : not in (1..999)");
        }
        if (micros != null && ((microsValue = micros.intValueExact()) < 1 || microsValue > 999)) {
            throw new IllegalArgumentException("Invalid micros field : not in (1..999)");
        }
        this.seconds = seconds;
        this.millis = millis;
        this.micros = micros;
    }

    private Accuracy(ASN1Sequence seq) {
        this.seconds = null;
        this.millis = null;
        this.micros = null;
        int i = 0;
        while (i < seq.size()) {
            if (seq.getObjectAt(i) instanceof ASN1Integer) {
                this.seconds = (ASN1Integer)seq.getObjectAt(i);
            } else if (seq.getObjectAt(i) instanceof ASN1TaggedObject) {
                ASN1TaggedObject extra = (ASN1TaggedObject)seq.getObjectAt(i);
                switch (extra.getTagNo()) {
                    case 0: {
                        this.millis = ASN1Integer.getInstance(extra, false);
                        int millisValue = this.millis.intValueExact();
                        if (millisValue >= 1 && millisValue <= 999) break;
                        throw new IllegalArgumentException("Invalid millis field : not in (1..999)");
                    }
                    case 1: {
                        this.micros = ASN1Integer.getInstance(extra, false);
                        int microsValue = this.micros.intValueExact();
                        if (microsValue >= 1 && microsValue <= 999) break;
                        throw new IllegalArgumentException("Invalid micros field : not in (1..999)");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid tag number");
                    }
                }
            }
            ++i;
        }
    }

    public static Accuracy getInstance(Object o) {
        if (o instanceof Accuracy) {
            return (Accuracy)o;
        }
        if (o != null) {
            return new Accuracy(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public ASN1Integer getSeconds() {
        return this.seconds;
    }

    public ASN1Integer getMillis() {
        return this.millis;
    }

    public ASN1Integer getMicros() {
        return this.micros;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        if (this.seconds != null) {
            v.add(this.seconds);
        }
        if (this.millis != null) {
            v.add(new DERTaggedObject(false, 0, (ASN1Encodable)this.millis));
        }
        if (this.micros != null) {
            v.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.micros));
        }
        return new DERSequence(v);
    }
}

