/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.cms;

import cn.win_trust_erpc.bouncycastle.cms.CMSException;
import cn.win_trust_erpc.bouncycastle.cms.CMSProcessable;
import cn.win_trust_erpc.bouncycastle.cms.CMSReadable;
import cn.win_trust_erpc.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class CMSProcessableInputStream
implements CMSProcessable,
CMSReadable {
    private InputStream input;
    private boolean used = false;

    public CMSProcessableInputStream(InputStream input) {
        this.input = input;
    }

    @Override
    public InputStream getInputStream() {
        this.checkSingleUsage();
        return this.input;
    }

    @Override
    public void write(OutputStream zOut) throws IOException, CMSException {
        this.checkSingleUsage();
        Streams.pipeAll(this.input, zOut);
        this.input.close();
    }

    @Override
    public Object getContent() {
        return this.getInputStream();
    }

    private synchronized void checkSingleUsage() {
        if (this.used) {
            throw new IllegalStateException("CMSProcessableInputStream can only be used once");
        }
        this.used = true;
    }
}

