/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.generators;

import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.KeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import cn.win_trust_erpc.bouncycastle.crypto.params.DHParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ElGamalParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

