/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.crypto.signers;

import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.crypto.Digest;
import cn.win_trust_erpc.bouncycastle.crypto.Signer;
import cn.win_trust_erpc.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.math.ec.rfc8032.Ed25519;
import cn.win_trust_erpc.bouncycastle.util.Arrays;

public class Ed25519phSigner
implements Signer {
    private final Digest prehash = Ed25519.createPrehash();
    private final byte[] context;
    private boolean forSigning;
    private Ed25519PrivateKeyParameters privateKey;
    private Ed25519PublicKeyParameters publicKey;

    public Ed25519phSigner(byte[] context) {
        this.context = Arrays.clone(context);
    }

    @Override
    public void init(boolean forSigning, CipherParameters parameters) {
        this.forSigning = forSigning;
        if (forSigning) {
            this.privateKey = (Ed25519PrivateKeyParameters)parameters;
            this.publicKey = null;
        } else {
            this.privateKey = null;
            this.publicKey = (Ed25519PublicKeyParameters)parameters;
        }
        this.reset();
    }

    @Override
    public void update(byte b) {
        this.prehash.update(b);
    }

    @Override
    public void update(byte[] buf, int off, int len) {
        this.prehash.update(buf, off, len);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.forSigning || this.privateKey == null) {
            throw new IllegalStateException("Ed25519phSigner not initialised for signature generation.");
        }
        byte[] msg = new byte[64];
        if (64 != this.prehash.doFinal(msg, 0)) {
            throw new IllegalStateException("Prehash digest failed");
        }
        byte[] signature = new byte[64];
        this.privateKey.sign(2, this.context, msg, 0, 64, signature, 0);
        return signature;
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        if (this.forSigning || this.publicKey == null) {
            throw new IllegalStateException("Ed25519phSigner not initialised for verification");
        }
        if (64 != signature.length) {
            this.prehash.reset();
            return false;
        }
        byte[] pk = this.publicKey.getEncoded();
        return Ed25519.verifyPrehash(signature, 0, pk, 0, this.context, this.prehash);
    }

    @Override
    public void reset() {
        this.prehash.reset();
    }
}

