/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric;

import cn.win_trust_erpc.bouncycastle.crypto.BlockCipher;
import cn.win_trust_erpc.bouncycastle.crypto.CipherKeyGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.CryptoServicesRegistrar;
import cn.win_trust_erpc.bouncycastle.crypto.engines.Shacal2Engine;
import cn.win_trust_erpc.bouncycastle.crypto.macs.CMac;
import cn.win_trust_erpc.bouncycastle.crypto.modes.CBCBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class Shacal2 {
    private Shacal2() {
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        @Override
        protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for Shacal2 parameter generation.");
        }

        @Override
        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters params;
            byte[] iv = new byte[32];
            if (this.random == null) {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.random.nextBytes(iv);
            try {
                params = this.createParametersInstance("Shacal2");
                params.init(new IvParameterSpec(iv));
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            return params;
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Shacal2 IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new Shacal2Engine()), 256);
        }
    }

    public static class CMAC
    extends BaseMac {
        public CMAC() {
            super(new CMac(new Shacal2Engine()));
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new Shacal2Engine();
                }
            });
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("SHACAL-2", 128, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Shacal2.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Mac.Shacal-2CMAC", String.valueOf(PREFIX) + "$CMAC");
            provider.addAlgorithm("Cipher.Shacal2", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher.SHACAL-2", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("KeyGenerator.Shacal2", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameterGenerator.Shacal2", String.valueOf(PREFIX) + "$AlgParamGen");
            provider.addAlgorithm("AlgorithmParameters.Shacal2", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("KeyGenerator.SHACAL-2", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameterGenerator.SHACAL-2", String.valueOf(PREFIX) + "$AlgParamGen");
            provider.addAlgorithm("AlgorithmParameters.SHACAL-2", String.valueOf(PREFIX) + "$AlgParams");
        }
    }
}

