/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jce.provider;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1InputStream;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Set;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1TaggedObject;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.SignedData;
import cn.win_trust_erpc.bouncycastle.asn1.x509.CertificateList;
import cn.win_trust_erpc.bouncycastle.jce.provider.PEMUtil;
import cn.win_trust_erpc.bouncycastle.jce.provider.X509CRLObject;
import cn.win_trust_erpc.bouncycastle.x509.X509StreamParserSpi;
import cn.win_trust_erpc.bouncycastle.x509.util.StreamParsingException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.util.ArrayList;
import java.util.Collection;

public class X509CRLParser
extends X509StreamParserSpi {
    private static final PEMUtil PEM_PARSER = new PEMUtil("CRL");
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;

    private CRL readDERCRL(InputStream in) throws IOException, CRLException {
        ASN1InputStream dIn = new ASN1InputStream(in);
        ASN1Sequence seq = (ASN1Sequence)dIn.readObject();
        if (seq.size() > 1 && seq.getObjectAt(0) instanceof ASN1ObjectIdentifier && seq.getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(1), true)).getCRLs();
            return this.getCRL();
        }
        return new X509CRLObject(CertificateList.getInstance(seq));
    }

    private CRL getCRL() throws CRLException {
        if (this.sData == null || this.sDataObjectCount >= this.sData.size()) {
            return null;
        }
        return new X509CRLObject(CertificateList.getInstance(this.sData.getObjectAt(this.sDataObjectCount++)));
    }

    private CRL readPEMCRL(InputStream in) throws IOException, CRLException {
        ASN1Sequence seq = PEM_PARSER.readPEMObject(in);
        if (seq != null) {
            return new X509CRLObject(CertificateList.getInstance(seq));
        }
        return null;
    }

    @Override
    public void engineInit(InputStream in) {
        this.currentStream = in;
        this.sData = null;
        this.sDataObjectCount = 0;
        if (!this.currentStream.markSupported()) {
            this.currentStream = new BufferedInputStream(this.currentStream);
        }
    }

    @Override
    public Object engineRead() throws StreamParsingException {
        int tag;
        block7: {
            block6: {
                try {
                    if (this.sData == null) break block6;
                    if (this.sDataObjectCount != this.sData.size()) {
                        return this.getCRL();
                    }
                    this.sData = null;
                    this.sDataObjectCount = 0;
                    return null;
                }
                catch (Exception e) {
                    throw new StreamParsingException(e.toString(), e);
                }
            }
            this.currentStream.mark(10);
            tag = this.currentStream.read();
            if (tag != -1) break block7;
            return null;
        }
        if (tag != 48) {
            this.currentStream.reset();
            return this.readPEMCRL(this.currentStream);
        }
        this.currentStream.reset();
        return this.readDERCRL(this.currentStream);
    }

    @Override
    public Collection engineReadAll() throws StreamParsingException {
        CRL crl;
        ArrayList<CRL> certs = new ArrayList<CRL>();
        while ((crl = (CRL)this.engineRead()) != null) {
            certs.add(crl);
        }
        return certs;
    }
}

