/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.jsse.provider;

import cn.win_trust_erpc.bouncycastle.jsse.provider.BcTlsCryptoProvider;
import cn.win_trust_erpc.bouncycastle.jsse.provider.ProvSSLContextSpi;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCryptoProvider;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

class DefaultSSLContextSpi
extends ProvSSLContextSpi {
    private static final Logger LOG = Logger.getLogger(DefaultSSLContextSpi.class.getName());

    private static Exception avoidCapturingException(Exception e) {
        return new KeyManagementException(e.getMessage());
    }

    static ProvSSLContextSpi getDefaultInstance() throws Exception {
        if (LazyInstance.initException != null) {
            throw LazyInstance.initException;
        }
        return LazyInstance.instance;
    }

    static ProvSSLContextSpi getDefaultInstance(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws Exception {
        if (LazyInstance.initException != null) {
            throw LazyInstance.initException;
        }
        LazyInstance.instance.engineInit(kms, tms, sr);
        return LazyInstance.instance;
    }

    DefaultSSLContextSpi(boolean isInFipsMode, TlsCryptoProvider cryptoProvider) throws KeyManagementException {
        super(isInFipsMode, cryptoProvider, null);
        if (LazyManagers.initException != null) {
            throw new KeyManagementException("Default key/trust managers unavailable", LazyManagers.initException);
        }
        super.engineInit(LazyManagers.keyManagers, LazyManagers.trustManagers, new SecureRandom());
    }

    @Override
    protected void engineInit(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        super.engineInit(kms, tms, sr);
    }

    private static class LazyInstance {
        private static final Exception initException;
        private static final DefaultSSLContextSpi instance;

        static {
            Exception ex = LazyManagers.initException;
            DefaultSSLContextSpi i = null;
            if (ex == null) {
                try {
                    i = new DefaultSSLContextSpi(false, new BcTlsCryptoProvider());
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to load default SSLContext", e);
                    ex = DefaultSSLContextSpi.avoidCapturingException(e);
                }
            }
            initException = ex;
            instance = i;
        }

        private LazyInstance() {
        }
    }

    private static class LazyManagers {
        private static final Exception initException;
        private static final KeyManager[] keyManagers;
        private static final TrustManager[] trustManagers;

        static {
            Exception ex = null;
            KeyManager[] kms = null;
            TrustManager[] tms = null;
            try {
                tms = ProvSSLContextSpi.getDefaultTrustManagers();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to load default trust managers", e);
                ex = e;
            }
            if (ex == null) {
                try {
                    kms = ProvSSLContextSpi.getDefaultKeyManagers();
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to load default key managers", e);
                    ex = e;
                }
            }
            if (ex != null) {
                ex = DefaultSSLContextSpi.avoidCapturingException(ex);
                kms = null;
                tms = null;
            }
            initException = ex;
            keyManagers = kms;
            trustManagers = tms;
        }

        private LazyManagers() {
        }
    }
}

