/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.operator.jcajce;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1EncodableVector;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Integer;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Sequence;
import cn.win_trust_erpc.bouncycastle.asn1.DERBitString;
import cn.win_trust_erpc.bouncycastle.asn1.DERNull;
import cn.win_trust_erpc.bouncycastle.asn1.DERSequence;
import cn.win_trust_erpc.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.jcajce.CompositePrivateKey;
import cn.win_trust_erpc.bouncycastle.jcajce.io.OutputStreamFactory;
import cn.win_trust_erpc.bouncycastle.jcajce.spec.CompositeAlgorithmSpec;
import cn.win_trust_erpc.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import cn.win_trust_erpc.bouncycastle.jcajce.util.NamedJcaJceHelper;
import cn.win_trust_erpc.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import cn.win_trust_erpc.bouncycastle.operator.ContentSigner;
import cn.win_trust_erpc.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import cn.win_trust_erpc.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import cn.win_trust_erpc.bouncycastle.operator.OperatorCreationException;
import cn.win_trust_erpc.bouncycastle.operator.RuntimeOperatorException;
import cn.win_trust_erpc.bouncycastle.operator.jcajce.OperatorHelper;
import cn.win_trust_erpc.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.List;

public class JcaContentSignerBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private String signatureAlgorithm;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmParameterSpec sigAlgSpec;

    public JcaContentSignerBuilder(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.sigAlgId = new DefaultSignatureAlgorithmIdentifierFinder().find(signatureAlgorithm);
        this.sigAlgSpec = null;
    }

    public JcaContentSignerBuilder(String signatureAlgorithm, AlgorithmParameterSpec sigParamSpec) {
        this.signatureAlgorithm = signatureAlgorithm;
        if (sigParamSpec instanceof PSSParameterSpec) {
            PSSParameterSpec pssSpec = (PSSParameterSpec)sigParamSpec;
            this.sigAlgSpec = pssSpec;
            this.sigAlgId = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, JcaContentSignerBuilder.createPSSParams(pssSpec));
        } else if (sigParamSpec instanceof CompositeAlgorithmSpec) {
            CompositeAlgorithmSpec compSpec = (CompositeAlgorithmSpec)sigParamSpec;
            this.sigAlgSpec = compSpec;
            this.sigAlgId = new AlgorithmIdentifier(MiscObjectIdentifiers.id_alg_composite, JcaContentSignerBuilder.createCompParams(compSpec));
        } else {
            throw new IllegalArgumentException("unknown sigParamSpec: " + (sigParamSpec == null ? "null" : sigParamSpec.getClass().getName()));
        }
    }

    public JcaContentSignerBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaContentSignerBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        return this;
    }

    public JcaContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public ContentSigner build(PrivateKey privateKey) throws OperatorCreationException {
        if (privateKey instanceof CompositePrivateKey) {
            return this.buildComposite((CompositePrivateKey)privateKey);
        }
        try {
            final Signature sig = this.helper.createSignature(this.sigAlgId);
            final AlgorithmIdentifier signatureAlgId = this.sigAlgId;
            if (this.random != null) {
                sig.initSign(privateKey, this.random);
            } else {
                sig.initSign(privateKey);
            }
            return new ContentSigner(){
                private OutputStream stream;
                {
                    this.stream = OutputStreamFactory.createStream(signature);
                }

                @Override
                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return signatureAlgId;
                }

                @Override
                public OutputStream getOutputStream() {
                    return this.stream;
                }

                @Override
                public byte[] getSignature() {
                    try {
                        return sig.sign();
                    }
                    catch (SignatureException e) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                    }
                }
            };
        }
        catch (GeneralSecurityException e) {
            throw new OperatorCreationException("cannot create signer: " + e.getMessage(), e);
        }
    }

    private ContentSigner buildComposite(CompositePrivateKey privateKey) throws OperatorCreationException {
        try {
            List<PrivateKey> privateKeys = privateKey.getPrivateKeys();
            ASN1Sequence sigAlgIds = ASN1Sequence.getInstance(this.sigAlgId.getParameters());
            final Signature[] sigs = new Signature[sigAlgIds.size()];
            int i = 0;
            while (i != sigAlgIds.size()) {
                sigs[i] = this.helper.createSignature(AlgorithmIdentifier.getInstance(sigAlgIds.getObjectAt(i)));
                if (this.random != null) {
                    sigs[i].initSign(privateKeys.get(i), this.random);
                } else {
                    sigs[i].initSign(privateKeys.get(i));
                }
                ++i;
            }
            OutputStream sStream = OutputStreamFactory.createStream(sigs[0]);
            int i2 = 1;
            while (i2 != sigs.length) {
                sStream = new TeeOutputStream(sStream, OutputStreamFactory.createStream(sigs[i2]));
                ++i2;
            }
            OutputStream sigStream = sStream;
            return new ContentSigner(sigStream){
                OutputStream stream;
                {
                    this.stream = outputStream;
                }

                @Override
                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return JcaContentSignerBuilder.this.sigAlgId;
                }

                @Override
                public OutputStream getOutputStream() {
                    return this.stream;
                }

                @Override
                public byte[] getSignature() {
                    try {
                        ASN1EncodableVector sigV = new ASN1EncodableVector();
                        int i = 0;
                        while (i != sigs.length) {
                            sigV.add(new DERBitString(sigs[i].sign()));
                            ++i;
                        }
                        return new DERSequence(sigV).getEncoded("DER");
                    }
                    catch (IOException e) {
                        throw new RuntimeOperatorException("exception encoding signature: " + e.getMessage(), e);
                    }
                    catch (SignatureException e) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                    }
                }
            };
        }
        catch (GeneralSecurityException e) {
            throw new OperatorCreationException("cannot create signer: " + e.getMessage(), e);
        }
    }

    private static RSASSAPSSparams createPSSParams(PSSParameterSpec pssSpec) {
        AlgorithmIdentifier mgfDig;
        DefaultDigestAlgorithmIdentifierFinder digFinder = new DefaultDigestAlgorithmIdentifierFinder();
        AlgorithmIdentifier digId = digFinder.find(pssSpec.getDigestAlgorithm());
        if (digId.getParameters() == null) {
            digId = new AlgorithmIdentifier(digId.getAlgorithm(), DERNull.INSTANCE);
        }
        if ((mgfDig = digFinder.find(((MGF1ParameterSpec)pssSpec.getMGFParameters()).getDigestAlgorithm())).getParameters() == null) {
            mgfDig = new AlgorithmIdentifier(mgfDig.getAlgorithm(), DERNull.INSTANCE);
        }
        return new RSASSAPSSparams(digId, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, mgfDig), new ASN1Integer(pssSpec.getSaltLength()), new ASN1Integer(pssSpec.getTrailerField()));
    }

    private static ASN1Sequence createCompParams(CompositeAlgorithmSpec compSpec) {
        DefaultSignatureAlgorithmIdentifierFinder algFinder = new DefaultSignatureAlgorithmIdentifierFinder();
        ASN1EncodableVector v = new ASN1EncodableVector();
        List<String> algorithmNames = compSpec.getAlgorithmNames();
        List<AlgorithmParameterSpec> algorithmSpecs = compSpec.getParameterSpecs();
        int i = 0;
        while (i != algorithmNames.size()) {
            AlgorithmParameterSpec sigSpec = algorithmSpecs.get(i);
            if (sigSpec == null) {
                v.add(algFinder.find(algorithmNames.get(i)));
            } else if (sigSpec instanceof PSSParameterSpec) {
                v.add(JcaContentSignerBuilder.createPSSParams((PSSParameterSpec)sigSpec));
            } else {
                throw new IllegalArgumentException("unrecognized parameterSpec");
            }
            ++i;
        }
        return new DERSequence(v);
    }
}

