/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pkcs.bc;

import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.crypto.CipherParameters;
import cn.win_trust_erpc.bouncycastle.crypto.ExtendedDigest;
import cn.win_trust_erpc.bouncycastle.crypto.digests.SHA1Digest;
import cn.win_trust_erpc.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import cn.win_trust_erpc.bouncycastle.crypto.io.CipherInputStream;
import cn.win_trust_erpc.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cn.win_trust_erpc.bouncycastle.operator.GenericKey;
import cn.win_trust_erpc.bouncycastle.operator.InputDecryptor;
import cn.win_trust_erpc.bouncycastle.operator.InputDecryptorProvider;
import cn.win_trust_erpc.bouncycastle.pkcs.bc.PKCS12PBEUtils;
import java.io.InputStream;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest digest) {
        this.digest = digest;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher engine = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters params = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, engine.getBlockSize(), pbeParams, password);
                engine.init(false, params);
                return new InputDecryptor(){

                    @Override
                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    @Override
                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, engine);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
                    }
                };
            }
        };
    }
}

