/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.util;

import cn.win_trust_erpc.bouncycastle.asn1.ASN1InputStream;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1ObjectIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1OctetString;
import cn.win_trust_erpc.bouncycastle.asn1.ASN1Primitive;
import cn.win_trust_erpc.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.McElieceCCA2PublicKey;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.SPHINCS256KeyParams;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.XMSSKeyParams;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.XMSSMTKeyParams;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.XMSSPublicKey;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.HSSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.sphincs.SPHINCSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.util.Utils;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.Pack;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class PublicKeyFactory {
    private static Map converters = new HashMap();

    static {
        converters.put(PQCObjectIdentifiers.qTESLA_p_I, new QTeslaConverter());
        converters.put(PQCObjectIdentifiers.qTESLA_p_III, new QTeslaConverter());
        converters.put(PQCObjectIdentifiers.sphincs256, new SPHINCSConverter());
        converters.put(PQCObjectIdentifiers.newHope, new NHConverter());
        converters.put(PQCObjectIdentifiers.xmss, new XMSSConverter());
        converters.put(PQCObjectIdentifiers.xmss_mt, new XMSSMTConverter());
        converters.put(IsaraObjectIdentifiers.id_alg_xmss, new XMSSConverter());
        converters.put(IsaraObjectIdentifiers.id_alg_xmssmt, new XMSSMTConverter());
        converters.put(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig, new LMSConverter());
        converters.put(PQCObjectIdentifiers.mcElieceCca2, new McElieceCCA2Converter());
    }

    public static AsymmetricKeyParameter createKey(byte[] keyInfoData) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(keyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PublicKeyFactory.createKey(SubjectPublicKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        return PublicKeyFactory.createKey(keyInfo, null);
    }

    public static AsymmetricKeyParameter createKey(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithm();
        SubjectPublicKeyInfoConverter converter = (SubjectPublicKeyInfoConverter)converters.get(algId.getAlgorithm());
        if (converter != null) {
            return converter.getPublicKeyParameters(keyInfo, defaultParams);
        }
        throw new IOException("algorithm identifier in public key not recognised: " + algId.getAlgorithm());
    }

    private static class LMSConverter
    extends SubjectPublicKeyInfoConverter {
        private LMSConverter() {
        }

        @Override
        AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
            byte[] keyEnc = ASN1OctetString.getInstance(keyInfo.parsePublicKey()).getOctets();
            if (Pack.bigEndianToInt(keyEnc, 0) == 1) {
                return LMSPublicKeyParameters.getInstance(Arrays.copyOfRange(keyEnc, 4, keyEnc.length));
            }
            if (keyEnc.length == 64) {
                keyEnc = Arrays.copyOfRange(keyEnc, 4, keyEnc.length);
            }
            return HSSPublicKeyParameters.getInstance(keyEnc);
        }
    }

    private static class McElieceCCA2Converter
    extends SubjectPublicKeyInfoConverter {
        private McElieceCCA2Converter() {
        }

        @Override
        AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
            McElieceCCA2PublicKey mKey = McElieceCCA2PublicKey.getInstance(keyInfo.parsePublicKey());
            return new McElieceCCA2PublicKeyParameters(mKey.getN(), mKey.getT(), mKey.getG(), Utils.getDigestName(mKey.getDigest().getAlgorithm()));
        }
    }

    private static class NHConverter
    extends SubjectPublicKeyInfoConverter {
        private NHConverter() {
        }

        @Override
        AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
            return new NHPublicKeyParameters(keyInfo.getPublicKeyData().getBytes());
        }
    }

    private static class QTeslaConverter
    extends SubjectPublicKeyInfoConverter {
        private QTeslaConverter() {
        }

        @Override
        AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
            return new QTESLAPublicKeyParameters(Utils.qTeslaLookupSecurityCategory(keyInfo.getAlgorithm()), keyInfo.getPublicKeyData().getOctets());
        }
    }

    private static class SPHINCSConverter
    extends SubjectPublicKeyInfoConverter {
        private SPHINCSConverter() {
        }

        @Override
        AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
            return new SPHINCSPublicKeyParameters(keyInfo.getPublicKeyData().getBytes(), Utils.sphincs256LookupTreeAlgName(SPHINCS256KeyParams.getInstance(keyInfo.getAlgorithm().getParameters())));
        }
    }

    private static abstract class SubjectPublicKeyInfoConverter {
        private SubjectPublicKeyInfoConverter() {
        }

        abstract AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo var1, Object var2) throws IOException;
    }

    private static class XMSSConverter
    extends SubjectPublicKeyInfoConverter {
        private XMSSConverter() {
        }

        @Override
        AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
            XMSSKeyParams keyParams = XMSSKeyParams.getInstance(keyInfo.getAlgorithm().getParameters());
            if (keyParams != null) {
                ASN1ObjectIdentifier treeDigest = keyParams.getTreeDigest().getAlgorithm();
                XMSSPublicKey xmssPublicKey = XMSSPublicKey.getInstance(keyInfo.parsePublicKey());
                return new XMSSPublicKeyParameters.Builder(new XMSSParameters(keyParams.getHeight(), Utils.getDigest(treeDigest))).withPublicSeed(xmssPublicKey.getPublicSeed()).withRoot(xmssPublicKey.getRoot()).build();
            }
            byte[] keyEnc = ASN1OctetString.getInstance(keyInfo.parsePublicKey()).getOctets();
            return new XMSSPublicKeyParameters.Builder(XMSSParameters.lookupByOID(Pack.bigEndianToInt(keyEnc, 0))).withPublicKey(keyEnc).build();
        }
    }

    private static class XMSSMTConverter
    extends SubjectPublicKeyInfoConverter {
        private XMSSMTConverter() {
        }

        @Override
        AsymmetricKeyParameter getPublicKeyParameters(SubjectPublicKeyInfo keyInfo, Object defaultParams) throws IOException {
            XMSSMTKeyParams keyParams = XMSSMTKeyParams.getInstance(keyInfo.getAlgorithm().getParameters());
            if (keyParams != null) {
                ASN1ObjectIdentifier treeDigest = keyParams.getTreeDigest().getAlgorithm();
                XMSSPublicKey xmssMtPublicKey = XMSSPublicKey.getInstance(keyInfo.parsePublicKey());
                return new XMSSMTPublicKeyParameters.Builder(new XMSSMTParameters(keyParams.getHeight(), keyParams.getLayers(), Utils.getDigest(treeDigest))).withPublicSeed(xmssMtPublicKey.getPublicSeed()).withRoot(xmssMtPublicKey.getRoot()).build();
            }
            byte[] keyEnc = ASN1OctetString.getInstance(keyInfo.parsePublicKey()).getOctets();
            return new XMSSMTPublicKeyParameters.Builder(XMSSMTParameters.lookupByOID(Pack.bigEndianToInt(keyEnc, 0))).withPublicKey(keyEnc).build();
        }
    }
}

