/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss;

import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.Encodable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class XMSSMTSignature
implements XMSSStoreableObjectInterface,
Encodable {
    private final XMSSMTParameters params;
    private final long index;
    private final byte[] random;
    private final List<XMSSReducedSignature> reducedSignatures;

    private XMSSMTSignature(Builder builder) {
        this.params = builder.params;
        if (this.params == null) {
            throw new NullPointerException("params == null");
        }
        int n = this.params.getTreeDigestSize();
        byte[] signature = builder.signature;
        if (signature != null) {
            int reducedSignatureSizeSingle;
            int reducedSignaturesSizeTotal;
            int randomSize;
            int len = this.params.getWOTSPlus().getParams().getLen();
            int indexSize = (int)Math.ceil((double)this.params.getHeight() / 8.0);
            int totalSize = indexSize + (randomSize = n) + (reducedSignaturesSizeTotal = (reducedSignatureSizeSingle = (this.params.getHeight() / this.params.getLayers() + len) * n) * this.params.getLayers());
            if (signature.length != totalSize) {
                throw new IllegalArgumentException("signature has wrong size");
            }
            int position = 0;
            this.index = XMSSUtil.bytesToXBigEndian(signature, position, indexSize);
            if (!XMSSUtil.isIndexValid(this.params.getHeight(), this.index)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.random = XMSSUtil.extractBytesAtOffset(signature, position += indexSize, randomSize);
            position += randomSize;
            this.reducedSignatures = new ArrayList<XMSSReducedSignature>();
            while (position < signature.length) {
                XMSSReducedSignature xmssSig = new XMSSReducedSignature.Builder(this.params.getXMSSParameters()).withReducedSignature(XMSSUtil.extractBytesAtOffset(signature, position, reducedSignatureSizeSingle)).build();
                this.reducedSignatures.add(xmssSig);
                position += reducedSignatureSizeSingle;
            }
        } else {
            this.index = builder.index;
            byte[] tmpRandom = builder.random;
            if (tmpRandom != null) {
                if (tmpRandom.length != n) {
                    throw new IllegalArgumentException("size of random needs to be equal to size of digest");
                }
                this.random = tmpRandom;
            } else {
                this.random = new byte[n];
            }
            List<Object> tmpReducedSignatures = builder.reducedSignatures;
            this.reducedSignatures = tmpReducedSignatures != null ? tmpReducedSignatures : new ArrayList<XMSSReducedSignature>();
        }
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.toByteArray();
    }

    @Override
    public byte[] toByteArray() {
        int n = this.params.getTreeDigestSize();
        int len = this.params.getWOTSPlus().getParams().getLen();
        int indexSize = (int)Math.ceil((double)this.params.getHeight() / 8.0);
        int randomSize = n;
        int reducedSignatureSizeSingle = (this.params.getHeight() / this.params.getLayers() + len) * n;
        int reducedSignaturesSizeTotal = reducedSignatureSizeSingle * this.params.getLayers();
        int totalSize = indexSize + randomSize + reducedSignaturesSizeTotal;
        byte[] out = new byte[totalSize];
        int position = 0;
        byte[] indexBytes = XMSSUtil.toBytesBigEndian(this.index, indexSize);
        XMSSUtil.copyBytesAtOffset(out, indexBytes, position);
        XMSSUtil.copyBytesAtOffset(out, this.random, position += indexSize);
        position += randomSize;
        for (XMSSReducedSignature reducedSignature : this.reducedSignatures) {
            byte[] signature = reducedSignature.toByteArray();
            XMSSUtil.copyBytesAtOffset(out, signature, position);
            position += reducedSignatureSizeSingle;
        }
        return out;
    }

    public long getIndex() {
        return this.index;
    }

    public byte[] getRandom() {
        return XMSSUtil.cloneArray(this.random);
    }

    public List<XMSSReducedSignature> getReducedSignatures() {
        return this.reducedSignatures;
    }

    /* synthetic */ XMSSMTSignature(Builder builder, XMSSMTSignature xMSSMTSignature) {
        this(builder);
    }

    public static class Builder {
        private final XMSSMTParameters params;
        private long index = 0L;
        private byte[] random = null;
        private List<XMSSReducedSignature> reducedSignatures = null;
        private byte[] signature = null;

        public Builder(XMSSMTParameters params) {
            this.params = params;
        }

        public Builder withIndex(long val) {
            this.index = val;
            return this;
        }

        public Builder withRandom(byte[] val) {
            this.random = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withReducedSignatures(List<XMSSReducedSignature> val) {
            this.reducedSignatures = val;
            return this;
        }

        public Builder withSignature(byte[] val) {
            this.signature = Arrays.clone(val);
            return this;
        }

        public XMSSMTSignature build() {
            return new XMSSMTSignature(this, null);
        }
    }
}

