/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.newhope;

import cn.win_trust_erpc.bouncycastle.crypto.params.AsymmetricKeyParameter;
import cn.win_trust_erpc.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.ExchangePair;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.newhope.NHAgreement;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.newhope.NHExchangePairGenerator;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.newhope.BCNHPrivateKey;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.newhope.BCNHPublicKey;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.ShortBufferException;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private NHAgreement agreement;
    private BCNHPublicKey otherPartyKey;
    private NHExchangePairGenerator exchangePairGenerator;
    private byte[] shared;

    public KeyAgreementSpi() {
        super("NH", null);
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (key != null) {
            this.agreement = new NHAgreement();
            this.agreement.init(((BCNHPrivateKey)key).getKeyParams());
        } else {
            this.exchangePairGenerator = new NHExchangePairGenerator(secureRandom);
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("NewHope does not require parameters");
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (!lastPhase) {
            throw new IllegalStateException("NewHope can only be between two parties.");
        }
        this.otherPartyKey = (BCNHPublicKey)key;
        if (this.exchangePairGenerator != null) {
            ExchangePair exchPair = this.exchangePairGenerator.generateExchange((AsymmetricKeyParameter)this.otherPartyKey.getKeyParams());
            this.shared = exchPair.getSharedValue();
            return new BCNHPublicKey((NHPublicKeyParameters)exchPair.getPublicKey());
        }
        this.shared = this.agreement.calculateAgreement(this.otherPartyKey.getKeyParams());
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        byte[] rv = Arrays.clone(this.shared);
        Arrays.fill(this.shared, (byte)0);
        return rv;
    }

    @Override
    protected int engineGenerateSecret(byte[] bytes, int offset) throws IllegalStateException, ShortBufferException {
        System.arraycopy(this.shared, 0, bytes, offset, this.shared.length);
        Arrays.fill(this.shared, (byte)0);
        return this.shared.length;
    }

    @Override
    protected byte[] calcSecret() {
        return this.engineGenerateSecret();
    }
}

