/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.qtesla;

import cn.win_trust_erpc.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cn.win_trust_erpc.bouncycastle.crypto.CryptoServicesRegistrar;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAKeyGenerationParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAKeyPairGenerator;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.qtesla.QTESLASecurityCategory;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPrivateKey;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.qtesla.BCqTESLAPublicKey;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.spec.QTESLAParameterSpec;
import cn.win_trust_erpc.bouncycastle.util.Integers;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static final Map catLookup = new HashMap();
    private QTESLAKeyGenerationParameters param;
    private QTESLAKeyPairGenerator engine = new QTESLAKeyPairGenerator();
    private SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    private boolean initialised = false;

    static {
        catLookup.put(QTESLASecurityCategory.getName(5), Integers.valueOf(5));
        catLookup.put(QTESLASecurityCategory.getName(6), Integers.valueOf(6));
    }

    public KeyPairGeneratorSpi() {
        super("qTESLA");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof QTESLAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a QTESLAParameterSpec");
        }
        QTESLAParameterSpec qteslaParams = (QTESLAParameterSpec)params;
        this.param = new QTESLAKeyGenerationParameters((Integer)catLookup.get(qteslaParams.getSecurityCategory()), random);
        this.engine.init(this.param);
        this.initialised = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new QTESLAKeyGenerationParameters(6, this.random);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        QTESLAPublicKeyParameters pub = (QTESLAPublicKeyParameters)pair.getPublic();
        QTESLAPrivateKeyParameters priv = (QTESLAPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCqTESLAPublicKey(pub), new BCqTESLAPrivateKey(priv));
    }
}

