/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.pqc.jcajce.provider.rainbow;

import cn.win_trust_erpc.bouncycastle.asn1.DERNull;
import cn.win_trust_erpc.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cn.win_trust_erpc.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import cn.win_trust_erpc.bouncycastle.pqc.asn1.RainbowPrivateKey;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.rainbow.Layer;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import cn.win_trust_erpc.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import cn.win_trust_erpc.bouncycastle.pqc.jcajce.spec.RainbowPrivateKeySpec;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.Arrays;

public class BCRainbowPrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private short[][] A1inv;
    private short[] b1;
    private short[][] A2inv;
    private short[] b2;
    private Layer[] layers;
    private int[] vi;

    public BCRainbowPrivateKey(short[][] A1inv, short[] b1, short[][] A2inv, short[] b2, int[] vi, Layer[] layers) {
        this.A1inv = A1inv;
        this.b1 = b1;
        this.A2inv = A2inv;
        this.b2 = b2;
        this.vi = vi;
        this.layers = layers;
    }

    public BCRainbowPrivateKey(RainbowPrivateKeySpec keySpec) {
        this(keySpec.getInvA1(), keySpec.getB1(), keySpec.getInvA2(), keySpec.getB2(), keySpec.getVi(), keySpec.getLayers());
    }

    public BCRainbowPrivateKey(RainbowPrivateKeyParameters params) {
        this(params.getInvA1(), params.getB1(), params.getInvA2(), params.getB2(), params.getVi(), params.getLayers());
    }

    public short[][] getInvA1() {
        return this.A1inv;
    }

    public short[] getB1() {
        return this.b1;
    }

    public short[] getB2() {
        return this.b2;
    }

    public short[][] getInvA2() {
        return this.A2inv;
    }

    public Layer[] getLayers() {
        return this.layers;
    }

    public int[] getVi() {
        return this.vi;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BCRainbowPrivateKey)) {
            return false;
        }
        BCRainbowPrivateKey otherKey = (BCRainbowPrivateKey)other;
        boolean eq = true;
        eq = eq && RainbowUtil.equals(this.A1inv, otherKey.getInvA1());
        eq = eq && RainbowUtil.equals(this.A2inv, otherKey.getInvA2());
        eq = eq && RainbowUtil.equals(this.b1, otherKey.getB1());
        eq = eq && RainbowUtil.equals(this.b2, otherKey.getB2());
        boolean bl = eq = eq && Arrays.equals(this.vi, otherKey.getVi());
        if (this.layers.length != otherKey.getLayers().length) {
            return false;
        }
        int i = this.layers.length - 1;
        while (i >= 0) {
            eq &= this.layers[i].equals(otherKey.getLayers()[i]);
            --i;
        }
        return eq;
    }

    public int hashCode() {
        int hash = this.layers.length;
        hash = hash * 37 + cn.win_trust_erpc.bouncycastle.util.Arrays.hashCode(this.A1inv);
        hash = hash * 37 + cn.win_trust_erpc.bouncycastle.util.Arrays.hashCode(this.b1);
        hash = hash * 37 + cn.win_trust_erpc.bouncycastle.util.Arrays.hashCode(this.A2inv);
        hash = hash * 37 + cn.win_trust_erpc.bouncycastle.util.Arrays.hashCode(this.b2);
        hash = hash * 37 + cn.win_trust_erpc.bouncycastle.util.Arrays.hashCode(this.vi);
        int i = this.layers.length - 1;
        while (i >= 0) {
            hash = hash * 37 + this.layers[i].hashCode();
            --i;
        }
        return hash;
    }

    @Override
    public final String getAlgorithm() {
        return "Rainbow";
    }

    @Override
    public byte[] getEncoded() {
        PrivateKeyInfo pki;
        RainbowPrivateKey privateKey = new RainbowPrivateKey(this.A1inv, this.b1, this.A2inv, this.b2, this.vi, this.layers);
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.rainbow, DERNull.INSTANCE);
            pki = new PrivateKeyInfo(algorithmIdentifier, privateKey);
        }
        catch (IOException e) {
            return null;
        }
        try {
            byte[] encoded = pki.getEncoded();
            return encoded;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }
}

