/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.DTLSReplayWindow;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsCipher;
import java.io.IOException;

class DTLSEpoch {
    private final DTLSReplayWindow replayWindow = new DTLSReplayWindow();
    private final int epoch;
    private final TlsCipher cipher;
    private long sequenceNumber = 0L;

    DTLSEpoch(int epoch, TlsCipher cipher) {
        if (epoch < 0) {
            throw new IllegalArgumentException("'epoch' must be >= 0");
        }
        if (cipher == null) {
            throw new IllegalArgumentException("'cipher' cannot be null");
        }
        this.epoch = epoch;
        this.cipher = cipher;
    }

    synchronized long allocateSequenceNumber() throws IOException {
        if (this.sequenceNumber >= 0x1000000000000L) {
            throw new TlsFatalAlert(80);
        }
        return this.sequenceNumber++;
    }

    TlsCipher getCipher() {
        return this.cipher;
    }

    int getEpoch() {
        return this.epoch;
    }

    DTLSReplayWindow getReplayWindow() {
        return this.replayWindow;
    }

    synchronized long getSequenceNumber() {
        return this.sequenceNumber;
    }

    synchronized void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}

