/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.Certificate;
import cn.win_trust_erpc.bouncycastle.tls.DTLSRecordLayer;
import cn.win_trust_erpc.bouncycastle.tls.DTLSReliableHandshake;
import cn.win_trust_erpc.bouncycastle.tls.MaxFragmentLength;
import cn.win_trust_erpc.bouncycastle.tls.SecurityParameters;
import cn.win_trust_erpc.bouncycastle.tls.TlsContext;
import cn.win_trust_erpc.bouncycastle.tls.TlsExtensionsUtils;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsProtocol;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;

public abstract class DTLSProtocol {
    protected DTLSProtocol() {
    }

    protected void processFinished(byte[] body2, byte[] expected_verify_data) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(body2);
        byte[] verify_data = TlsUtils.readFully(expected_verify_data.length, (InputStream)buf);
        TlsProtocol.assertEmpty(buf);
        if (!Arrays.constantTimeAreEqual(expected_verify_data, verify_data)) {
            throw new TlsFatalAlert(40);
        }
    }

    protected static void applyMaxFragmentLengthExtension(DTLSRecordLayer recordLayer, short maxFragmentLength) throws IOException {
        if (maxFragmentLength >= 0) {
            if (!MaxFragmentLength.isValid(maxFragmentLength)) {
                throw new TlsFatalAlert(80);
            }
            int plainTextLimit = 1 << 8 + maxFragmentLength;
            recordLayer.setPlaintextLimit(plainTextLimit);
        }
    }

    protected static short evaluateMaxFragmentLengthExtension(boolean resumedSession, Hashtable clientExtensions, Hashtable serverExtensions, short alertDescription) throws IOException {
        short maxFragmentLength = TlsExtensionsUtils.getMaxFragmentLengthExtension(serverExtensions);
        if (maxFragmentLength >= 0 && (!MaxFragmentLength.isValid(maxFragmentLength) || !resumedSession && maxFragmentLength != TlsExtensionsUtils.getMaxFragmentLengthExtension(clientExtensions))) {
            throw new TlsFatalAlert(alertDescription);
        }
        return maxFragmentLength;
    }

    protected static byte[] generateCertificate(TlsContext context, Certificate certificate, OutputStream endPointHash) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        certificate.encode(context, buf, endPointHash);
        return buf.toByteArray();
    }

    protected static byte[] generateSupplementalData(Vector supplementalData) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        TlsProtocol.writeSupplementalData(buf, supplementalData);
        return buf.toByteArray();
    }

    protected static void sendCertificateMessage(TlsContext context, DTLSReliableHandshake handshake, Certificate certificate, OutputStream endPointHash) throws IOException {
        SecurityParameters securityParameters = context.getSecurityParametersHandshake();
        if (securityParameters.getLocalCertificate() != null) {
            throw new TlsFatalAlert(80);
        }
        if (certificate == null) {
            certificate = Certificate.EMPTY_CHAIN;
        }
        byte[] certificateBody = DTLSProtocol.generateCertificate(context, certificate, endPointHash);
        handshake.sendMessage((short)11, certificateBody);
        securityParameters.localCertificate = certificate;
    }

    protected static int validateSelectedCipherSuite(int selectedCipherSuite, short alertDescription) throws IOException {
        switch (TlsUtils.getEncryptionAlgorithm(selectedCipherSuite)) {
            case -1: 
            case 1: 
            case 2: {
                throw new TlsFatalAlert(alertDescription);
            }
        }
        return selectedCipherSuite;
    }
}

