/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.TlsSRPConfigVerifier;
import cn.win_trust_erpc.bouncycastle.tls.crypto.SRP6Group;
import cn.win_trust_erpc.bouncycastle.tls.crypto.SRP6StandardGroups;
import cn.win_trust_erpc.bouncycastle.tls.crypto.TlsSRPConfig;
import java.math.BigInteger;
import java.util.Vector;

public class DefaultTlsSRPConfigVerifier
implements TlsSRPConfigVerifier {
    private static final Vector DEFAULT_GROUPS = new Vector();
    protected final Vector groups;

    static {
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1024);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1536);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_2048);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_3072);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_4096);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_6144);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_8192);
    }

    public DefaultTlsSRPConfigVerifier() {
        this(DEFAULT_GROUPS);
    }

    public DefaultTlsSRPConfigVerifier(Vector groups) {
        this.groups = new Vector(groups);
    }

    @Override
    public boolean accept(TlsSRPConfig srpConfig) {
        int i = 0;
        while (i < this.groups.size()) {
            if (this.areGroupsEqual(srpConfig, (SRP6Group)this.groups.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean areGroupsEqual(TlsSRPConfig a, SRP6Group b) {
        BigInteger[] ng = a.getExplicitNG();
        return this.areParametersEqual(ng[0], b.getN()) && this.areParametersEqual(ng[1], b.getG());
    }

    protected boolean areParametersEqual(BigInteger a, BigInteger b) {
        return a == b || a.equals(b);
    }
}

