/*
 * Decompiled with CFR 0.152.
 */
package cn.win_trust_erpc.bouncycastle.tls;

import cn.win_trust_erpc.bouncycastle.tls.ServerName;
import cn.win_trust_erpc.bouncycastle.tls.TlsFatalAlert;
import cn.win_trust_erpc.bouncycastle.tls.TlsUtils;
import cn.win_trust_erpc.bouncycastle.util.Arrays;
import cn.win_trust_erpc.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ServerNameList {
    protected Vector serverNameList;

    public ServerNameList(Vector serverNameList) {
        if (serverNameList == null) {
            throw new NullPointerException("'serverNameList' cannot be null");
        }
        this.serverNameList = serverNameList;
    }

    public Vector getServerNameList() {
        return this.serverNameList;
    }

    public void encode(OutputStream output) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        short[] nameTypesSeen = TlsUtils.EMPTY_SHORTS;
        int i = 0;
        while (i < this.serverNameList.size()) {
            ServerName entry = (ServerName)this.serverNameList.elementAt(i);
            if ((nameTypesSeen = ServerNameList.checkNameType(nameTypesSeen, entry.getNameType())) == null) {
                throw new TlsFatalAlert(80);
            }
            entry.encode(buf);
            ++i;
        }
        TlsUtils.checkUint16(buf.size());
        TlsUtils.writeUint16(buf.size(), output);
        Streams.writeBufTo(buf, output);
    }

    public static ServerNameList parse(InputStream input) throws IOException {
        byte[] data = TlsUtils.readOpaque16(input, 1);
        ByteArrayInputStream buf = new ByteArrayInputStream(data);
        short[] nameTypesSeen = TlsUtils.EMPTY_SHORTS;
        Vector<ServerName> server_name_list = new Vector<ServerName>();
        while (buf.available() > 0) {
            ServerName entry = ServerName.parse(buf);
            if ((nameTypesSeen = ServerNameList.checkNameType(nameTypesSeen, entry.getNameType())) == null) {
                throw new TlsFatalAlert(47);
            }
            server_name_list.addElement(entry);
        }
        return new ServerNameList(server_name_list);
    }

    private static short[] checkNameType(short[] nameTypesSeen, short nameType) {
        if (Arrays.contains(nameTypesSeen, nameType)) {
            return null;
        }
        return Arrays.append(nameTypesSeen, nameType);
    }
}

